/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mns.client.impl.queue;

import com.aliyun.mns.client.impl.AbstractAction;
import com.aliyun.mns.common.ClientException;
import com.aliyun.mns.common.HttpMethod;
import com.aliyun.mns.common.auth.ServiceCredentials;
import com.aliyun.mns.common.http.ExceptionResultParser;
import com.aliyun.mns.common.http.RequestMessage;
import com.aliyun.mns.common.http.ResponseMessage;
import com.aliyun.mns.common.http.ServiceClient;
import com.aliyun.mns.common.parser.ResultParseException;
import com.aliyun.mns.common.parser.ResultParser;
import com.aliyun.mns.model.Message;
import com.aliyun.mns.model.request.queue.BatchSendMessageRequest;
import com.aliyun.mns.model.serialize.queue.ErrorMessageListDeserializer;
import com.aliyun.mns.model.serialize.queue.MessageListDeserializer;
import com.aliyun.mns.model.serialize.queue.MessageListSerializer;
import java.io.InputStream;
import java.net.URI;
import java.util.Iterator;
import java.util.List;

public class BatchSendMessageAction
extends AbstractAction<BatchSendMessageRequest, List<Message>> {
    public BatchSendMessageAction(ServiceClient client, ServiceCredentials credentials, URI endpoint) {
        super(HttpMethod.POST, "BatchSendMessage", client, credentials, endpoint);
    }

    @Override
    protected RequestMessage buildRequest(BatchSendMessageRequest reqObject) throws ClientException {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setResourcePath(reqObject.getRequestPath() + "/" + "messages");
        MessageListSerializer serializer = new MessageListSerializer();
        try {
            InputStream is = serializer.serialize(reqObject.getMessages(), "UTF-8");
            requestMessage.setContent(is);
            requestMessage.setContentLength(is.available());
        }
        catch (Exception e) {
            throw new ClientException(e.getMessage(), this.getUserRequestId(), e);
        }
        return requestMessage;
    }

    @Override
    protected ResultParser<List<Message>> buildResultParser() {
        return new ResultParser<List<Message>>(){

            @Override
            public List<Message> parse(ResponseMessage response) throws ResultParseException {
                MessageListDeserializer deserializer = new MessageListDeserializer();
                try {
                    Object msgs = deserializer.deserialize(response.getContent());
                    Iterator iterator = msgs.iterator();
                    while (iterator.hasNext()) {
                        Message msg = (Message)iterator.next();
                        msg.setRequestId(response.getHeader("x-mns-request-id"));
                    }
                    return msgs;
                }
                catch (Exception e) {
                    throw new ResultParseException("Unmarshal error,cause by:" + e.getMessage(), e);
                }
            }
        };
    }

    @Override
    protected ResultParser<Exception> buildExceptionParser() {
        return new ResultParser<Exception>(){

            @Override
            public Exception parse(ResponseMessage response) throws ResultParseException {
                ErrorMessageListDeserializer deserializer = new ErrorMessageListDeserializer();
                try {
                    return deserializer.deserialize(response.getContent());
                }
                catch (Exception e) {
                    return new ExceptionResultParser(BatchSendMessageAction.this.getUserRequestId()).parse(response);
                }
            }
        };
    }
}

