/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dw.migration.supervisor.module;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.workflow.migration.common.file.BwmPackageFileOperator;
import com.aliyun.migration.workflow.migration.dw.merge.diff.common.PackageDiffCommonTools;
import com.aliyun.migration.workflow.migration.dw.migration.supervisor.common.SupervisorTaskContext;
import com.aliyun.migration.workflow.migration.dw.migration.supervisor.common.file.QRCodeImageTool;
import com.aliyun.migration.workflow.migration.dw.migration.supervisor.common.file.StatisticsFileOperator;
import com.aliyun.migration.workflow.migration.dw.migration.supervisor.common.statistics.StatisticsTool;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DwMigrationSupervisor {
    private static final Logger log = LoggerFactory.getLogger(DwMigrationSupervisor.class);
    SupervisorTaskContext taskContext;

    public void init(SupervisorTaskContext taskContext) {
        this.taskContext = taskContext;
    }

    public void root() {
        this.readFile();
        StatisticsTool statisticsTool = new StatisticsTool();
        statisticsTool.init(this.taskContext.getReadPkg(), this.taskContext.getWritePkg(), this.taskContext.getDataworksPkg());
        this.taskContext.setStatisticsResult(statisticsTool.makeStatistics());
    }

    public void close() {
        log.info("==================\u8fc1\u79fb\u6548\u679c==================");
        log.info(JSONObject.toJSONString((Object)this.taskContext.getStatisticsResult(), (JSONWriter.Feature[])new JSONWriter.Feature[0]));
        log.info("==========================================");
        if (!StringUtils.isEmpty((CharSequence)this.taskContext.getOutputQRCodePath())) {
            log.info("\u7ed3\u679c\u4e8c\u7ef4\u7801\u8f93\u51fa\u5230\u8def\u5f84\uff1a{}", (Object)this.taskContext.getOutputQRCodePath());
            QRCodeImageTool.saveQRCodeImage(JSONObject.toJSONString((Object)this.taskContext.getStatisticsResult(), (JSONWriter.Feature[])new JSONWriter.Feature[0]), this.taskContext.getOutputQRCodePath());
        }
        if (!StringUtils.isEmpty((CharSequence)this.taskContext.getOutputJsonPath())) {
            log.info("\u7ed3\u679cJSON\u8f93\u51fa\u5230\u8def\u5f84\uff1a{}", (Object)this.taskContext.getOutputJsonPath());
            StatisticsFileOperator.exportJson(this.taskContext.getStatisticsResult(), this.taskContext.getOutputJsonPath());
        }
    }

    public void readFile() {
        if (this.taskContext.getReadPkg() != null) {
            log.info("TaskContext\u4e2d\u5df2\u83b7\u53d6\u5230Reader\u8f93\u51fa\u5305");
        } else if (!StringUtils.isEmpty((CharSequence)this.taskContext.getReadPkgPath()) && this.taskContext.getReadPkg() == null && new File(this.taskContext.getReadPkgPath()).exists()) {
            log.info("\u5c1d\u8bd5\u4ece\u6587\u4ef6\u83b7\u53d6Reader\u8f93\u51fa\u5305");
            this.taskContext.setReadPkg(BwmPackageFileOperator.readFile((String)this.taskContext.getReadPkgPath()));
        } else {
            log.warn("\u672a\u83b7\u53d6\u5230Reader\u8f93\u51fa\u5305");
        }
        if (this.taskContext.getConvertPkg() != null) {
            log.info("TaskContext\u4e2d\u5df2\u83b7\u53d6\u5230Convert\u8f93\u51fa\u5305");
        } else if (!StringUtils.isEmpty((CharSequence)this.taskContext.getConvertPkgPath()) && this.taskContext.getConvertPkg() == null && new File(this.taskContext.getConvertPkgPath()).exists()) {
            log.info("\u5c1d\u8bd5\u4ece\u6587\u4ef6\u83b7\u53d6Convert\u8f93\u51fa\u5305");
            this.taskContext.setConvertPkg(BwmPackageFileOperator.readFile((String)this.taskContext.getConvertPkgPath()));
        } else {
            log.warn("\u672a\u83b7\u53d6\u5230Convert\u8f93\u51fa\u5305");
        }
        if (this.taskContext.getWritePkg() != null) {
            log.info("TaskContext\u4e2d\u5df2\u83b7\u53d6\u5230Writer\u8f93\u51fa\u5305");
        } else if (!StringUtils.isEmpty((CharSequence)this.taskContext.getWritePkgPath()) && this.taskContext.getWritePkg() == null && new File(this.taskContext.getWritePkgPath()).exists()) {
            log.info("\u5c1d\u8bd5\u4ece\u6587\u4ef6\u83b7\u53d6Writer\u8f93\u51fa\u5305");
            this.taskContext.setWritePkg(BwmPackageFileOperator.readFile((String)this.taskContext.getWritePkgPath()));
        } else {
            log.warn("\u672a\u83b7\u53d6\u5230Writer\u8f93\u51fa\u5305");
        }
        if (this.taskContext.getDataworksPkg() != null) {
            log.info("TaskContext\u4e2d\u5df2\u83b7\u53d6\u5230DataWorks\u5bfc\u51fa\u5305");
            PackageDiffCommonTools.RefreshIdInPackage((WorkflowProjectPackage)this.taskContext.getDataworksPkg());
        } else if (!StringUtils.isEmpty((CharSequence)this.taskContext.getDataworksPkgPath()) && this.taskContext.getDataworksPkg() == null && new File(this.taskContext.getDataworksPkgPath()).exists()) {
            log.info("\u5c1d\u8bd5\u4ece\u6587\u4ef6\u83b7\u53d6DataWorks\u5bfc\u51fa\u5305");
            this.taskContext.setDataworksPkg(BwmPackageFileOperator.readFile((String)this.taskContext.getDataworksPkgPath()));
            PackageDiffCommonTools.RefreshIdInPackage((WorkflowProjectPackage)this.taskContext.getDataworksPkg());
        } else {
            log.warn("\u672a\u83b7\u53d6\u5230DataWorks\u5bfc\u51fa\u5305");
        }
    }
}

