/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.securitysdk.org.apache.xml.resolver.helpers;

public abstract class PublicId {
    protected PublicId() {
    }

    public static String normalize(String publicId) {
        int pos;
        String normal = publicId.replace('\t', ' ');
        normal = normal.replace('\r', ' ');
        normal = normal.replace('\n', ' ');
        normal = normal.trim();
        while ((pos = normal.indexOf("  ")) >= 0) {
            normal = normal.substring(0, pos) + normal.substring(pos + 1);
        }
        return normal;
    }

    public static String encodeURN(String publicId) {
        String urn = PublicId.normalize(publicId);
        urn = PublicId.stringReplace(urn, "%", "%25");
        urn = PublicId.stringReplace(urn, ";", "%3B");
        urn = PublicId.stringReplace(urn, "'", "%27");
        urn = PublicId.stringReplace(urn, "?", "%3F");
        urn = PublicId.stringReplace(urn, "#", "%23");
        urn = PublicId.stringReplace(urn, "+", "%2B");
        urn = PublicId.stringReplace(urn, " ", "+");
        urn = PublicId.stringReplace(urn, "::", ";");
        urn = PublicId.stringReplace(urn, ":", "%3A");
        urn = PublicId.stringReplace(urn, "//", ":");
        urn = PublicId.stringReplace(urn, "/", "%2F");
        StringBuffer buffer = new StringBuffer(13 + urn.length());
        buffer.append("urn:publicid:");
        buffer.append(urn);
        return buffer.toString();
    }

    public static String decodeURN(String urn) {
        boolean hasEscape;
        if (!urn.startsWith("urn:publicid:")) {
            return urn;
        }
        String publicId = urn.substring(13);
        boolean bl = hasEscape = publicId.indexOf(37) >= 0;
        if (hasEscape) {
            publicId = PublicId.stringReplace(publicId, "%2F", "/");
        }
        publicId = PublicId.stringReplace(publicId, ":", "//");
        if (hasEscape) {
            publicId = PublicId.stringReplace(publicId, "%3A", ":");
        }
        publicId = PublicId.stringReplace(publicId, ";", "::");
        publicId = PublicId.stringReplace(publicId, "+", " ");
        if (hasEscape) {
            publicId = PublicId.stringReplace(publicId, "%2B", "+");
            publicId = PublicId.stringReplace(publicId, "%23", "#");
            publicId = PublicId.stringReplace(publicId, "%3F", "?");
            publicId = PublicId.stringReplace(publicId, "%27", "'");
            publicId = PublicId.stringReplace(publicId, "%3B", ";");
            publicId = PublicId.stringReplace(publicId, "%25", "%");
        }
        return publicId;
    }

    private static String stringReplace(String str, String oldStr, String newStr) {
        int pos = str.indexOf(oldStr);
        if (pos >= 0) {
            StringBuffer buffer = new StringBuffer();
            int oldStrLength = oldStr.length();
            int start = 0;
            do {
                for (int i = start; i < pos; ++i) {
                    buffer.append(str.charAt(i));
                }
                buffer.append(newStr);
            } while ((pos = str.indexOf(oldStr, start = pos + oldStrLength)) >= 0);
            int strLength = str.length();
            for (int i = start; i < strLength; ++i) {
                buffer.append(str.charAt(i));
            }
            return buffer.toString();
        }
        return str;
    }
}

