/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.xss.richtext.handler;

import com.alibaba.security.css.CSSProcessHandler;
import com.alibaba.security.util.IOUtils;
import com.alibaba.security.util.ResourceUtil;
import com.alibaba.security.xss.richtext.handler.CommonStyleAttributeHandler;
import com.alibaba.security.xss.richtext.handler.DivStyleUrlDocumentHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DivStyleAttributeHandler
extends CommonStyleAttributeHandler {
    private static final Logger logger = Logger.getLogger(DivStyleAttributeHandler.class.getName());
    private static final boolean DEFAULT_LOWERCASE = false;
    private static boolean CHECK_URL = true;

    @Override
    protected CSSProcessHandler getCSSProcessHandler(StringBuilder printWriter) {
        return new DivStyleUrlDocumentHandler(printWriter, CHECK_URL, this.policy);
    }

    @Override
    protected boolean getDefaultLowercase() {
        return false;
    }

    static {
        InputStream is = ResourceUtil.getDefaultConfigInputStream();
        try {
            Properties props = new Properties();
            if (is != null) {
                props.load(is);
                if ("false".equalsIgnoreCase(props.getProperty("security.richtext.div.style.checkUrl", "true").trim())) {
                    CHECK_URL = false;
                }
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Fail to load the property of security.richtext.div.style.checkUrl. Url won't be checked by default.", e);
        }
        finally {
            IOUtils.closeQuietly(is);
        }
    }
}

