/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.xss.richtext.handler;

import com.alibaba.security.css.CSSParser;
import com.alibaba.security.css.CSSProcessHandler;
import com.alibaba.security.xss.richtext.Policy;
import com.alibaba.security.xss.richtext.handler.AttributeProcessHandler;
import com.alibaba.security.xss.richtext.handler.PolicyAdvice;
import com.alibaba.security.xss.richtext.impl.CssDocument4CommonAttributeHandler;
import com.alibaba.security.xss.richtext.model.Attribute;
import com.alibaba.security.xss.richtext.model.Tag;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CommonStyleAttributeHandler
implements AttributeProcessHandler,
PolicyAdvice {
    private static final Logger logger = Logger.getLogger(CommonStyleAttributeHandler.class.getName());
    private static final boolean DEFAULT_LOWERCASE = true;
    protected Policy policy;

    @Override
    public void printAttribute(StringBuilder printWriter, String name, String value, Attribute attr, Tag parent, Policy policy) {
        if (value == null || value.trim().length() == 0) {
            return;
        }
        if (this.getDefaultLowercase()) {
            value = value.toLowerCase();
        }
        printWriter.append(" ");
        printWriter.append(name);
        printWriter.append("=\"");
        CSSParser parser = new CSSParser();
        parser.setDocumentHandler(this.getCSSProcessHandler(printWriter));
        try {
            parser.parseStyleDeclaration(value);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage());
        }
        printWriter.append("\"");
    }

    protected CSSProcessHandler getCSSProcessHandler(StringBuilder printWriter) {
        return new CssDocument4CommonAttributeHandler(printWriter);
    }

    protected boolean getDefaultLowercase() {
        return true;
    }

    @Override
    public void setPolicy(Policy policy) {
        this.policy = policy;
    }
}

