/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.xss.json.compatible;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.NameFilter;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.ValueFilter;
import com.alibaba.security.xss.XssEscape;
import com.alibaba.security.xss.XssEscapeImpl;
import com.alibaba.security.xss.json.JsonEscapeType;
import com.alibaba.security.xss.json.compatible.FastJsonEscape;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public class JsonEscapeByOriginFastJson
implements FastJsonEscape {
    private static XssEscape xssEscape;
    private static final SerializerFeature[] FEATURES;
    private static final SerializerFeature[] UNI_FEATURES;
    private static final Map<JsonEscapeType, SerializerFeature[]> SERIALIZER_FEATURE_MAP;

    public JsonEscapeByOriginFastJson() {
        this(new XssEscapeImpl());
    }

    public JsonEscapeByOriginFastJson(XssEscape xssEscape) {
        JsonEscapeByOriginFastJson.xssEscape = xssEscape;
    }

    @Override
    public String escape(Object jsonObject, JsonEscapeType escapeType) {
        if (jsonObject == null) {
            return null;
        }
        if (jsonObject instanceof JSONObject) {
            return this.innerEscape(jsonObject, escapeType);
        }
        if (jsonObject instanceof String) {
            return this.escape((String)jsonObject, escapeType);
        }
        return this.escape(jsonObject.toString(), escapeType);
    }

    @Override
    public String escape(String text, JsonEscapeType escapeType) {
        Object object;
        try {
            object = JSON.parse((String)text);
        }
        catch (Exception e) {
            return null;
        }
        return this.innerEscape(object, escapeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String innerEscape(Object jsonObject, JsonEscapeType escapeType) {
        try (SerializeWriter out = null;){
            SerializerFeature[] serializerFeatures = SERIALIZER_FEATURE_MAP.get(escapeType);
            out = new SerializeWriter(serializerFeatures == null ? FEATURES : serializerFeatures);
            JSONSerializer serialzer = this.getJsonSerializer(out, escapeType);
            serialzer.write(jsonObject);
            String string = out.toString();
            return string;
        }
    }

    private JSONSerializer getJsonSerializer(SerializeWriter out, JsonEscapeType escapeType) {
        JSONSerializer serialzer = new JSONSerializer(out);
        if (JsonEscapeType.ESCAPE_HTML == escapeType || JsonEscapeType.ESCAPE_HTML_WITHOUT_AMPERSAND == escapeType) {
            serialzer.getNameFilters().add(new MyNameFilter(escapeType));
            serialzer.getValueFilters().add(new MyValueFilter(escapeType));
        }
        return serialzer;
    }

    private String escapeHtml(String text, JsonEscapeType type) {
        if (type == JsonEscapeType.ESCAPE_HTML) {
            return xssEscape.escapeHtml(text);
        }
        if (type == JsonEscapeType.ESCAPE_HTML_WITHOUT_AMPERSAND) {
            return xssEscape.escapeHtmlWithoutAmpersand(text);
        }
        return null;
    }

    static {
        FEATURES = new SerializerFeature[5];
        JsonEscapeByOriginFastJson.FEATURES[0] = SerializerFeature.QuoteFieldNames;
        JsonEscapeByOriginFastJson.FEATURES[1] = SerializerFeature.SkipTransientField;
        JsonEscapeByOriginFastJson.FEATURES[2] = SerializerFeature.WriteEnumUsingToString;
        JsonEscapeByOriginFastJson.FEATURES[3] = SerializerFeature.SortField;
        JsonEscapeByOriginFastJson.FEATURES[4] = SerializerFeature.WriteMapNullValue;
        UNI_FEATURES = new SerializerFeature[6];
        JsonEscapeByOriginFastJson.UNI_FEATURES[0] = SerializerFeature.QuoteFieldNames;
        JsonEscapeByOriginFastJson.UNI_FEATURES[1] = SerializerFeature.SkipTransientField;
        JsonEscapeByOriginFastJson.UNI_FEATURES[2] = SerializerFeature.WriteEnumUsingToString;
        JsonEscapeByOriginFastJson.UNI_FEATURES[3] = SerializerFeature.SortField;
        JsonEscapeByOriginFastJson.UNI_FEATURES[4] = SerializerFeature.WriteMapNullValue;
        JsonEscapeByOriginFastJson.UNI_FEATURES[5] = SerializerFeature.BrowserSecure;
        SERIALIZER_FEATURE_MAP = new EnumMap<JsonEscapeType, SerializerFeature[]>(JsonEscapeType.class){
            {
                this.put(JsonEscapeType.ESCAPE_HTML, FEATURES);
                this.put(JsonEscapeType.ESCAPE_UNICODE, UNI_FEATURES);
            }
        };
    }

    private class MyValueFilter
    implements ValueFilter {
        private JsonEscapeType escapeType;

        public MyValueFilter(JsonEscapeType escapeType) {
            this.escapeType = escapeType;
        }

        public Object process(Object source, String name, Object value) {
            if (value instanceof String) {
                return JsonEscapeByOriginFastJson.this.escapeHtml((String)value, this.escapeType);
            }
            if (value instanceof List) {
                List list = (List)value;
                for (int i = 0; i < list.size(); ++i) {
                    Object obj = list.get(i);
                    if (!(obj instanceof String)) continue;
                    obj = JsonEscapeByOriginFastJson.this.escapeHtml((String)obj, this.escapeType);
                    list.set(i, obj);
                }
                return list;
            }
            return value;
        }
    }

    private class MyNameFilter
    implements NameFilter {
        private JsonEscapeType escapeType;

        public MyNameFilter(JsonEscapeType escapeType) {
            this.escapeType = escapeType;
        }

        public String process(Object source, String name, Object value) {
            return JsonEscapeByOriginFastJson.this.escapeHtml(name, this.escapeType);
        }
    }
}

