/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.xss;

import com.alibaba.security.xss.XssEscape;
import com.alibaba.security.xss.html.Html4EscapeWithoutAmpersandSymbolsInitializer;
import com.alibaba.security.xss.html.HtmlEscape;
import com.alibaba.security.xss.html.HtmlEscapeLevel;
import com.alibaba.security.xss.html.HtmlEscapeSymbolsInitializer;
import com.alibaba.security.xss.html.HtmlEscapeType;
import com.alibaba.security.xss.javascript.JavaScriptEscape;
import com.alibaba.security.xss.javascript.JavaScriptEscapeLevel;
import com.alibaba.security.xss.javascript.JavaScriptEscapeType;
import com.alibaba.security.xss.json.JsonEscape;
import com.alibaba.security.xss.json.JsonEscapeLevel;
import com.alibaba.security.xss.json.JsonEscapeType;
import com.alibaba.security.xss.uri.CustomUriEscape;
import com.alibaba.security.xss.xml.XmlEscape;
import com.alibaba.security.xss.xml.XmlEscapeLevel;
import com.alibaba.security.xss.xml.XmlEscapeType;
import java.util.List;

public class XssEscapeImpl
implements XssEscape {
    private static final HtmlEscapeSymbolsInitializer SYMBOLS_INITIALIZER = new Html4EscapeWithoutAmpersandSymbolsInitializer();

    public String escapeHtml(String text) {
        return text == null ? null : HtmlEscape.escapeHtml(text, HtmlEscapeType.HTML4_NAMED_REFERENCES_DEFAULT_TO_DECIMAL, HtmlEscapeLevel.LEVEL_1_ONLY_MARKUP_SIGNIFICANT);
    }

    public String escapeHtmlWithoutAmpersand(String text) {
        return text == null ? null : HtmlEscape.escapeHtml(text, HtmlEscapeType.CUSTOM_HTML_NAMED_REFERENCES_DEFAULT_TO_DECIMAL, HtmlEscapeLevel.LEVEL_1_ONLY_MARKUP_SIGNIFICANT, SYMBOLS_INITIALIZER.initializeHtml());
    }

    public String escapeXml(String text) {
        return text == null ? null : XmlEscape.escapeXml11(text, XmlEscapeType.CHARACTER_ENTITY_REFERENCES_DEFAULT_TO_HEXA, XmlEscapeLevel.LEVEL_1_ONLY_MARKUP_SIGNIFICANT);
    }

    public String escapeJson(String text) {
        return text == null ? null : JsonEscape.escapeJson(text, JsonEscapeType.ESCAPE_UNICODE, JsonEscapeLevel.LEVEL_3_ALL_NON_ALPHANUMERIC);
    }

    public String escapeJson(Object object) {
        return object == null ? null : JsonEscape.escapeJson(object, JsonEscapeType.ESCAPE_UNICODE, JsonEscapeLevel.LEVEL_3_ALL_NON_ALPHANUMERIC);
    }

    public String escapeJsonWithoutAmpersand(Object object) {
        return object == null ? null : JsonEscape.escapeJson(object, JsonEscapeType.ESCAPE_HTML_WITHOUT_AMPERSAND, JsonEscapeLevel.LEVEL_3_ALL_NON_ALPHANUMERIC);
    }

    public byte[] getJsonEscapeLevels() {
        return JsonEscape.getEscapeLevels();
    }

    public String escapeJson(String text, JsonEscapeType type, JsonEscapeLevel level) {
        return text == null ? null : JsonEscape.escapeJson(text, type, level);
    }

    public String unescapeJson(String text) {
        return text == null ? null : JsonEscape.unescapeJson(text);
    }

    public String escapeJavaScript(String text) {
        return text == null ? null : JavaScriptEscape.escapeJavaScript(text, JavaScriptEscapeType.UHEXA, JavaScriptEscapeLevel.LEVEL_3_ALL_NON_ALPHANUMERIC);
    }

    public String escapeUri(String text) {
        return text == null ? null : CustomUriEscape.escapeUri(text);
    }

    public boolean addCustomProtocol(String protocol) {
        return CustomUriEscape.addCustomProtocol(protocol);
    }

    public boolean removeCustomProtocol(String protocol) {
        return CustomUriEscape.removeCustomProtocol(protocol);
    }

    public List<String> listUriAllowedProtocols() {
        return CustomUriEscape.listProtocols();
    }
}

