/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.util.http;

import com.alibaba.security.util.http.HttpResult;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HttpSender {
    private static final String USER_AGENT = "Mozilla/5.0";
    private static final String LOCATION = "Location";
    private static final int DEFAULT_TIMEOUT = 20;
    private static final Logger logger = Logger.getLogger(HttpSender.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResult send(URL url, int timeout) {
        if (url == null) {
            return null;
        }
        HttpURLConnection con = null;
        try {
            con = (HttpURLConnection)url.openConnection();
            HttpResult httpResult = HttpSender.sendGet(con, url.toString(), timeout);
            return httpResult;
        }
        catch (SocketTimeoutException se) {
            logger.log(Level.WARNING, "socket timeout", se);
            HttpResult httpResult = null;
            return httpResult;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to connect", e);
            HttpResult result = new HttpResult();
            result.setRedirect(false);
            result.setUrl(url.toString());
            HttpResult httpResult = result;
            return httpResult;
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
    }

    private static HttpResult sendGet(HttpURLConnection con, String url, Integer timeout) throws Exception {
        HttpResult result = new HttpResult();
        con.setRequestMethod("GET");
        con.setRequestProperty("User-Agent", USER_AGENT);
        if (timeout == null || timeout < 0) {
            timeout = 20;
        }
        con.setConnectTimeout(timeout);
        con.setInstanceFollowRedirects(false);
        con.setRequestMethod("HEAD");
        int status = con.getResponseCode();
        if (status == 302 || status == 301 || status == 303) {
            result.setRedirect(true);
            result.setUrl(con.getHeaderField(LOCATION));
        } else {
            result.setRedirect(false);
            result.setUrl(url);
        }
        return result;
    }
}

