/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.util.expiringmap;

import com.alibaba.security.util.AssertUtil;
import com.alibaba.security.util.expiringmap.ExpirationListener;
import com.alibaba.security.util.expiringmap.ExpirationMode;
import com.alibaba.security.util.expiringmap.ExpiringMap;
import java.util.ArrayList;
import java.util.List;

public final class ExpiringMapBuilder<K, V> {
    private static final long DEFAULT_DURATION = 30000L;
    private ExpirationMode expirationMode = ExpirationMode.CREATED;
    private List<ExpirationListener<K, V>> expirationListeners;
    private List<ExpirationListener<K, V>> asyncExpirationListeners;
    private long duration = 30000L;
    private int maxSize = Integer.MAX_VALUE;

    public <K1 extends K, V1 extends V> ExpiringMap<K1, V1> build() {
        return new ExpiringMap(this);
    }

    public ExpiringMapBuilder<K, V> expiration(long duration) {
        this.duration = duration;
        return this;
    }

    public ExpiringMapBuilder<K, V> maxSize(int maxSize) {
        AssertUtil.assertOperation(maxSize > 0, "maxSize");
        this.maxSize = maxSize;
        return this;
    }

    public <K1 extends K, V1 extends V> ExpiringMapBuilder<K1, V1> expirationListener(ExpirationListener<? super K1, ? super V1> listener) {
        AssertUtil.assertNotNull(listener, "listener");
        if (this.expirationListeners == null) {
            this.expirationListeners = new ArrayList<ExpirationListener<K, V>>();
        }
        this.expirationListeners.add(listener);
        return this;
    }

    public <K1 extends K, V1 extends V> ExpiringMapBuilder<K1, V1> expirationListeners(List<ExpirationListener<? super K1, ? super V1>> listeners) {
        AssertUtil.assertNotNull(listeners, "listeners");
        if (this.expirationListeners == null) {
            this.expirationListeners = new ArrayList<ExpirationListener<K, V>>(listeners.size());
        }
        for (ExpirationListener<K1, V1> expirationListener : listeners) {
            this.expirationListeners.add(expirationListener);
        }
        return this;
    }

    public <K1 extends K, V1 extends V> ExpiringMapBuilder<K1, V1> asyncExpirationListener(ExpirationListener<? super K1, ? super V1> listener) {
        AssertUtil.assertNotNull(listener, "listener");
        if (this.asyncExpirationListeners == null) {
            this.asyncExpirationListeners = new ArrayList<ExpirationListener<K, V>>();
        }
        this.asyncExpirationListeners.add(listener);
        return this;
    }

    public <K1 extends K, V1 extends V> ExpiringMapBuilder<K1, V1> asyncExpirationListeners(List<ExpirationListener<? super K1, ? super V1>> listeners) {
        AssertUtil.assertNotNull(listeners, "listeners");
        if (this.asyncExpirationListeners == null) {
            this.asyncExpirationListeners = new ArrayList<ExpirationListener<K, V>>(listeners.size());
        }
        for (ExpirationListener<K1, V1> expirationListener : listeners) {
            this.asyncExpirationListeners.add(expirationListener);
        }
        return this;
    }

    public ExpiringMapBuilder<K, V> expirationMode(ExpirationMode expirationMode) {
        this.expirationMode = AssertUtil.notNull(expirationMode, "expirationPolicy");
        return this;
    }

    public List<ExpirationListener<K, V>> getExpirationListeners() {
        return this.expirationListeners;
    }

    public List<ExpirationListener<K, V>> getAsyncExpirationListeners() {
        return this.asyncExpirationListeners;
    }

    public ExpirationMode getExpirationMode() {
        return this.expirationMode;
    }

    public long getDuration() {
        return this.duration;
    }

    public int getMaxSize() {
        return this.maxSize;
    }
}

