/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.util;

import com.alibaba.security.util.AssertUtil;
import java.lang.reflect.Field;

public abstract class ReflectionUtils {
    public static <T> T getNestedFieldValue(Object target, Field ... fields) {
        AssertUtil.checkArgument(fields != null && fields.length > 0, "Fields must not be null or empty");
        Object fieldValue = target;
        for (Field field : fields) {
            fieldValue = ReflectionUtils.getFieldValue(field, fieldValue);
        }
        return (T)fieldValue;
    }

    public static <T> T getFieldValue(Field field, Object target) {
        boolean accessible = field.isAccessible();
        try {
            field.setAccessible(true);
            Object object = field.get(target);
            return (T)object;
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Unexpected reflection exception - " + ex.getClass().getName() + ": " + ex.getMessage());
        }
        finally {
            field.setAccessible(accessible);
        }
    }

    public static <T> T getFieldValue(Class<?> clazz, String name, Object target) {
        return ReflectionUtils.getFieldValue(ReflectionUtils.findField(clazz, name), target);
    }

    public static Field findField(Class<?> clazz, String name) {
        return ReflectionUtils.findField(clazz, name, null);
    }

    public static Field findField(Class<?> clazz, String name, Class<?> type) {
        AssertUtil.notNull(clazz, "Class must not be null");
        AssertUtil.checkArgument(name != null || type != null, "Either name or type of the field must be specified");
        for (Class<?> searchType = clazz; !Object.class.equals(searchType) && searchType != null; searchType = searchType.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = searchType.getDeclaredFields()) {
                if (name != null && !name.equals(field.getName()) || type != null && !type.equals(field.getType())) continue;
                return field;
            }
        }
        return null;
    }
}

