/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.util;

public class PushbackableString {
    private char[] inputArray;
    private int pushback = -1;
    private int temp = -1;
    private int index = 0;
    private int mark = 0;

    public PushbackableString(char[] input) {
        this.inputArray = input;
    }

    public PushbackableString(String input) {
        if (input != null) {
            this.inputArray = input.toCharArray();
        }
    }

    public void pushback(int c) {
        this.pushback = c;
    }

    public int index() {
        return this.index;
    }

    public boolean hasNext() {
        if (this.pushback != -1) {
            return true;
        }
        return this.inputArray != null && this.inputArray.length != 0 && this.index < this.inputArray.length;
    }

    public int next() {
        if (this.pushback != -1) {
            int save = this.pushback;
            this.pushback = -1;
            return save;
        }
        if (this.inputArray == null || this.inputArray.length == 0 || this.index >= this.inputArray.length) {
            return -1;
        }
        return this.inputArray[this.index++];
    }

    public int nextHex() {
        int c = this.next();
        if (c == -1) {
            return -1;
        }
        if (PushbackableString.isHexDigit(c)) {
            return c;
        }
        return -1;
    }

    public int nextOctal() {
        int c = this.next();
        if (c == -1) {
            return -1;
        }
        if (PushbackableString.isOctalDigit(c)) {
            return c;
        }
        return -1;
    }

    public static boolean isHexDigit(int ch) {
        return ch >= 48 && ch <= 57 || ch >= 97 && ch <= 102 || ch >= 65 && ch <= 70;
    }

    public static boolean isOctalDigit(int ch) {
        return ch >= 48 && ch <= 55;
    }

    public int peek() {
        if (this.pushback != -1) {
            return this.pushback;
        }
        if (this.inputArray == null || this.inputArray.length == 0 || this.index >= this.inputArray.length) {
            return -1;
        }
        return this.inputArray[this.index];
    }

    public boolean peek(int c) {
        if (this.pushback != -1 && this.pushback == c) {
            return true;
        }
        if (this.inputArray == null || this.inputArray.length == 0 || this.index >= this.inputArray.length) {
            return false;
        }
        return this.inputArray[this.index] == c;
    }

    public void mark() {
        this.temp = this.pushback;
        this.mark = this.index;
    }

    public void reset() {
        this.pushback = this.temp;
        this.index = this.mark;
    }

    public String remainder() {
        if (this.inputArray == null || this.inputArray.length == 0 || this.index >= this.inputArray.length) {
            return null;
        }
        String output = new String(this.inputArray, this.index, this.inputArray.length);
        if (this.pushback != -1) {
            output = (char)this.pushback + output;
        }
        return output;
    }
}

