/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.util;

import com.alibaba.security.url.exception.IllegalModifySSRFMasksException;
import com.alibaba.security.url.model.DomainMask;
import com.alibaba.security.url.model.SSRFMatcherEnum;
import com.alibaba.security.url.model.SSRFMatcherMask;
import com.alibaba.security.url.model.SubnetMask;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class MatcherMasksParsers {
    private static final Map<SSRFMatcherEnum, MatcherMasksParser> PARSERS;
    private static MatcherMasksParser<DomainMask> domainMaskParser;
    private static MatcherMasksParser<SubnetMask> subnetMaskParser;

    public static <T extends SSRFMatcherMask> T parse(SSRFMatcherEnum ssrfMatcherEnum, String mask, Class<T> clazz) {
        try {
            return (T)((SSRFMatcherMask)clazz.cast(PARSERS.get(ssrfMatcherEnum).parse(mask)));
        }
        catch (Exception ex) {
            throw new IllegalModifySSRFMasksException((Throwable)ex);
        }
    }

    static {
        domainMaskParser = new MatcherMasksParser<DomainMask>(){

            @Override
            public DomainMask parse(String format) {
                return DomainMask.parse((String)format);
            }
        };
        subnetMaskParser = new MatcherMasksParser<SubnetMask>(){

            @Override
            public SubnetMask parse(String format) {
                return SubnetMask.parse((String)format);
            }
        };
        HashMap<SSRFMatcherEnum, MatcherMasksParser<Object>> tempMap = new HashMap<SSRFMatcherEnum, MatcherMasksParser<Object>>();
        for (SSRFMatcherEnum ssrfMatcherEnum : SSRFMatcherEnum.values()) {
            if (ssrfMatcherEnum.isDomain()) {
                tempMap.put(ssrfMatcherEnum, domainMaskParser);
                continue;
            }
            tempMap.put(ssrfMatcherEnum, subnetMaskParser);
        }
        PARSERS = Collections.unmodifiableMap(tempMap);
    }

    static interface MatcherMasksParser<T extends SSRFMatcherMask> {
        public T parse(String var1);
    }
}

