/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.url.ssrf;

import com.alibaba.security.resource.ResourceContainer;
import com.alibaba.security.resource.SecuritySingletonResourceContainer;
import com.alibaba.security.resource.ssrf.matcher.SsrfMatchable;
import com.alibaba.security.url.SSRFChecker;
import com.alibaba.security.url.SSRFResult;
import com.alibaba.security.url.SSRFUnsafeConnectionError;
import com.alibaba.security.url.model.SSRFMatcherEnum;
import com.alibaba.security.url.ssrf.policy.CompatibleSsrfCheckerRegister;
import com.alibaba.security.url.ssrf.policy.SsrfNetHookPolicyFactory;
import com.alibaba.security.url.ssrf.policy.SsrfNetHookStarter;
import com.alibaba.security.url.ssrf.strategy.InetAddressHostnameResolveStrategies;
import com.alibaba.security.util.AssertUtil;
import com.alibaba.security.util.IpAddressUtil;
import com.alibaba.security.util.UrlUtil;
import com.alibaba.security.util.http.HttpResult;
import com.alibaba.security.util.http.HttpSender;
import com.alibaba.securitysdk.logging.api.SecType;
import com.alibaba.securitysdk.logging.api.factories.LoggerManager;
import com.alibaba.securitysdk.logging.api.loggers.SecurityModifiedLogger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SSRFCheckerImpl
implements SSRFChecker {
    private static final Logger LOGGER = Logger.getLogger(SSRFCheckerImpl.class.getName());
    private static final SecurityModifiedLogger SECURITY_MODIFIED_LOGGER = (SecurityModifiedLogger)LoggerManager.getLogger(SecurityModifiedLogger.class);
    private static final int DEFAULT_CHECK_TIMES = 0;
    private static final int DEFAULT_TIMEOUT = 20;
    private static ResourceContainer resourceContainer = SecuritySingletonResourceContainer.getInstance();
    private volatile String[] allowedProtocols = ALLOWED_PROTOCOLS;

    public void startNetHookWithThreadLocal() {
        CompatibleSsrfCheckerRegister.start();
    }

    public void startNetHookWithThreadLocal(String url) {
        SsrfNetHookStarter starter = SsrfNetHookPolicyFactory.getThreadLocalBasedSsrfNetHookStarter();
        this.startNetHooking(url, starter, false);
    }

    public void stopNetHookWithThreadLocal() {
        SsrfNetHookStarter starter = SsrfNetHookPolicyFactory.getThreadLocalBasedSsrfNetHookStarter();
        starter.stop();
    }

    public void startNetHookWithExpirationCache(String url) {
        this.startNetHooking(url, SsrfNetHookPolicyFactory.getExpiredCachedBasedSsrfNetHookStarter(), false);
    }

    public void startCustomNetHookWithExpirationCache(String url) {
        this.startNetHooking(url, SsrfNetHookPolicyFactory.getExpiredCachedBasedSsrfNetHookStarter(), true);
    }

    public boolean checkUrl(String url) {
        return this.checkUrl(url, 0, 20);
    }

    public boolean checkUrl(String url, int checkTimes) {
        return this.checkUrl(url, checkTimes, 20);
    }

    public boolean checkUrl(String url, int checkTimes, int timeout) {
        if (url == null || url.isEmpty()) {
            return false;
        }
        if (checkTimes <= 0) {
            checkTimes = 0;
        }
        try {
            URL realUrl = null;
            String realUrlString = url;
            for (int i = 0; i <= checkTimes; ++i) {
                URL redirectUrl;
                HttpResult redirectResult;
                if (!this.checkUrlWithoutConnection(realUrlString, false)) {
                    return false;
                }
                if (realUrl == null) {
                    realUrl = new URL(url);
                }
                if ((redirectResult = HttpSender.send(realUrl, timeout)) == null) {
                    return false;
                }
                if (!redirectResult.isRedirect()) {
                    return true;
                }
                String redirectUrlString = redirectResult.getUrl();
                realUrl = redirectUrl = new URL(redirectUrlString);
                realUrlString = redirectUrlString;
            }
        }
        catch (MalformedURLException me) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "A malformed URL has occurred", me);
            }
            return false;
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "Error occurred when checking url " + url, e);
            }
            return true;
        }
        return false;
    }

    public boolean checkUrlWithoutConnection(String url) {
        try {
            return this.checkUrlWithoutConnection(url, false, false);
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getMessage(), e);
            }
            return true;
        }
    }

    public boolean checkUrlWithoutConnection(String url, boolean isIpAllowed) {
        try {
            return this.checkUrlWithoutConnection(url, false, isIpAllowed);
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info(e.getMessage());
            }
            return true;
        }
    }

    public SSRFResult checkUrlWithoutConnectionWithDetail(String url, boolean isIpAllowed) {
        try {
            return this.checkUrlWithoutConnection0(url, false, isIpAllowed);
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info(e.getMessage());
            }
            return SSRFResult.ofSafe();
        }
    }

    public void resetAllowedProtocols(String[] allowedProtocols) {
        AssertUtil.checkArgument(allowedProtocols != null && allowedProtocols.length > 0, "The allowed protocols should not be null or empty.");
        this.allowedProtocols = allowedProtocols;
    }

    public void addCustomAllowedSubnetMasks(SSRFMatcherEnum ssrfMatcherEnum, String ... matcherMasks) {
        AssertUtil.assertNotNull(ssrfMatcherEnum, "ssrfMatcherEnum should not be null.");
        AssertUtil.assertNotNull(matcherMasks, "matcherMasks should not be null.");
        for (String matcherMask : matcherMasks) {
            AssertUtil.checkArgument(matcherMask.contains("/"), "mask wrong: " + matcherMask + " should be cidr.");
        }
        SsrfMatchable SsrfMatchable2 = resourceContainer.getSecurityResource(SsrfMatchable.class);
        SsrfMatchable2.addCustomAllowedMasks(ssrfMatcherEnum.value(), matcherMasks);
    }

    public void removeCustomAllowedSubnetMasks(SSRFMatcherEnum ssrfMatcherEnum, String ... matcherMasks) {
        AssertUtil.assertNotNull(ssrfMatcherEnum, "ssrfMatcherEnum should not be null.");
        AssertUtil.assertNotNull(matcherMasks, "matcherMasks should not be null.");
        for (String matcherMask : matcherMasks) {
            AssertUtil.checkArgument(matcherMask.contains("/"), "mask wrong: " + matcherMask + " should be cidr.");
        }
        SsrfMatchable SsrfMatchable2 = resourceContainer.getSecurityResource(SsrfMatchable.class);
        SsrfMatchable2.removeCustomAllowedMasks(ssrfMatcherEnum.value(), matcherMasks);
    }

    public List<String> listAllMasks(SSRFMatcherEnum ssrfMatcherEnum) {
        SsrfMatchable SsrfMatchable2 = resourceContainer.getSecurityResource(SsrfMatchable.class);
        return Collections.unmodifiableList(new ArrayList<String>(SsrfMatchable2.customAllowedMasks(ssrfMatcherEnum.value())));
    }

    public boolean checkSSRF(String url) {
        if (url == null) {
            return false;
        }
        if (!this.checkprotocol(url)) {
            return false;
        }
        String host = UrlUtil.parseUrl(url, false);
        if (host == null) {
            return false;
        }
        return SSRFCheckerImpl.isTrustedDomain(host) || SSRFCheckerImpl.isTrustedIp(host);
    }

    static boolean isAllowedAddress(InetAddress inetAddress) {
        if (inetAddress == null) {
            return false;
        }
        String host = InetAddressHostnameResolveStrategies.resolve(inetAddress);
        if (host != null) {
            if (SSRFCheckerImpl.isTrustedDomain(host = host.toLowerCase())) {
                return true;
            }
            if (SSRFCheckerImpl.isBlockedDomain(host) || !UrlUtil.checkHosts(host)) {
                return false;
            }
        }
        if (inetAddress instanceof Inet4Address) {
            return SSRFCheckerImpl.innertIsAllowedInetAddress(inetAddress, host, true);
        }
        return SSRFCheckerImpl.innertIsAllowedInetAddress(inetAddress, host, false);
    }

    private static boolean innertIsAllowedInetAddress(InetAddress inetAddress, String host, boolean isIpv4) {
        byte[] addressBytes = inetAddress.getAddress();
        String ipString = IpAddressUtil.convertIpBytesToString(addressBytes);
        return isIpv4 ? SSRFCheckerImpl.innerIsAllowedInet4Ip(ipString, host) : SSRFCheckerImpl.innerIsAllowedInet6Ip(ipString, host);
    }

    private static boolean innerIsAllowedInet4Ip(String ip, String host) {
        return SSRFCheckerImpl.innertIsAllowedIp(ip, host, SSRFMatcherEnum.INTRANET_IP, SSRFMatcherEnum.EXCLUDED_IP);
    }

    private static boolean innerIsAllowedInet6Ip(String ip, String host) {
        return SSRFCheckerImpl.innertIsAllowedIp(ip, host, SSRFMatcherEnum.INTRANET_IPV6, SSRFMatcherEnum.EXCLUDED_IPV6);
    }

    private static boolean innertIsAllowedIp(String ip, String host, SSRFMatcherEnum includesMatcher, SSRFMatcherEnum excludesMatcher) {
        SsrfMatchable ssrfMatcherResource = resourceContainer.getSecurityResource(SsrfMatchable.class);
        boolean observedMatcheResult = !ssrfMatcherResource.observedMatches(ip, includesMatcher.value()) || ssrfMatcherResource.observedMatches(ip, excludesMatcher.value());
        SECURITY_MODIFIED_LOGGER.logBoolean(SecType.SSRF_OBVSRVED, (Object)(host == null ? ip : host), observedMatcheResult);
        return !ssrfMatcherResource.matches(ip, includesMatcher.value()) || ssrfMatcherResource.matches(ip, excludesMatcher.value());
    }

    private void startNetHooking(String url, SsrfNetHookStarter starter, boolean isCustomThrowable) {
        String ipString;
        if (url == null) {
            return;
        }
        if (!this.checkprotocol(url)) {
            throw new SSRFUnsafeConnectionError("[" + url + "]Unsafe protocal for url.");
        }
        String host = UrlUtil.parseUrl(url, false);
        if (host == null) {
            throw new SSRFUnsafeConnectionError("[" + url + "]The host is null.");
        }
        if (SSRFCheckerImpl.isTrustedDomain(host)) {
            return;
        }
        if (SSRFCheckerImpl.isBlockedDomain(host) || !UrlUtil.checkHosts(host)) {
            throw new SSRFUnsafeConnectionError("[" + url + "]The host is banned.");
        }
        if (IpAddressUtil.isIpv4Address(host) ? !SSRFCheckerImpl.innerIsAllowedInet4Ip(ipString = IpAddressUtil.convertIpv4ToString(host), host) : IpAddressUtil.isIpv6Address(host) && !SSRFCheckerImpl.innerIsAllowedInet6Ip(ipString = IpAddressUtil.convertIpv6ToString(host), host)) {
            throw new SSRFUnsafeConnectionError("[" + url + "]The ip is banned.");
        }
        starter.setHost(host);
        starter.setCustomThrowable(isCustomThrowable);
        starter.start();
    }

    boolean checkUrlWithoutConnection(String url, boolean isHost, boolean isIpAllowed) {
        return this.checkUrlWithoutConnection0(url, isHost, isIpAllowed).isSafe();
    }

    SSRFResult checkUrlWithoutConnection0(String url, boolean isHost, boolean isIpAllowed) {
        if (url == null) {
            return SSRFResult.ofNotSafe();
        }
        if (!this.checkprotocol(url)) {
            return SSRFResult.ofNotSafe();
        }
        String host = UrlUtil.parseUrl(url, isHost);
        if (host == null) {
            return SSRFResult.ofNotSafe();
        }
        if (IpAddressUtil.isNotStandardIP(host)) {
            return SSRFResult.ofNotSafe();
        }
        if (!isIpAllowed && IpAddressUtil.isIpAddress(host)) {
            return SSRFResult.ofNotSafe();
        }
        if (SSRFCheckerImpl.isTrustedDomain(host)) {
            return SSRFResult.ofSafe();
        }
        if (SSRFCheckerImpl.isBlockedDomain(host) || !UrlUtil.checkHosts(host)) {
            return SSRFResult.ofNotSafe();
        }
        return SSRFCheckerImpl.checkSSRFBannedAddress(host);
    }

    boolean checkprotocol(String url) {
        String theUrl = url.substring(0, Math.min(8, url.length())).toLowerCase();
        for (String protocol : this.allowedProtocols) {
            if (!theUrl.startsWith(protocol)) continue;
            return true;
        }
        return false;
    }

    static boolean isTrustedDomain(String host) {
        SsrfMatchable ssrfMatcherResource = resourceContainer.getSecurityResource(SsrfMatchable.class);
        SSRFCheckerImpl.logObservedAllowDomain(ssrfMatcherResource, host);
        return ssrfMatcherResource.matches(host, SSRFMatcherEnum.TRUSTED_DOMAIN.value());
    }

    static boolean isTrustedIp(String ip) {
        if (IpAddressUtil.isIpv4Address(ip)) {
            String ipv4String = IpAddressUtil.convertIpv4ToString(ip);
            SsrfMatchable ssrfMatcherResource = resourceContainer.getSecurityResource(SsrfMatchable.class);
            return ssrfMatcherResource.matches(ipv4String, SSRFMatcherEnum.TRUSTED_IP.value());
        }
        return false;
    }

    static boolean isBlockedDomain(String host) {
        SsrfMatchable ssrfMatcherResource = resourceContainer.getSecurityResource(SsrfMatchable.class);
        SSRFCheckerImpl.logObservedAllowDomain(ssrfMatcherResource, host);
        return ssrfMatcherResource.matches(host, SSRFMatcherEnum.INTRANET_DOMAIN.value()) && !ssrfMatcherResource.matches(host, SSRFMatcherEnum.EXCLUDED_DOMAIN.value());
    }

    private static void logObservedAllowDomain(SsrfMatchable ssrfMatcherResource, String host) {
        boolean isObservedAllowDomain = ssrfMatcherResource.observedMatches(host, SSRFMatcherEnum.TRUSTED_DOMAIN.value()) || !ssrfMatcherResource.observedMatches(host, SSRFMatcherEnum.INTRANET_DOMAIN.value()) || ssrfMatcherResource.observedMatches(host, SSRFMatcherEnum.EXCLUDED_DOMAIN.value());
        SECURITY_MODIFIED_LOGGER.logBoolean(SecType.SSRF_OBVSRVED, (Object)host, isObservedAllowDomain);
    }

    private static SSRFResult checkSSRFBannedAddress(String host) {
        block6: {
            if (host == null) {
                return SSRFResult.ofNotSafe();
            }
            try {
                InetAddress[] addresses = InetAddress.getAllByName(host);
                if (addresses != null && addresses.length != 0) {
                    for (InetAddress address : addresses) {
                        if (address instanceof Inet4Address && !SSRFCheckerImpl.innertIsAllowedInetAddress(address, host, true)) {
                            return SSRFResult.ofNotSafe((String)address.getHostAddress());
                        }
                        if (!(address instanceof Inet6Address) || SSRFCheckerImpl.innertIsAllowedInetAddress(address, host, false)) continue;
                        return SSRFResult.ofNotSafe((String)address.getHostAddress());
                    }
                    break block6;
                }
                return SSRFResult.ofNotSafe((String)"-1");
            }
            catch (UnknownHostException e) {
                return SSRFResult.ofNotSafe();
            }
        }
        return SSRFResult.ofSafe();
    }

    @Deprecated
    public void start() {
        this.startNetHookWithThreadLocal();
    }

    @Deprecated
    public void stop() {
        this.stopNetHookWithThreadLocal();
    }
}

