/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.url.ssrf;

import com.alibaba.security.url.exception.SSRFThrowableFactory;
import com.alibaba.security.util.EnumUtil;
import com.alibaba.security.util.IOUtils;
import com.alibaba.security.util.ResourceUtil;
import com.alibaba.security.util.expiringmap.ExpirationMode;
import com.alibaba.security.util.expiringmap.ExpiringMap;
import com.alibaba.security.util.expiringmap.ExpiringMapBuilder;
import com.alibaba.security.util.expiringmap.ExpiringSet;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class HostCachePolicy {
    static final int DEFAULT_EXPIRATION_MILLS_VALUE = 20000;
    static final int DEFAULT_MAX_SIZE_VALUE = 100000;
    public static final String DEFAULT_EXPIRATION_MILLS = String.valueOf(20000);
    public static final String DEFAULT_MAX_SIZE = String.valueOf(100000);
    public static final String DEFAULT_EXPRIATION_MODE = ExpirationMode.ACCESSED.name();
    static ExpirationMode expirationMode;
    static long expirationMills;
    static int maxSize;

    public static long getExpirationMills() {
        return expirationMills;
    }

    public static int getMaxSize() {
        return maxSize;
    }

    public static void setMaxSize(int maxSize) {
        HostCachePolicy.maxSize = maxSize;
    }

    public static ExpirationMode getExpirationMode() {
        return expirationMode;
    }

    public static ExpiringSet<String> expiringSet() {
        ExpiringMapBuilder<String, Object> mapBuilder = ExpiringMap.builder(String.class, Object.class).expiration(expirationMills).expirationMode(expirationMode).maxSize(maxSize);
        return ExpiringSet.create(mapBuilder);
    }

    public static ExpiringMap<String, SSRFThrowableFactory> expiringMap() {
        return ExpiringMap.builder(String.class, SSRFThrowableFactory.class).expiration(expirationMills).expirationMode(expirationMode).maxSize(maxSize).build();
    }

    static {
        maxSize = -1;
        InputStream is = ResourceUtil.getDefaultConfigInputStream();
        try {
            Properties props = new Properties();
            if (is != null) {
                props.load(is);
            }
            expirationMills = Long.valueOf(props.getProperty("security.ssrf.nethook.cache.expiration", DEFAULT_EXPIRATION_MILLS));
            maxSize = Integer.valueOf(props.getProperty("security.ssrf.nethook.cache.size", DEFAULT_MAX_SIZE));
            expirationMode = EnumUtil.getEnumFromString(ExpirationMode.class, props.getProperty("security.ssrf.nethook.cache.mode", DEFAULT_EXPRIATION_MODE));
        }
        catch (IOException iOException) {
        }
        finally {
            IOUtils.closeQuietly(is);
        }
    }
}

