/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.url.safeurl;

import com.alibaba.security.net.URI;
import com.alibaba.security.resource.ResourceContainer;
import com.alibaba.security.resource.SecuritySingletonResourceContainer;
import com.alibaba.security.resource.safeurl.matcher.SafeUrlMatchable;
import com.alibaba.security.url.SafeUrlChecker;
import com.alibaba.security.util.AssertUtil;
import com.alibaba.security.util.IOUtils;
import com.alibaba.security.util.StringUtils;
import com.alibaba.security.util.UrlUtil;
import com.alibaba.securitysdk.logging.api.SecType;
import com.alibaba.securitysdk.logging.api.factories.LoggerManager;
import com.alibaba.securitysdk.logging.api.loggers.SecurityModifiedLogger;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.map.MultiValueMap;

public class SafeUrlCheckerImpl
implements SafeUrlChecker {
    private static final Set<String> ALLOWED_PROTOCOL_SET = new HashSet<String>(Arrays.asList(ALLOWED_PROTOCOLS));
    private static final SecurityModifiedLogger SECURITY_MODIFIED_LOGGER = (SecurityModifiedLogger)LoggerManager.getLogger(SecurityModifiedLogger.class);
    private static final Logger LOGGER = Logger.getLogger(SafeUrlCheckerImpl.class.getName());
    private static final String[] blockStart = new String[]{"/\\", "/\r", "/\n"};
    private static ResourceContainer resourceContainer;
    public static MultiMap extensionHeadMap;

    private static MultiMap genDefaultExtensionHeadMap() {
        MultiValueMap map = new MultiValueMap();
        map.put((Object)"jpg", (Object)"FFD8FF");
        map.put((Object)"jpeg", (Object)"FFD8FF");
        map.put((Object)"png", (Object)"89504E");
        map.put((Object)"gif", (Object)"474946");
        map.put((Object)"webp", (Object)"524946");
        map.put((Object)"bmp", (Object)"424D");
        map.put((Object)"ico", (Object)"000001");
        map.put((Object)"heic", (Object)"667479");
        map.put((Object)"heif", (Object)"667479");
        map.put((Object)"tiff", (Object)"492049");
        map.put((Object)"tiff", (Object)"49492A");
        map.put((Object)"tiff", (Object)"4D4D00");
        map.put((Object)"tif", (Object)"492049");
        map.put((Object)"tif", (Object)"49492A");
        map.put((Object)"tif", (Object)"4D4D00");
        map.put((Object)"psd", (Object)"384250");
        map.put((Object)"avif", (Object)"000000");
        map.put((Object)"tga", (Object)"00");
        map.put((Object)"pgm", (Object)"50350A");
        map.put((Object)"cr2", (Object)"49492A");
        return map;
    }

    private static String getHost(String url, boolean isHost) throws URISyntaxException {
        String host = isHost ? url.toLowerCase() : UrlUtil.getHost(url);
        return host == null ? "" : host.toLowerCase();
    }

    public boolean isInWhiteList(String url, boolean isHost, String id) {
        String host;
        if (url == null) {
            return false;
        }
        if (url.startsWith("/") && !url.startsWith("//")) {
            url = url.toUpperCase();
            for (String bs : blockStart) {
                if (!url.startsWith(bs)) continue;
                return false;
            }
            return true;
        }
        try {
            host = SafeUrlCheckerImpl.getHost(url, isHost);
        }
        catch (URISyntaxException e) {
            return false;
        }
        return !StringUtils.isEmpty(host) && this.safeUrlMatches(host, id) && UrlUtil.checkHosts(host);
    }

    public boolean isInWhiteListDropBlock(String url, boolean isHost, String id) {
        String hosts;
        if (url == null) {
            return false;
        }
        if (isHost) {
            hosts = url.toLowerCase();
        } else {
            try {
                hosts = SafeUrlCheckerImpl.getHost(url, false);
            }
            catch (URISyntaxException e) {
                return false;
            }
        }
        if (hosts != null) {
            if (this.blockUrlMatches(hosts, id) && UrlUtil.checkHosts(hosts)) {
                return false;
            }
        } else {
            return false;
        }
        return this.isInWhiteList(url, isHost, id);
    }

    public boolean inWhiteList(String url) {
        return this.isInWhiteList(url, false, "");
    }

    public boolean inWhiteListDropBlock(String url) {
        return this.isInWhiteListDropBlock(url, false, "");
    }

    public boolean inWhiteList(String url, String id) {
        return this.isInWhiteList(url, false, id);
    }

    public boolean inWhiteListDropBlock(String url, String id) {
        return this.isInWhiteListDropBlock(url, false, id);
    }

    public boolean inWhiteList(String url, boolean isHost) {
        return this.isInWhiteList(url, isHost, "");
    }

    public boolean inWhiteListDropBlock(String url, boolean isHost) {
        return this.isInWhiteListDropBlock(url, isHost, "");
    }

    public String getSafeUrl(String url) {
        try {
            if (!UrlUtil.checkAt(url)) {
                return null;
            }
            if (this.inWhiteList(url)) {
                return url;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSafeImgUrl(String url, Set<String> allowedImgExtensions, InputStream inputStream) {
        Object object;
        try {
            if (!UrlUtil.checkAt(url)) {
                String string = null;
                return string;
            }
            HashSet<String> allAllowedImgExtensions = new HashSet<String>();
            allAllowedImgExtensions.add("jpg");
            allAllowedImgExtensions.add("jpeg");
            allAllowedImgExtensions.add("png");
            if (CollectionUtils.isNotEmpty(allowedImgExtensions)) {
                for (String ext : allowedImgExtensions) {
                    allAllowedImgExtensions.add(ext.toLowerCase());
                }
            }
            if (this.inWhiteList(url) && this.inWhiteExtList(url, allAllowedImgExtensions) && this.isValidImageWithFlexibleExtension(url, allAllowedImgExtensions, inputStream)) {
                object = url;
                return object;
            }
            object = null;
            return object;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
            object = null;
            return object;
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
    }

    private boolean isValidImage(String url, Set<String> allowedImgExtension, InputStream inputStream) throws Exception {
        String formatName = this.getImageFormat(inputStream);
        if (!this.isValidFormat(formatName, allowedImgExtension)) {
            return false;
        }
        if (!this.isValidHeader(inputStream, formatName, allowedImgExtension)) {
            return false;
        }
        return this.isValidContent(inputStream);
    }

    private boolean isValidImageWithFlexibleExtension(String url, Set<String> allowedImgExtension, InputStream inputStream) throws Exception {
        if (null == inputStream) {
            return true;
        }
        return this.isValidHeader(inputStream, null, allowedImgExtension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getImageFormat(InputStream inputStream) throws Exception {
        ImageInputStream imageInputStream = null;
        try {
            imageInputStream = ImageIO.createImageInputStream(inputStream);
            Iterator<ImageReader> imageReaders = ImageIO.getImageReaders(imageInputStream);
            if (!imageReaders.hasNext()) {
                throw new IllegalArgumentException("Unsupported image format");
            }
            ImageReader imageReader = imageReaders.next();
            String string = imageReader.getFormatName();
            return string;
        }
        finally {
            if (null != imageInputStream) {
                imageInputStream.close();
            }
        }
    }

    private boolean isValidFormat(String formatName, Set<String> allowedImgExtension) {
        return allowedImgExtension.contains(formatName.toLowerCase());
    }

    private boolean isValidHeader(InputStream inputStream, String exceptedExtension, Set<String> allowedImgExtension) throws IOException {
        byte[] header = new byte[3];
        inputStream.read(header);
        String fileHeader = this.bytesToHexString(header);
        if (null != exceptedExtension && SafeUrlCheckerImpl.matchHeader(fileHeader, exceptedExtension.toLowerCase())) {
            return true;
        }
        for (String extension : allowedImgExtension) {
            if (!SafeUrlCheckerImpl.matchHeader(fileHeader, extension)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchHeader(String fileHeader, String extension) {
        List head16s = (List)extensionHeadMap.get((Object)extension);
        if (null == head16s) {
            throw new IllegalArgumentException("Unsupported image format=" + extension);
        }
        for (String head : head16s) {
            if (!fileHeader.startsWith(head)) continue;
            return true;
        }
        return false;
    }

    private boolean isValidContent(InputStream inputStream) throws IOException {
        BufferedImage image = ImageIO.read(inputStream);
        int width = image.getWidth();
        int height = image.getHeight();
        if (width <= 0 || height <= 0) {
            return false;
        }
        int colorType = image.getColorModel().getColorSpace().getType();
        return colorType == 5 || colorType == 6;
    }

    private String bytesToHexString(byte[] bytes) {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte b : bytes) {
            stringBuilder.append(String.format("%02X", b));
        }
        return stringBuilder.toString();
    }

    private boolean inWhiteExtList(String url, Set<String> allowedImgExtension) throws Exception {
        String path = new URI(url).getPath();
        return allowedImgExtension.contains(path.substring(path.lastIndexOf(".") + 1).toLowerCase());
    }

    public String getSafeUrlWithStrictStrategy(String url) {
        return this.getSafeUrl(url, true, ALLOWED_PROTOCOL_SET);
    }

    public String getSafeUrl(String url, boolean withBlockDomains, Set<String> protocols) {
        AssertUtil.assertNotNull(protocols, "protocols should not be null");
        if (url == null) {
            return null;
        }
        try {
            if (!UrlUtil.checkAt(url)) {
                return null;
            }
            if (!protocols.contains(UrlUtil.getScheme(url))) {
                return null;
            }
            if (withBlockDomains ? this.inWhiteListDropBlock(url) : this.inWhiteList(url)) {
                return url;
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, e.getMessage(), e);
            return null;
        }
    }

    private boolean safeUrlMatches(String host, String id) {
        SafeUrlMatchable safeUrlMatchable = resourceContainer.getSecurityResource(SafeUrlMatchable.class);
        boolean observedMatcheResult = safeUrlMatchable.safeUrlMatches(host, id, true);
        SECURITY_MODIFIED_LOGGER.logBoolean(SecType.SAFE_URL_OBSERVED, (Object)host, observedMatcheResult);
        return safeUrlMatchable.safeUrlMatches(host, id, false);
    }

    private boolean blockUrlMatches(String host, String id) {
        SafeUrlMatchable safeUrlMatchable = resourceContainer.getSecurityResource(SafeUrlMatchable.class);
        boolean observedMatcheResult = safeUrlMatchable.blockUrlMatches(host, id, true);
        SECURITY_MODIFIED_LOGGER.logBoolean(SecType.SAFE_URL_OBSERVED, (Object)host, !observedMatcheResult);
        return safeUrlMatchable.blockUrlMatches(host, id, false);
    }

    static {
        extensionHeadMap = SafeUrlCheckerImpl.genDefaultExtensionHeadMap();
        resourceContainer = SecuritySingletonResourceContainer.getInstance();
    }

    public static class SafeUrlCheckerHolder {
        public static SafeUrlChecker instance = new SafeUrlCheckerImpl();
    }
}

