/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.resource.ssrf.loader.formatter;

import com.alibaba.security.resource.ResourceParseException;
import com.alibaba.security.resource.ssrf.loader.formatter.StringListFormatter;
import com.alibaba.security.url.model.SubnetMask;
import com.alibaba.security.util.AssertUtil;
import com.alibaba.security.util.IpAddressUtil;
import java.util.ArrayList;
import java.util.List;

public class Ipv6s2SubnetMaskStringListFormatter
implements StringListFormatter<SubnetMask> {
    @Override
    public List<String> format(List<SubnetMask> ipv6s) {
        ArrayList<String> toInsertList = new ArrayList<String>();
        for (SubnetMask subnetMask : AssertUtil.notNull(ipv6s, "ips should not be null.")) {
            byte[] ipBytes = IpAddressUtil.textToNumericFormatV6(subnetMask.getAddress());
            if (ipBytes == null) {
                throw new ResourceParseException("Failed to parse " + subnetMask);
            }
            String ipAddressBinaryArray = IpAddressUtil.convertIpBytesToString(ipBytes);
            ipAddressBinaryArray = ipAddressBinaryArray.substring(0, subnetMask.getMask());
            if (subnetMask.getMask() == 128) {
                toInsertList.add(ipAddressBinaryArray);
                continue;
            }
            toInsertList.add(ipAddressBinaryArray + '*');
        }
        return toInsertList;
    }
}

