/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.resource.ssrf.loader;

import com.alibaba.security.config.ConfigLoader;
import com.alibaba.security.resource.ssrf.config.xml.Domain;
import com.alibaba.security.resource.ssrf.config.xml.Ip;
import com.alibaba.security.resource.ssrf.config.xml.Ipv6;
import com.alibaba.security.resource.ssrf.config.xml.MatcherType;
import com.alibaba.security.resource.ssrf.loader.formatter.SSRFMatcherParamsFormatters;
import com.alibaba.security.resource.ssrf.matcher.SsrfMatchable;
import com.alibaba.security.url.model.DomainMask;
import com.alibaba.security.url.model.SSRFMatcherEnum;
import com.alibaba.security.url.model.SubnetMask;
import com.alibaba.security.util.matcher.DelegateStringMatcher;
import com.alibaba.security.util.matcher.SetBasedStringMatcher;
import com.alibaba.security.util.matcher.StringMatcher;
import com.alibaba.security.util.matcher.TrieStringMatcher;
import com.alibaba.security.util.trie.converter.BinaryTrieNodeConverter;
import com.alibaba.security.util.trie.converter.HostLetterTrieNodeConverter;
import com.alibaba.securitysdk.resource.TypedFileResourceLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractSsrfMatcherLoader
implements TypedFileResourceLoader<SsrfMatchable> {
    public Path getLocation() {
        return Paths.get(ConfigLoader.loadSecurityConfig().getSsrfLocation(), new String[0]);
    }

    protected void buildIpv6sTrie(List<Ipv6> ipStringList, SSRFMatcherEnum intranetIpv6, Map<SSRFMatcherEnum, StringMatcher> rootNodeMap) {
        ArrayList<SubnetMask> ipv6s = new ArrayList<SubnetMask>();
        for (Ipv6 ipv6 : ipStringList) {
            ipv6s.add(SubnetMask.parse((String)ipv6.getValue()));
        }
        List<String> toInsertList = SSRFMatcherParamsFormatters.formatSubnetMasks(intranetIpv6, ipv6s);
        SetBasedStringMatcher trieStringMatcher = new TrieStringMatcher(new BinaryTrieNodeConverter()).addItems(toInsertList);
        rootNodeMap.put(intranetIpv6, new DelegateStringMatcher(trieStringMatcher));
    }

    protected void buildDomainsMatcher(List<Domain> domainList, SSRFMatcherEnum matcherEnum, Map<SSRFMatcherEnum, StringMatcher> rootNodeMap) {
        ArrayList<DomainMask> domainMasks = new ArrayList<DomainMask>();
        for (Domain domain : domainList) {
            domainMasks.add(new DomainMask(domain.getValue(), this.convert(domain.getMatcherType())));
        }
        List<String> toInsertList = SSRFMatcherParamsFormatters.formatDomainMasks(domainMasks);
        if (toInsertList != null) {
            SetBasedStringMatcher trieStringMatcher = new TrieStringMatcher(new HostLetterTrieNodeConverter(), false).addItems(toInsertList);
            rootNodeMap.put(matcherEnum, new DelegateStringMatcher(trieStringMatcher));
        }
    }

    protected void buildIpsTrie(List<Ip> ipStringList, SSRFMatcherEnum matcherEnum, Map<SSRFMatcherEnum, StringMatcher> rootNodeMap) {
        ArrayList<SubnetMask> ips = new ArrayList<SubnetMask>();
        for (Ip ip : ipStringList) {
            ips.add(SubnetMask.parse((String)ip.getValue()));
        }
        List<String> toInsertList = SSRFMatcherParamsFormatters.formatSubnetMasks(matcherEnum, ips);
        SetBasedStringMatcher trieStringMatcher = new TrieStringMatcher(new BinaryTrieNodeConverter()).addItems(toInsertList);
        rootNodeMap.put(matcherEnum, new DelegateStringMatcher(trieStringMatcher));
    }

    public Class<SsrfMatchable> getType() {
        return SsrfMatchable.class;
    }

    private DomainMask.MatcherType convert(MatcherType matcherType) {
        return DomainMask.MatcherType.valueOf((String)matcherType.value());
    }
}

