/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.resource.safeurl.loader.resolver;

import com.alibaba.security.resource.safeurl.config.json.SafeUrlJsonConfig;
import com.alibaba.security.resource.safeurl.config.xml.Domain;
import com.alibaba.security.resource.safeurl.config.xml.DomainList;
import com.alibaba.security.resource.safeurl.loader.parser.SafeUrlJsonParser;
import com.alibaba.security.resource.safeurl.loader.resolver.AbstractSyncSafeUrlResolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SafeUrlJsonConfigResolver
extends AbstractSyncSafeUrlResolver {
    private String resourcePath;
    private String path;
    private boolean absoluteFilePath;
    private boolean isObserver;

    public SafeUrlJsonConfigResolver(String resourcePath) {
        this(resourcePath, null, true, false);
    }

    public SafeUrlJsonConfigResolver(String resourcePath, String path, boolean absoluteFilePath, boolean isObserver) {
        this.resourcePath = resourcePath;
        this.path = path;
        this.absoluteFilePath = absoluteFilePath;
        this.isObserver = isObserver;
    }

    @Override
    void resolve() {
        SafeUrlJsonConfig safeUrlJsonConfig = (SafeUrlJsonConfig)new SafeUrlJsonParser(this.resourcePath, this.path, this.absoluteFilePath).parse();
        if (safeUrlJsonConfig != null) {
            SafeUrlJsonConfig.SafeurlBean safeurl;
            SafeUrlJsonConfig.SafeurlBean safeurlBean = safeurl = this.isObserver ? safeUrlJsonConfig.getObservedSafeurl() : safeUrlJsonConfig.getSafeurl();
            if (safeurl != null) {
                this.mergeSafeDomainsList(this.convertJsonDomainsToPojo(safeurl.getSafedomains()));
                this.mergeBlockDomainsList(this.convertJsonDomainsToPojo(safeurl.getBlockdomains()));
            }
        }
    }

    private List<DomainList> convertJsonDomainsToPojo(List<SafeUrlJsonConfig.SafeurlBean.DomainsBean> DomainsBeans) {
        if (DomainsBeans == null) {
            return Collections.emptyList();
        }
        ArrayList<DomainList> domainLists = new ArrayList<DomainList>();
        for (SafeUrlJsonConfig.SafeurlBean.DomainsBean DomainsBean2 : DomainsBeans) {
            DomainList domainList = new DomainList();
            domainList.setName(DomainsBean2.getName());
            domainLists.add(domainList);
            for (SafeUrlJsonConfig.SafeurlBean.DomainsBean.DomainBean domainBean : DomainsBean2.getDomainList()) {
                domainList.getDomain().add(Domain.newDomain(domainBean.getDomain(), domainBean.getMatcherType()));
            }
        }
        return domainLists;
    }
}

