/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.resource.safeurl.loader.resolver;

import com.alibaba.security.resource.safeurl.config.xml.Domain;
import com.alibaba.security.resource.safeurl.config.xml.DomainList;
import com.alibaba.security.resource.safeurl.loader.resolver.SafeUrlResolver;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractSyncSafeUrlResolver
implements SafeUrlResolver {
    protected Map<String, DomainList> safeDomains = new HashMap<String, DomainList>();
    protected Map<String, DomainList> blockDomains = new HashMap<String, DomainList>();
    private volatile boolean resolved = false;

    abstract void resolve();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void syncResolve() {
        if (!this.resolved) {
            AbstractSyncSafeUrlResolver abstractSyncSafeUrlResolver = this;
            synchronized (abstractSyncSafeUrlResolver) {
                if (!this.resolved) {
                    this.clearAll();
                    this.resolve();
                    this.resolved = true;
                }
            }
        }
    }

    protected void clearAll() {
        this.safeDomains.clear();
        this.blockDomains.clear();
    }

    protected void mergeSafeDomainsList(Collection<DomainList> domainLists) {
        for (DomainList domainList : domainLists) {
            this.addDomains(domainList, this.safeDomains);
        }
    }

    protected void mergeBlockDomainsList(Collection<DomainList> domainLists) {
        for (DomainList domainList : domainLists) {
            this.addDomains(domainList, this.blockDomains);
        }
    }

    protected void addDomains(DomainList domainList, Map<String, DomainList> domainListMap) {
        if (domainListMap.containsKey(domainList.getName())) {
            DomainList list = domainListMap.get(domainList.getName());
            list.getDomain().addAll(domainList.getDomain());
        } else {
            DomainList newDomainList = new DomainList();
            newDomainList.setName(domainList.getName());
            newDomainList.getDomain().addAll(domainList.getDomain());
            domainListMap.put(domainList.getName(), newDomainList);
        }
    }

    @Override
    public Map<String, DomainList> resolveSafeDomains() {
        this.syncResolve();
        return this.safeDomains;
    }

    @Override
    public Map<String, DomainList> resolveBlockDomains() {
        this.syncResolve();
        return this.blockDomains;
    }

    @Override
    public List<Domain> defaultSafeDomains() {
        return this.resolveSafeDomains("");
    }

    @Override
    public List<Domain> defaultBlockDomains() {
        return this.resolveBlockDomains("");
    }

    @Override
    public List<Domain> resolveSafeDomains(String id) {
        this.syncResolve();
        return this.safeDomains.get(id).getDomain();
    }

    @Override
    public List<Domain> resolveBlockDomains(String id) {
        this.syncResolve();
        return this.blockDomains.get(id).getDomain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        AbstractSyncSafeUrlResolver abstractSyncSafeUrlResolver = this;
        synchronized (abstractSyncSafeUrlResolver) {
            this.resolved = false;
        }
    }
}

