/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.resource.safeurl.loader.parser;

import com.alibaba.security.resource.safeurl.config.xml.Domain;
import com.alibaba.security.resource.safeurl.config.xml.DomainList;
import com.alibaba.security.resource.safeurl.config.xml.Domains;
import com.alibaba.security.url.safeurl.ParseWhiteListException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SafeUrlXmlParser {
    private static final Logger logger = Logger.getLogger(SafeUrlXmlParser.class.getName());
    private static final String SAFE_DOMAINS = "safedomains";
    private static final String BLOCK_DOMAINS = "blockdomains";
    private static final String EXCLUDE_DOMAINS = "ecludedomains";
    private static final String SAFE_IMG_EXTENSIONS = "safeImgExtensions";
    private static final String DOMAIN_LIST_TAG_ID_NAME = "name";
    private static final String DOMAIN_TAG_NAME = "domain";
    private static final String DOMAIN_MATCHER_TYPE_ATTRIBUTE_NAME = "matcherType";
    private static final String IMG_EXTENSION = "imgExtension";
    private InputStream inputStream;

    public SafeUrlXmlParser(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public Domains parse() throws ParseWhiteListException {
        Domains domains = new Domains();
        List<DomainList> safedomains = domains.getSafedomains();
        List<DomainList> blockdomains = domains.getBlockdomains();
        Element root = this.getDocument(this.inputStream).getDocumentElement();
        safedomains.addAll(this.parseDocument(root, SAFE_DOMAINS));
        blockdomains.addAll(this.parseDocument(root, BLOCK_DOMAINS));
        return domains;
    }

    private Document getDocument(InputStream is) throws ParseWhiteListException {
        Document dom;
        if (is == null) {
            throw new ParseWhiteListException("Cannot read any files of safe domains.");
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            dom = db.parse(is);
        }
        catch (ParserConfigurationException e) {
            logger.log(Level.SEVERE, "parse white list error");
            throw new ParseWhiteListException(e);
        }
        catch (SAXException e) {
            logger.log(Level.SEVERE, "parse white list error");
            throw new ParseWhiteListException(e);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "read whitelist file error");
            throw new ParseWhiteListException(e);
        }
        return dom;
    }

    private List<DomainList> parseDocument(Element root, String tag) {
        NodeList nodes = root.getElementsByTagName(tag);
        ArrayList<DomainList> toInsertList = new ArrayList<DomainList>();
        for (int k = 0; k < nodes.getLength(); ++k) {
            Element node = (Element)nodes.item(k);
            String name = node.getAttribute(DOMAIN_LIST_TAG_ID_NAME);
            DomainList domainList = new DomainList();
            domainList.setName(name);
            toInsertList.add(domainList);
            NodeList domainNodes = node.getElementsByTagName(DOMAIN_TAG_NAME);
            for (int i = 0; i < domainNodes.getLength(); ++i) {
                Element element = (Element)domainNodes.item(i);
                String value = element.getTextContent();
                String matcherType = element.getAttribute(DOMAIN_MATCHER_TYPE_ATTRIBUTE_NAME);
                domainList.getDomain().add(Domain.newDomain(value, matcherType));
            }
        }
        return toInsertList;
    }
}

