/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.resource.safeurl.loader;

import com.alibaba.security.config.ConfigLoader;
import com.alibaba.security.config.SecurityConfig;
import com.alibaba.security.resource.safeurl.config.xml.Domain;
import com.alibaba.security.resource.safeurl.config.xml.DomainList;
import com.alibaba.security.resource.safeurl.config.xml.MatcherType;
import com.alibaba.security.resource.safeurl.loader.SafeUrlMatcherEnum;
import com.alibaba.security.resource.safeurl.loader.resolver.CompositeSafeUrlResolver;
import com.alibaba.security.resource.safeurl.loader.resolver.SafeUrlJsonConfigResolver;
import com.alibaba.security.resource.safeurl.loader.resolver.SafeUrlResolver;
import com.alibaba.security.resource.safeurl.loader.resolver.SafeUrlXmlConfigResolver;
import com.alibaba.security.resource.safeurl.matcher.SafeUrlMatchable;
import com.alibaba.security.resource.safeurl.matcher.SafeUrlMatcher;
import com.alibaba.security.util.IOUtils;
import com.alibaba.security.util.ResourceUtil;
import com.alibaba.security.util.matcher.SetBasedStringMatcher;
import com.alibaba.security.util.matcher.StringMatcher;
import com.alibaba.security.util.matcher.TrieStringMatcher;
import com.alibaba.security.util.trie.converter.HostLetterTrieNodeConverter;
import com.alibaba.securitysdk.resource.TypedFileResourceLoader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SafeUrlMatcherLoader
implements TypedFileResourceLoader<SafeUrlMatchable> {
    private static final Logger logger = Logger.getLogger(SafeUrlMatcherLoader.class.getName());
    private SafeUrlResolver compositeSsrfResolver;
    private SafeUrlResolver observedCompositeSsrfResolver;
    private static boolean productionMode = true;
    private static final SecurityConfig SECURITY_CONFIG = ConfigLoader.loadSecurityConfig();

    public SafeUrlMatcherLoader() {
        SafeUrlXmlConfigResolver xmlConfigResolver = new SafeUrlXmlConfigResolver(productionMode);
        if (SECURITY_CONFIG.isJsonResourcesLoadingEnable()) {
            SafeUrlJsonConfigResolver jsonConfigResolver = new SafeUrlJsonConfigResolver(SECURITY_CONFIG.getSafeurlLocation(), SECURITY_CONFIG.getSafeurlConfPath(), SECURITY_CONFIG.isSafeurlAbsolutePath(), false);
            SafeUrlJsonConfigResolver observedJsonConfigResolver = new SafeUrlJsonConfigResolver(SECURITY_CONFIG.getSafeurlLocation(), SECURITY_CONFIG.getSafeurlConfPath(), SECURITY_CONFIG.isSafeurlAbsolutePath(), true);
            this.compositeSsrfResolver = new CompositeSafeUrlResolver(xmlConfigResolver, jsonConfigResolver);
            this.observedCompositeSsrfResolver = new CompositeSafeUrlResolver(observedJsonConfigResolver);
        } else {
            this.compositeSsrfResolver = new CompositeSafeUrlResolver(xmlConfigResolver);
        }
    }

    private static void loadEnvironmentConfig() {
        InputStream is = ResourceUtil.getDefaultConfigInputStream();
        try {
            Properties props = new Properties();
            if (is != null) {
                props.load(is);
                if ("false".equalsIgnoreCase(props.getProperty("security.safeurl.production.mode", "true").trim())) {
                    productionMode = false;
                    logger.log(Level.WARNING, "Now safe domains of daily environment is configured. Do remember to remove this configuration in production environment!");
                }
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Fail to load the safe domains of daily environment. Safe domains of production environment is configured by default.");
        }
        finally {
            IOUtils.closeQuietly(is);
        }
    }

    public Path getLocation() {
        return Paths.get(ConfigLoader.loadSecurityConfig().getSafeurlLocation(), new String[0]);
    }

    public SafeUrlMatchable load(Path path) {
        Map<SafeUrlMatcherEnum, Map<String, StringMatcher>> safeUrlMatcherEnumMapMap = this.resolveAndBuildMap(this.compositeSsrfResolver, SafeUrlMatcherEnum.SAFE_URL, SafeUrlMatcherEnum.BLOCK_URL);
        Map<SafeUrlMatcherEnum, Map<String, StringMatcher>> observedSafeUrlMatcherEnumMapMap = this.resolveAndBuildMap(this.observedCompositeSsrfResolver, SafeUrlMatcherEnum.SAFE_URL, SafeUrlMatcherEnum.BLOCK_URL);
        return new SafeUrlMatcher(safeUrlMatcherEnumMapMap, observedSafeUrlMatcherEnumMapMap);
    }

    private Map<SafeUrlMatcherEnum, Map<String, StringMatcher>> resolveAndBuildMap(SafeUrlResolver safeUrlResolver, SafeUrlMatcherEnum safeUrlMatcherEnum, SafeUrlMatcherEnum blockUrlMatcherEnum) {
        if (safeUrlResolver == null) {
            return Collections.emptyMap();
        }
        EnumMap<SafeUrlMatcherEnum, Map<String, StringMatcher>> rootNodeMap = new EnumMap<SafeUrlMatcherEnum, Map<String, StringMatcher>>(SafeUrlMatcherEnum.class);
        safeUrlResolver.reset();
        Map<String, DomainList> safeDomains = safeUrlResolver.resolveSafeDomains();
        Map<String, StringMatcher> safeStringMatchers = SafeUrlMatcherLoader.buildDomainsMatchers(safeDomains);
        rootNodeMap.put(safeUrlMatcherEnum, safeStringMatchers);
        Map<String, DomainList> blockDomains = safeUrlResolver.resolveBlockDomains();
        Map<String, StringMatcher> blockStringMatchers = SafeUrlMatcherLoader.buildDomainsMatchers(blockDomains);
        rootNodeMap.put(blockUrlMatcherEnum, blockStringMatchers);
        return rootNodeMap;
    }

    private static Map<String, StringMatcher> buildDomainsMatchers(Map<String, DomainList> safeDomains) {
        HashMap<String, StringMatcher> matcherMap = new HashMap<String, StringMatcher>();
        for (Map.Entry<String, DomainList> entry : safeDomains.entrySet()) {
            matcherMap.put(entry.getKey(), SafeUrlMatcherLoader.buildDomainsMatcher(entry.getValue().getDomain()));
        }
        return matcherMap;
    }

    private static SetBasedStringMatcher buildDomainsMatcher(List<Domain> domains) {
        ArrayList<String> toInsertList = new ArrayList<String>();
        for (Domain domain : domains) {
            toInsertList.add(domain.getValue());
            if (domain.getMatcherType() != MatcherType.TRIE) continue;
            toInsertList.add("*." + domain.getValue());
        }
        return new TrieStringMatcher(new HostLetterTrieNodeConverter(), false).addItems(toInsertList);
    }

    public Class<SafeUrlMatchable> getType() {
        return SafeUrlMatchable.class;
    }

    static {
        SafeUrlMatcherLoader.loadEnvironmentConfig();
    }
}

