/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.resource;

import com.alibaba.security.config.ConfigLoader;
import com.alibaba.security.resource.LoggableBaseConfigCompositeResourceLoader;
import com.alibaba.security.resource.ResourceContainer;
import com.alibaba.security.resource.safeurl.loader.SafeUrlMatcherLoader;
import com.alibaba.security.resource.ssrf.loader.SsrfMatcherLoader;
import com.alibaba.securitysdk.com.typesafe.config.ConfigFactory;
import com.alibaba.securitysdk.logging.utils.ClassUtils;
import com.alibaba.securitysdk.resource.exception.ResourceLoadingException;
import com.alibaba.securitysdk.resource.exception.ResourceSwapException;
import com.alibaba.securitysdk.resource.impl.CompositeResource;
import com.alibaba.securitysdk.resource.impl.CompositeResourceLoader;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SecuritySingletonResourceContainer
implements ResourceContainer {
    private static final Logger LOGGER = Logger.getLogger(SecuritySingletonResourceContainer.class.getName());
    private Map<Path, CompositeResourceLoader<?>> resourceLoaderMap = new ConcurrentHashMap();
    private Map<Path, CompositeResource<?>> resourceMap = new ConcurrentHashMap();
    private Path securityPath = Paths.get(ConfigLoader.loadSecurityConfig().getBaseLocation(), new String[0]);
    private static ResourceContainer instance;
    private static List<String> rootClassLoaders;
    private static String[] INNER_CLASS_LOADERS;

    private SecuritySingletonResourceContainer() {
        this.registerCompositeResources();
    }

    private void registerCompositeResources() {
        SsrfMatcherLoader ssrfMatcherLoader = new SsrfMatcherLoader();
        SafeUrlMatcherLoader safeUrlMatcherLoader = new SafeUrlMatcherLoader();
        LoggableBaseConfigCompositeResourceLoader resourceLoader = new LoggableBaseConfigCompositeResourceLoader(ssrfMatcherLoader.getLocation(), ssrfMatcherLoader, safeUrlMatcherLoader);
        this.registerCompositeResource(resourceLoader);
    }

    private void registerCompositeResource(CompositeResourceLoader<?> compositeResourceLoader) {
        Path location = compositeResourceLoader.getLocation();
        if (this.resourceLoaderMap.containsKey(location)) {
            throw new RuntimeException();
        }
        this.resourceLoaderMap.put(location, compositeResourceLoader);
        Boolean recursiveWatchResource = ConfigLoader.loadSecurityConfig().getRecursiveWatchResource();
        CompositeResource<?> compositeResource = this.newCompositeResource(compositeResourceLoader, recursiveWatchResource);
        if (compositeResource != null) {
            this.resourceMap.put(location, compositeResource);
        }
    }

    private CompositeResource<?> newCompositeResource(CompositeResourceLoader<?> compositeResourceLoader, Boolean recursiveWatchResource) {
        try {
            if (recursiveWatchResource == null) {
                return new CompositeResource(compositeResourceLoader, false);
            }
            return new CompositeResource(compositeResourceLoader, recursiveWatchResource.booleanValue(), false);
        }
        catch (ResourceLoadingException | ResourceSwapException ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            return null;
        }
    }

    private static boolean matches(ClassLoader classLoader) {
        if (rootClassLoaders == null || rootClassLoaders.isEmpty() || classLoader == null) {
            return false;
        }
        for (String rootClassLoader : rootClassLoaders) {
            if (rootClassLoader == null) continue;
            String name = classLoader.getClass().getName();
            if (!(rootClassLoader.endsWith("*") ? name.startsWith(rootClassLoader.substring(0, rootClassLoader.length() - 1)) : name.endsWith(rootClassLoader))) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> T getSecurityResource(Class<T> clazz) {
        return (T)this.resourceMap.get(this.securityPath).getResource(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ResourceContainer getInstance() {
        if (instance != null) return instance;
        Class<SecuritySingletonResourceContainer> clazz = SecuritySingletonResourceContainer.class;
        synchronized (SecuritySingletonResourceContainer.class) {
            if (instance != null) return instance;
            ClassLoader myClassLoader = SecuritySingletonResourceContainer.class.getClassLoader();
            if (!SecuritySingletonResourceContainer.matches(myClassLoader) && !SecuritySingletonResourceContainer.isInnerClassLoader(myClassLoader)) {
                try {
                    ClassLoader parentClassLoader = SecuritySingletonResourceContainer.class.getClassLoader().getParent();
                    Class<?> otherClassInstance = parentClassLoader.loadClass(SecuritySingletonResourceContainer.class.getName());
                    Method getInstanceMethod = otherClassInstance.getDeclaredMethod("getInstance", new Class[0]);
                    Object otherAbsoluteSingleton = getInstanceMethod.invoke(null, new Object[0]);
                    instance = (ResourceContainer)ClassUtils.cast((ClassLoader)myClassLoader, ResourceContainer.class, (Object)otherAbsoluteSingleton);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    String config = "security.resource.container.root-classloader=" + myClassLoader.getClass().getName();
                    instance = new SecuritySingletonResourceContainer();
                    LOGGER.info("SecuritySingletonResourceContainer has been loaded by " + config);
                }
            } else {
                instance = new SecuritySingletonResourceContainer();
                LOGGER.info("SecuritySingletonResourceContainer has been loaded by " + myClassLoader.getClass().getName());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static boolean isInnerClassLoader(ClassLoader myClassLoader) {
        for (String loader : INNER_CLASS_LOADERS) {
            if (!myClassLoader.getClass().getName().startsWith(loader)) continue;
            return true;
        }
        return false;
    }

    static {
        try {
            String theClassloader = ConfigFactory.load().resolve().getString("security.resource.container.root-classloader");
            if (theClassloader != null && !theClassloader.isEmpty()) {
                String[] theClassLoaders = theClassloader.split(",");
                rootClassLoaders = new ArrayList<String>(theClassLoaders.length);
                for (String rootClassloader : theClassLoaders) {
                    rootClassLoaders.add(rootClassloader.trim());
                }
            }
            LOGGER.info("Root classloader of resource container are " + rootClassLoaders);
        }
        catch (Exception exception) {
            // empty catch block
        }
        INNER_CLASS_LOADERS = new String[]{"sun.", "com.taobao.pandora.boot.loader", "org.springframework.boot.loader.LaunchedURLClassLoader", "org.apache.catalina.loader.ParallelWebappClassLoader", "org.apache.catalina.loader.WebappClassLoader", "com.alibaba.kondyle.loader.solution.loader.ServerlessClassLoader"};
    }
}

