/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.resource;

import com.alibaba.security.resource.ResourceParser;
import com.alibaba.security.resource.safeurl.loader.parser.SafeUrlJsonParser;
import com.alibaba.security.util.AssertUtil;
import com.alibaba.securitysdk.com.typesafe.config.Config;
import com.alibaba.securitysdk.com.typesafe.config.ConfigBeanFactory;
import com.alibaba.securitysdk.com.typesafe.config.ConfigException;
import com.alibaba.securitysdk.com.typesafe.config.ConfigFactory;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractResourceParser<R>
implements ResourceParser<R> {
    private static final Logger logger = Logger.getLogger(SafeUrlJsonParser.class.getName());
    private boolean absoluteFilePath;
    private String resourceBasename;
    private String path;

    public AbstractResourceParser(String resourceBasename) {
        this(resourceBasename, null, false);
    }

    public AbstractResourceParser(String resourceBasename, String path) {
        this(resourceBasename, path, false);
    }

    public AbstractResourceParser(String resourceBasename, String path, boolean absoluteFilePath) {
        this.resourceBasename = AssertUtil.notNull(resourceBasename, "The resourceBasename should not be null.");
        this.absoluteFilePath = absoluteFilePath;
        this.path = path;
    }

    @Override
    public R parse() {
        try {
            Config config = this.absoluteFilePath ? ConfigFactory.parseFile((File)new File(this.resourceBasename)) : ConfigFactory.load((String)this.resourceBasename);
            if (this.path != null && config.hasPath(this.path)) {
                config = config.getConfig(this.path);
            }
            return (R)ConfigBeanFactory.create((Config)config, this.getResourceClass());
        }
        catch (ConfigException ex) {
            logger.log(Level.WARNING, "Fail to load the configuration file. Cause : " + ex.getMessage());
            return null;
        }
    }
}

