/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.mask.name;

import com.alibaba.security.mask.name.ChineseFamilyNameLoader;
import com.alibaba.security.mask.name.ChineseName;
import com.alibaba.security.mask.name.NameNormalizer;
import com.alibaba.security.util.Function;
import com.alibaba.security.util.Maps;
import com.alibaba.security.util.trie.AhoCorasickDoubleArrayTrie;
import java.util.List;
import java.util.Map;

public class SimpleNameNormalizer
implements NameNormalizer {
    private static final AhoCorasickDoubleArrayTrie<String> COMPOUND_SURNAMES_TRIE = new AhoCorasickDoubleArrayTrie();
    private static final AhoCorasickDoubleArrayTrie<String> SINGLE_SURNAMES_TRIE = new AhoCorasickDoubleArrayTrie();

    private static void buildTrie(List<String> surnames, AhoCorasickDoubleArrayTrie<String> trie) {
        Map<String, String> entityMap = Maps.index(surnames, new Function<String, String>(){

            @Override
            public String apply(String key) {
                return key;
            }
        });
        trie.build(entityMap);
    }

    public ChineseName normalizeChineseName(String name) {
        AhoCorasickDoubleArrayTrie.Hit<String> hit;
        if (name == null || name.isEmpty() || name.length() == 1) {
            return null;
        }
        String surname = null;
        if (name.length() > 2 && (hit = COMPOUND_SURNAMES_TRIE.findFirst(name)) != null) {
            surname = (String)hit.value;
        }
        if (surname == null && (hit = SINGLE_SURNAMES_TRIE.findFirst(name)) != null) {
            surname = (String)hit.value;
        }
        String firstName = surname == null ? name : name.substring(surname.length());
        return new ChineseName(surname, firstName);
    }

    static {
        SimpleNameNormalizer.buildTrie(ChineseFamilyNameLoader.instance.getSingleSurnames(), SINGLE_SURNAMES_TRIE);
        SimpleNameNormalizer.buildTrie(ChineseFamilyNameLoader.instance.getCompoundSurnames(), COMPOUND_SURNAMES_TRIE);
    }
}

