/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.fluentjob.api.workflow;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.xml.bind.JAXBException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.oozie.fluentjob.api.action.Node;
import org.apache.oozie.fluentjob.api.serialization.WorkflowMarshaller;
import org.apache.oozie.fluentjob.api.workflow.Credentials;
import org.apache.oozie.fluentjob.api.workflow.Global;
import org.apache.oozie.fluentjob.api.workflow.Parameters;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class Workflow {
    private final String name;
    private final ImmutableSet<Node> nodes;
    private final ImmutableSet<Node> roots;
    private final Parameters parameters;
    private final Global global;
    private final Credentials credentials;

    Workflow(String name, ImmutableSet<Node> nodes, Parameters parameters, Global global, Credentials credentials) {
        this.global = global;
        this.checkUniqueNames((Set<Node>)nodes);
        this.name = name;
        this.nodes = nodes;
        Set<Node> mutableRoots = this.findMutableRoots(nodes);
        this.roots = ImmutableSet.copyOf(mutableRoots);
        this.parameters = parameters;
        this.credentials = credentials;
    }

    public String getName() {
        return this.name;
    }

    public Set<Node> getNodes() {
        return this.nodes;
    }

    public Set<Node> getAllNodes() {
        LinkedHashSet allNodes = Sets.newLinkedHashSet();
        LinkedList<Node> nodesToAdd = new LinkedList<Node>();
        nodesToAdd.addAll((Collection<Node>)this.nodes);
        while (!nodesToAdd.isEmpty()) {
            Node nodeToAdd = (Node)nodesToAdd.poll();
            allNodes.add(nodeToAdd);
            nodesToAdd.addAll(nodeToAdd.getAllChildren());
        }
        return ImmutableSet.copyOf((Collection)allNodes);
    }

    public Set<Node> getRoots() {
        return this.roots;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public Global getGlobal() {
        return this.global;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    private void checkUniqueNames(Set<Node> nodes) {
        HashSet<String> names = new HashSet<String>();
        for (Node node : nodes) {
            Preconditions.checkArgument((!names.contains(node.getName()) ? 1 : 0) != 0, (Object)String.format("Duplicate name '%s' found in workflow '%s'", node.getName(), this.getName()));
            names.add(node.getName());
        }
    }

    private Set<Node> findMutableRoots(ImmutableSet<Node> nodes) {
        LinkedHashSet<Node> mutableRoots = new LinkedHashSet<Node>();
        for (Node node : nodes) {
            if (!node.getAllParents().isEmpty()) continue;
            mutableRoots.add(node);
        }
        return mutableRoots;
    }

    public String asXml() throws JAXBException, UnsupportedEncodingException {
        return WorkflowMarshaller.marshal(this);
    }
}

