/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.fluentjob.api.workflow;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.oozie.fluentjob.api.ModifyOnce;
import org.apache.oozie.fluentjob.api.action.Builder;
import org.apache.oozie.fluentjob.api.workflow.ConfigurationEntry;
import org.apache.oozie.fluentjob.api.workflow.Credential;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class CredentialBuilder
implements Builder<Credential> {
    private final ModifyOnce<String> name;
    private final ModifyOnce<String> type;
    private final List<ConfigurationEntry> configurationEntries;

    public static CredentialBuilder create() {
        ModifyOnce<String> name = new ModifyOnce<String>();
        ModifyOnce<String> type = new ModifyOnce<String>();
        ArrayList<ConfigurationEntry> configurationEntries = new ArrayList<ConfigurationEntry>();
        return new CredentialBuilder(name, type, configurationEntries);
    }

    public static CredentialBuilder createFromExisting(Credential credential) {
        return new CredentialBuilder(new ModifyOnce<String>(credential.getName()), new ModifyOnce<String>(credential.getType()), new ArrayList<ConfigurationEntry>(credential.getConfigurationEntries()));
    }

    private CredentialBuilder(ModifyOnce<String> name, ModifyOnce<String> type, List<ConfigurationEntry> configurationEntries) {
        this.name = name;
        this.type = type;
        this.configurationEntries = configurationEntries;
    }

    public CredentialBuilder withName(String name) {
        this.name.set(name);
        return this;
    }

    public CredentialBuilder withType(String type) {
        this.type.set(type);
        return this;
    }

    public CredentialBuilder withConfigurationEntry(String name, String description) {
        this.configurationEntries.add(new ConfigurationEntry(name, description));
        return this;
    }

    @Override
    public Credential build() {
        return new Credential(this.name.get(), this.type.get(), (ImmutableList<ConfigurationEntry>)ImmutableList.copyOf(this.configurationEntries));
    }
}

