/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.fluentjob.api.serialization;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Locale;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.oozie.fluentjob.api.action.Node;
import org.apache.oozie.fluentjob.api.dag.Graph;
import org.apache.oozie.fluentjob.api.generated.workflow.ObjectFactory;
import org.apache.oozie.fluentjob.api.generated.workflow.WORKFLOWAPP;
import org.apache.oozie.fluentjob.api.mapping.DozerBeanMapperSingleton;
import org.apache.oozie.fluentjob.api.workflow.Workflow;

public class WorkflowMarshaller {
    public static String marshal(Workflow workflow) throws JAXBException, UnsupportedEncodingException {
        Graph graph = new Graph(workflow);
        WORKFLOWAPP workflowapp = (WORKFLOWAPP)DozerBeanMapperSingleton.instance().map((Object)graph, WORKFLOWAPP.class);
        String filteredPackages = WorkflowMarshaller.filterPackages(workflow);
        return WorkflowMarshaller.marshal(workflowapp, filteredPackages);
    }

    private static String marshal(WORKFLOWAPP workflowapp, String filteredPackages) throws JAXBException, UnsupportedEncodingException {
        JAXBElement<WORKFLOWAPP> wfElement = new ObjectFactory().createWorkflowApp(workflowapp);
        JAXBContext jc = JAXBContext.newInstance((String)filteredPackages);
        Marshaller m = jc.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        m.marshal(wfElement, (OutputStream)out);
        return out.toString(Charset.defaultCharset().name());
    }

    private static String filterPackages(Workflow workflow) {
        StringBuilder filteredPackages = new StringBuilder();
        filteredPackages.append("org.apache.oozie.fluentjob.api.generated.workflow");
        WorkflowMarshaller.appendIfPresent(workflow, filteredPackages, "distcp");
        WorkflowMarshaller.appendIfPresent(workflow, filteredPackages, "email");
        WorkflowMarshaller.appendIfPresent(workflow, filteredPackages, "git");
        WorkflowMarshaller.appendIfPresent(workflow, filteredPackages, "hive2");
        WorkflowMarshaller.appendIfPresent(workflow, filteredPackages, "hive");
        WorkflowMarshaller.appendIfPresent(workflow, filteredPackages, "sla");
        WorkflowMarshaller.appendIfPresent(workflow, filteredPackages, "shell");
        WorkflowMarshaller.appendIfPresent(workflow, filteredPackages, "spark");
        WorkflowMarshaller.appendIfPresent(workflow, filteredPackages, "sqoop");
        WorkflowMarshaller.appendIfPresent(workflow, filteredPackages, "ssh");
        return filteredPackages.toString();
    }

    private static void appendIfPresent(Workflow workflow, StringBuilder filteredPackages, String nodeType) {
        if (WorkflowMarshaller.containsNodeType(workflow, nodeType)) {
            filteredPackages.append(":org.apache.oozie.fluentjob.api.generated.action.").append(nodeType);
        }
    }

    private static boolean containsNodeType(Workflow workflow, String nodeType) {
        String actionType = nodeType + "action";
        for (Node node : workflow.getAllNodes()) {
            String errorHandlerSimpleName;
            String nodeSimpleName = node.getClass().getSimpleName();
            if (nodeSimpleName.toLowerCase(Locale.getDefault()).startsWith(actionType.toLowerCase(Locale.getDefault()))) {
                return true;
            }
            if (node.getErrorHandler() == null || !(errorHandlerSimpleName = node.getErrorHandler().getHandlerNode().getClass().getSimpleName()).toLowerCase(Locale.getDefault()).startsWith(actionType.toLowerCase(Locale.getDefault()))) continue;
            return true;
        }
        return false;
    }
}

