/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.fluentjob.api.mapping;

import com.github.dozermapper.core.DozerConverter;
import java.util.List;
import org.apache.oozie.fluentjob.api.dag.Fork;
import org.apache.oozie.fluentjob.api.dag.NodeBase;
import org.apache.oozie.fluentjob.api.generated.workflow.FORK;
import org.apache.oozie.fluentjob.api.generated.workflow.FORKTRANSITION;
import org.apache.oozie.fluentjob.api.generated.workflow.ObjectFactory;
import org.apache.oozie.fluentjob.api.mapping.RealChildLocator;

public class ForkConverter
extends DozerConverter<Fork, FORK> {
    private static final ObjectFactory WORKFLOW_OBJECT_FACTORY = new ObjectFactory();

    public ForkConverter() {
        super(Fork.class, FORK.class);
    }

    public FORK convertTo(Fork source, FORK destination) {
        destination = this.ensureDestination(destination);
        destination.setName(source.getName());
        List<FORKTRANSITION> transitions = destination.getPath();
        for (NodeBase child : source.getChildren()) {
            NodeBase realChild = RealChildLocator.findRealChild(child);
            transitions.add(this.convertToFORKTRANSITION(realChild));
        }
        return destination;
    }

    private FORK ensureDestination(FORK destination) {
        if (destination == null) {
            destination = WORKFLOW_OBJECT_FACTORY.createFORK();
        }
        return destination;
    }

    public Fork convertFrom(FORK source, Fork destination) {
        throw new UnsupportedOperationException("This mapping is not bidirectional.");
    }

    private FORKTRANSITION convertToFORKTRANSITION(NodeBase source) {
        FORKTRANSITION destination = WORKFLOW_OBJECT_FACTORY.createFORKTRANSITION();
        NodeBase realChild = RealChildLocator.findRealChild(source);
        destination.setStart(realChild.getName());
        return destination;
    }
}

