/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.fluentjob.api.dag;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.oozie.fluentjob.api.Condition;
import org.apache.oozie.fluentjob.api.dag.Decision;
import org.apache.oozie.fluentjob.api.dag.NodeBase;

public abstract class JoiningNodeBase<T>
extends NodeBase {
    private final List<NodeBase> parents = new ArrayList<NodeBase>();
    private NodeBase child;
    private final T branching;

    JoiningNodeBase(String name, T branching) {
        super(name);
        this.branching = branching;
    }

    public List<NodeBase> getParents() {
        return Collections.unmodifiableList(this.parents);
    }

    @Override
    public void addParent(NodeBase parent) {
        if (parent != null) {
            parent.addChild(this);
        }
        this.parents.add(parent);
    }

    @Override
    public void addParentWithCondition(Decision parent, Condition condition) {
        if (parent != null) {
            parent.addChildWithCondition(this, condition);
        }
        this.parents.add(parent);
    }

    @Override
    public void addParentDefaultConditional(Decision parent) {
        if (parent != null) {
            parent.addDefaultChild(this);
        }
        this.parents.add(parent);
    }

    @Override
    public void removeParent(NodeBase parent) {
        Preconditions.checkArgument((boolean)this.parents.remove(parent), (Object)"Trying to remove a nonexistent parent");
        parent.removeChild(this);
    }

    @Override
    public void clearParents() {
        ArrayList<NodeBase> oldParents = new ArrayList<NodeBase>(this.parents);
        for (NodeBase parent : oldParents) {
            this.removeParent(parent);
        }
    }

    @Override
    public List<NodeBase> getChildren() {
        if (this.child == null) {
            return Arrays.asList(new NodeBase[0]);
        }
        return Arrays.asList(this.child);
    }

    public NodeBase getChild() {
        return this.child;
    }

    T getBranchingPair() {
        return this.branching;
    }

    @Override
    protected void addChild(NodeBase child) {
        Preconditions.checkState((this.child == null ? 1 : 0) != 0, (Object)"JoiningNodeBase nodes cannot have multiple children.");
        this.child = child;
    }

    @Override
    protected void removeChild(NodeBase child) {
        Preconditions.checkArgument((this.child == child ? 1 : 0) != 0, (Object)"Trying to remove a nonexistent child.");
        this.child = null;
    }
}

