/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.fluentjob.api.dag;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.oozie.fluentjob.api.Condition;
import org.apache.oozie.fluentjob.api.action.Node;
import org.apache.oozie.fluentjob.api.dag.DagNodeWithCondition;
import org.apache.oozie.fluentjob.api.dag.Decision;
import org.apache.oozie.fluentjob.api.dag.DecisionJoin;
import org.apache.oozie.fluentjob.api.dag.End;
import org.apache.oozie.fluentjob.api.dag.ExplicitNode;
import org.apache.oozie.fluentjob.api.dag.Fork;
import org.apache.oozie.fluentjob.api.dag.Join;
import org.apache.oozie.fluentjob.api.dag.NodeBase;
import org.apache.oozie.fluentjob.api.dag.Start;
import org.apache.oozie.fluentjob.api.workflow.Credentials;
import org.apache.oozie.fluentjob.api.workflow.Global;
import org.apache.oozie.fluentjob.api.workflow.Parameters;
import org.apache.oozie.fluentjob.api.workflow.Workflow;

public class Graph {
    private final String name;
    private final Start start = new Start("start");
    private final End end = new End("end");
    private final Parameters parameters;
    private final Global global;
    private final Credentials credentials;
    private final Map<String, NodeBase> nodesByName = new LinkedHashMap<String, NodeBase>();
    private final Map<Fork, Integer> forkNumbers = new HashMap<Fork, Integer>();
    private int forkCounter = 1;
    private final Map<NodeBase, Decision> originalParentToCorrespondingDecision = new HashMap<NodeBase, Decision>();
    private final Map<Decision, Integer> closedPathsOfDecisionNodes = new HashMap<Decision, Integer>();
    private int decisionCounter = 1;
    private int decisionJoinCounter = 1;
    private final Map<NodeBase, Join> closingJoins = new HashMap<NodeBase, Join>();

    public Graph(Workflow workflow) {
        this.name = workflow.getName();
        this.parameters = workflow.getParameters();
        this.global = workflow.getGlobal();
        this.credentials = workflow.getCredentials();
        List<Node> nodesFromRootsToLeaves = Graph.getNodesFromRootsToLeaves(workflow);
        this.storeNode(this.start);
        this.storeNode(this.end);
        this.convert(nodesFromRootsToLeaves);
    }

    public String getName() {
        return this.name;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public Global getGlobal() {
        return this.global;
    }

    public Start getStart() {
        return this.start;
    }

    public End getEnd() {
        return this.end;
    }

    public NodeBase getNodeByName(String name) {
        return this.nodesByName.get(name);
    }

    public Collection<NodeBase> getNodes() {
        return this.nodesByName.values();
    }

    private void convert(List<Node> nodesInTopologicalOrder) {
        HashMap<Node, NodeBase> nodeToNodeBase = new HashMap<Node, NodeBase>();
        for (Node originalNode : nodesInTopologicalOrder) {
            ExplicitNode convertedNode = new ExplicitNode(originalNode.getName(), originalNode);
            nodeToNodeBase.put(originalNode, convertedNode);
            this.storeNode(convertedNode);
            this.checkAndInsertDecisionNode(originalNode, convertedNode);
            List<DagNodeWithCondition> mappedParentsWithConditions = this.findMappedParents(originalNode, nodeToNodeBase);
            this.handleNodeWithParents(convertedNode, mappedParentsWithConditions);
        }
        List<DagNodeWithCondition> finalNodes = this.findFinalNodes();
        this.handleNodeWithParents(this.end, finalNodes);
    }

    private void checkAndInsertDecisionNode(Node originalNode, ExplicitNode convertedNode) {
        if (!originalNode.getChildrenWithConditions().isEmpty()) {
            Decision decision = this.newDecision();
            decision.addParent(convertedNode);
            this.originalParentToCorrespondingDecision.put(convertedNode, decision);
        }
    }

    private List<DagNodeWithCondition> findMappedParents(Node originalNode, Map<Node, NodeBase> nodeToNodeBase) {
        ArrayList<DagNodeWithCondition> mappedParentsWithConditions = new ArrayList<DagNodeWithCondition>();
        for (Node.NodeWithCondition parentNodeWithCondition : originalNode.getParentsWithConditions()) {
            NodeBase mappedParentNode = nodeToNodeBase.get(parentNodeWithCondition.getNode());
            Condition condition = parentNodeWithCondition.getCondition();
            DagNodeWithCondition parentNodeBaseWithCondition = new DagNodeWithCondition(mappedParentNode, condition);
            mappedParentsWithConditions.add(parentNodeBaseWithCondition);
        }
        for (Node parent : originalNode.getParentsWithoutConditions()) {
            mappedParentsWithConditions.add(new DagNodeWithCondition(nodeToNodeBase.get(parent), null));
        }
        return mappedParentsWithConditions;
    }

    private List<DagNodeWithCondition> findFinalNodes() {
        ArrayList<DagNodeWithCondition> finalNodes = new ArrayList<DagNodeWithCondition>();
        for (NodeBase maybeFinalNode : this.nodesByName.values()) {
            boolean isNotEnd;
            boolean hasNoChildren = maybeFinalNode.getChildren().isEmpty();
            boolean bl = isNotEnd = maybeFinalNode != this.end;
            if (!hasNoChildren || !isNotEnd) continue;
            finalNodes.add(new DagNodeWithCondition(maybeFinalNode, null));
        }
        return finalNodes;
    }

    private void storeNode(NodeBase node) {
        String name = node.getName();
        boolean isPresent = this.nodesByName.containsKey(name);
        if (isPresent) {
            String errorMessage = String.format("Duplicate name '%s' found in graph '%s'", node.getName(), this.getName());
            throw new IllegalArgumentException(errorMessage);
        }
        this.nodesByName.put(node.getName(), node);
    }

    private NodeBase getNewParent(NodeBase originalParent) {
        NodeBase newParent = originalParent;
        if (this.originalParentToCorrespondingDecision.containsKey(newParent)) {
            newParent = this.originalParentToCorrespondingDecision.get(newParent);
        }
        newParent = this.getNearestNonClosedDescendant(newParent);
        return newParent;
    }

    private void handleNodeWithParents(NodeBase node, List<DagNodeWithCondition> parentsWithConditions) {
        ArrayList<DagNodeWithCondition> newParentsWithConditions = new ArrayList<DagNodeWithCondition>();
        for (DagNodeWithCondition parentWithCondition : parentsWithConditions) {
            NodeBase parent = parentWithCondition.getNode();
            Condition condition = parentWithCondition.getCondition();
            NodeBase newParent = this.getNewParent(parent);
            DagNodeWithCondition newParentWithCondition = new DagNodeWithCondition(newParent, condition);
            if (newParentsWithConditions.contains(newParentWithCondition)) continue;
            newParentsWithConditions.add(newParentWithCondition);
        }
        if (newParentsWithConditions.isEmpty()) {
            this.handleSingleParentNode(new DagNodeWithCondition(this.start, null), node);
        } else if (newParentsWithConditions.size() == 1) {
            this.handleSingleParentNode((DagNodeWithCondition)newParentsWithConditions.get(0), node);
        } else {
            this.handleMultiParentNodeWithParents(node, newParentsWithConditions);
        }
    }

    private void handleSingleParentNode(DagNodeWithCondition parentWithCondition, NodeBase node) {
        this.addParentWithForkIfNeeded(node, parentWithCondition);
    }

    private void handleMultiParentNodeWithParents(NodeBase node, List<DagNodeWithCondition> parentsWithConditions) {
        ArrayList<PathInformation> paths = new ArrayList<PathInformation>();
        for (DagNodeWithCondition parentWithCondition : parentsWithConditions) {
            NodeBase parent = parentWithCondition.getNode();
            paths.add(this.getPathInfo(parent));
        }
        BranchingToClose toClose = this.chooseBranchingToClose(paths);
        if (toClose.isRedundantParent()) {
            ArrayList<DagNodeWithCondition> parentsWithoutRedundant = new ArrayList<DagNodeWithCondition>(parentsWithConditions);
            DagNodeWithCondition.removeFromCollection(parentsWithoutRedundant, toClose.getRedundantParent());
            this.handleNodeWithParents(node, parentsWithoutRedundant);
        } else if (toClose.isDecision()) {
            this.insertDecisionJoin(node, parentsWithConditions, toClose);
        } else {
            this.insertJoin(parentsWithConditions, node, toClose);
        }
    }

    private void insertDecisionJoin(NodeBase node, List<DagNodeWithCondition> parentsWithConditions, BranchingToClose branchingToClose) {
        Decision decision = branchingToClose.getDecision();
        DecisionJoin decisionJoin = this.newDecisionJoin(decision, branchingToClose.getPaths().size());
        for (DagNodeWithCondition parentWithCondition : parentsWithConditions) {
            this.addParentWithForkIfNeeded(decisionJoin, parentWithCondition);
        }
        this.addParentWithForkIfNeeded(node, new DagNodeWithCondition(decisionJoin, null));
    }

    private void insertJoin(List<DagNodeWithCondition> parentsWithConditions, NodeBase node, BranchingToClose branchingToClose) {
        if (branchingToClose.isSplittingJoinNeeded()) {
            ArrayList<DagNodeWithCondition> newParentsWithConditions = new ArrayList<DagNodeWithCondition>(parentsWithConditions);
            for (PathInformation path : branchingToClose.getPaths()) {
                DagNodeWithCondition.removeFromCollection(newParentsWithConditions, path.getBottom());
            }
            Join newJoin = this.joinPaths(branchingToClose.getFork(), branchingToClose.getPaths());
            newParentsWithConditions.add(new DagNodeWithCondition(newJoin, null));
            this.handleMultiParentNodeWithParents(node, newParentsWithConditions);
        } else {
            Join newJoin = this.joinPaths(branchingToClose.getFork(), branchingToClose.getPaths());
            if (newJoin != null) {
                this.addParentWithForkIfNeeded(node, new DagNodeWithCondition(newJoin, null));
            } else {
                this.handleNodeWithParents(node, parentsWithConditions);
            }
        }
    }

    private Join joinPaths(Fork fork, List<PathInformation> pathsToJoin) {
        LinkedHashMap<PathInformation, Decision> highestDecisionNodes = new LinkedHashMap<PathInformation, Decision>();
        block0: for (PathInformation path : pathsToJoin) {
            for (int ixNodeOnPath = 0; ixNodeOnPath < path.getNodes().size(); ++ixNodeOnPath) {
                NodeBase nodeOnPath = path.getNodes().get(ixNodeOnPath);
                if (nodeOnPath instanceof Decision) {
                    if (this.isDecisionClosed((Decision)nodeOnPath)) continue;
                    highestDecisionNodes.put(path, (Decision)nodeOnPath);
                    continue;
                }
                if (nodeOnPath == fork) continue block0;
            }
        }
        if (highestDecisionNodes.isEmpty()) {
            return this.joinPathsWithoutDecisions(fork, pathsToJoin);
        }
        return this.joinPathsWithDecisions(fork, pathsToJoin, highestDecisionNodes);
    }

    private Join joinPathsWithoutDecisions(Fork fork, List<PathInformation> pathsToJoin) {
        Join newJoin;
        boolean hasMoreForkedChildren;
        LinkedHashSet<NodeBase> mainBranchNodes = new LinkedHashSet<NodeBase>();
        for (PathInformation pathInformation : pathsToJoin) {
            mainBranchNodes.addAll(pathInformation.getNodes());
        }
        HashSet<NodeBase> closedNodes = new HashSet<NodeBase>();
        ArrayList<NodeBase> sideBranches = new ArrayList<NodeBase>();
        for (PathInformation path : pathsToJoin) {
            NodeBase nodeOnPath;
            for (int ixNodeOnPath = 0; !(ixNodeOnPath >= path.getNodes().size() || (nodeOnPath = path.getNodes().get(ixNodeOnPath)) == fork || nodeOnPath instanceof Decision && this.isDecisionClosed((Decision)nodeOnPath)); ++ixNodeOnPath) {
                sideBranches.addAll(this.cutSideBranches(nodeOnPath, mainBranchNodes));
                closedNodes.add(nodeOnPath);
            }
        }
        boolean bl = hasMoreForkedChildren = pathsToJoin.size() < fork.getChildren().size();
        if (hasMoreForkedChildren) {
            newJoin = this.divideForkAndCloseSubFork(fork, pathsToJoin);
        } else {
            newJoin = this.newJoin(fork);
            for (PathInformation path : pathsToJoin) {
                this.addParentWithForkIfNeeded(newJoin, new DagNodeWithCondition(path.getBottom(), null));
            }
        }
        for (NodeBase sideBranch : sideBranches) {
            this.addParentWithForkIfNeeded(sideBranch, new DagNodeWithCondition(newJoin, null));
        }
        for (NodeBase closedNode : closedNodes) {
            this.markAsClosed(closedNode, newJoin);
        }
        return newJoin;
    }

    private Join joinPathsWithDecisions(Fork fork, List<PathInformation> pathsToJoin, Map<PathInformation, Decision> highestDecisionNodes) {
        HashSet<Decision> decisions = new HashSet<Decision>(highestDecisionNodes.values());
        ArrayList<PathInformation> newPaths = new ArrayList<PathInformation>();
        boolean shouldCloseJoinAndAddOtherDecisionsUnderIt = false;
        for (Decision decision : decisions) {
            NodeBase parentOfDecision = decision.getParent();
            if (parentOfDecision == fork) {
                shouldCloseJoinAndAddOtherDecisionsUnderIt = true;
                break;
            }
            newPaths.add(this.getPathInfo(parentOfDecision));
            this.removeParentWithForkIfNeeded(decision, decision.getParent());
        }
        if (shouldCloseJoinAndAddOtherDecisionsUnderIt) {
            this.closeJoinAndAddOtherDecisionsUnderIt(fork, decisions);
        } else {
            for (PathInformation path : pathsToJoin) {
                if (highestDecisionNodes.containsKey(path)) continue;
                newPaths.add(path);
            }
            Join newJoin = this.joinPaths(fork, newPaths);
            for (Decision decision : decisions) {
                this.addParentWithForkIfNeeded(decision, new DagNodeWithCondition(newJoin, null));
            }
        }
        return null;
    }

    private void closeJoinAndAddOtherDecisionsUnderIt(Fork fork, Set<Decision> decisions) {
        throw new IllegalStateException("Conditional paths originating ultimately from the same parallel branching (fork) do not converge to the same join.");
    }

    private void markAsClosed(NodeBase node, Join join) {
        this.closingJoins.put(node, join);
    }

    private List<NodeBase> cutSideBranches(NodeBase node, Set<NodeBase> mainBranchNodes) {
        boolean isClosedFork;
        ArrayList<NodeBase> sideBranches = new ArrayList<NodeBase>();
        boolean bl = isClosedFork = node instanceof Fork && ((Fork)node).isClosed();
        if (!isClosedFork) {
            for (NodeBase childOfForkOrParent : node.getChildren()) {
                if (mainBranchNodes.contains(childOfForkOrParent)) continue;
                this.removeParentWithForkIfNeeded(childOfForkOrParent, node);
                sideBranches.add(childOfForkOrParent);
            }
        }
        return sideBranches;
    }

    private Join divideForkAndCloseSubFork(Fork correspondingFork, List<PathInformation> paths) {
        Fork newFork = this.newFork();
        for (PathInformation path : paths) {
            int indexOfFork = path.getNodes().indexOf(correspondingFork);
            NodeBase childOfOriginalFork = path.getNodes().get(indexOfFork - 1);
            childOfOriginalFork.removeParent(correspondingFork);
            childOfOriginalFork.addParent(newFork);
        }
        newFork.addParent(correspondingFork);
        Join newJoin = this.newJoin(newFork);
        for (PathInformation path : paths) {
            newJoin.addParent(path.getBottom());
        }
        return newJoin;
    }

    private BranchingToClose chooseBranchingToClose(List<PathInformation> paths) {
        int maxPathLength = 0;
        for (PathInformation pathInformation : paths) {
            if (maxPathLength >= pathInformation.getNodes().size()) continue;
            maxPathLength = pathInformation.getNodes().size();
        }
        for (int ixLevel = 0; ixLevel < maxPathLength; ++ixLevel) {
            BranchingToClose foundAtThisLevel = this.chooseBranchingToClose(paths, ixLevel);
            if (foundAtThisLevel == null) continue;
            return foundAtThisLevel;
        }
        throw new IllegalStateException("We should never reach here.");
    }

    private BranchingToClose chooseBranchingToClose(List<PathInformation> paths, int ixLevel) {
        for (PathInformation path : paths) {
            boolean needToSplitJoin;
            NodeBase branching;
            List<PathInformation> pathsMeetingAtCurrentFork;
            if (ixLevel >= path.getNodes().size() || (pathsMeetingAtCurrentFork = this.getPathsContainingNode(branching = path.getNodes().get(ixLevel), paths)).size() <= 1) continue;
            boolean bl = needToSplitJoin = pathsMeetingAtCurrentFork.size() < paths.size();
            if (branching instanceof Fork) {
                return BranchingToClose.withFork((Fork)branching, pathsMeetingAtCurrentFork, needToSplitJoin);
            }
            if (branching instanceof Decision) {
                return BranchingToClose.withDecision((Decision)branching, pathsMeetingAtCurrentFork, needToSplitJoin);
            }
            return BranchingToClose.withRedundantParent(branching, pathsMeetingAtCurrentFork, needToSplitJoin);
        }
        return null;
    }

    private List<PathInformation> getPathsContainingNode(NodeBase node, List<PathInformation> paths) {
        ArrayList<PathInformation> pathsContainingNode = new ArrayList<PathInformation>();
        for (PathInformation pathInformationMaybeContaining : paths) {
            if (!pathInformationMaybeContaining.getNodes().contains(node)) continue;
            pathsContainingNode.add(pathInformationMaybeContaining);
        }
        return pathsContainingNode;
    }

    private PathInformation getPathInfo(NodeBase node) {
        NodeBase current = node;
        ArrayList<NodeBase> nodes = new ArrayList<NodeBase>();
        while (current != this.start) {
            nodes.add(current);
            if (current instanceof Join) {
                Fork forkPair = (Fork)((Join)current).getBranchingPair();
                current = forkPair;
                continue;
            }
            if (current instanceof DecisionJoin) {
                Decision decisionPair = (Decision)((DecisionJoin)current).getBranchingPair();
                current = decisionPair;
                continue;
            }
            current = this.getSingleParent(current);
        }
        return new PathInformation(nodes);
    }

    private boolean isDecisionClosed(Decision decision) {
        Integer closedPathsOfDecisionNode = this.closedPathsOfDecisionNodes.get(decision);
        return closedPathsOfDecisionNode != null && decision.getChildren().size() == closedPathsOfDecisionNode.intValue();
    }

    private NodeBase getSingleParent(NodeBase node) {
        if (node instanceof End) {
            return ((End)node).getParent();
        }
        if (node instanceof Fork) {
            return ((Fork)node).getParent();
        }
        if (node instanceof Decision) {
            return ((Decision)node).getParent();
        }
        if (node instanceof ExplicitNode) {
            return ((ExplicitNode)node).getParent();
        }
        if (node instanceof Start) {
            throw new IllegalStateException("Start nodes have no parent.");
        }
        if (node instanceof Join) {
            Join join = (Join)node;
            int numberOfParents = join.getParents().size();
            if (numberOfParents != 1) {
                throw new IllegalStateException("The join node called '" + node.getName() + "' has " + numberOfParents + " parents instead of 1.");
            }
            return join.getParents().get(0);
        }
        if (node == null) {
            throw new IllegalArgumentException("Null node found.");
        }
        throw new IllegalArgumentException("Unknown node type.");
    }

    private NodeBase getNearestNonClosedDescendant(NodeBase node) {
        NodeBase current = node;
        while (this.closingJoins.containsKey(current)) {
            current = this.closingJoins.get(current);
        }
        return current;
    }

    private void addParentWithForkIfNeeded(NodeBase node, DagNodeWithCondition parentWithCondition) {
        NodeBase parent = parentWithCondition.getNode();
        Condition condition = parentWithCondition.getCondition();
        if (parent.getChildren().isEmpty() || parent instanceof Fork || parent instanceof Decision) {
            if (condition != null) {
                if (!(parent instanceof Decision)) {
                    throw new IllegalStateException("Trying to add a conditional parent that is not a decision.");
                }
                node.addParentWithCondition((Decision)parent, condition);
            } else {
                node.addParent(parent);
            }
        } else {
            NodeBase child = parent.getChildren().get(0);
            if (child instanceof Fork) {
                node.addParent(child);
            } else if (child instanceof Join) {
                this.addParentWithForkIfNeeded(node, new DagNodeWithCondition(child, null));
            } else {
                Fork newFork = this.newFork();
                child.removeParent(parent);
                child.addParent(newFork);
                node.addParent(newFork);
                newFork.addParent(parent);
            }
        }
    }

    private void removeParentWithForkIfNeeded(NodeBase node, NodeBase parent) {
        boolean isParentForkAndHasOneChild;
        node.removeParent(parent);
        boolean bl = isParentForkAndHasOneChild = parent instanceof Fork && parent.getChildren().size() == 1;
        if (isParentForkAndHasOneChild) {
            NodeBase grandparent = ((Fork)parent).getParent();
            NodeBase child = parent.getChildren().get(0);
            this.removeParentWithForkIfNeeded(parent, grandparent);
            child.removeParent(parent);
            child.addParent(grandparent);
            this.nodesByName.remove(parent.getName());
        }
    }

    private Fork newFork() {
        Fork fork = new Fork("fork" + this.forkCounter);
        this.forkNumbers.put(fork, this.forkCounter);
        ++this.forkCounter;
        this.storeNode(fork);
        return fork;
    }

    private Join newJoin(Fork correspondingFork) {
        Join join = new Join("join" + this.forkNumbers.get(correspondingFork), correspondingFork);
        this.storeNode(join);
        return join;
    }

    private Decision newDecision() {
        Decision decision = new Decision("decision" + this.decisionCounter);
        ++this.decisionCounter;
        this.storeNode(decision);
        return decision;
    }

    private DecisionJoin newDecisionJoin(Decision correspondingDecision, int numberOfPathsClosed) {
        DecisionJoin decisionJoin = new DecisionJoin("decisionJoin" + this.decisionJoinCounter, correspondingDecision);
        Integer numberOfAlreadyClosedChildren = this.closedPathsOfDecisionNodes.get(correspondingDecision);
        int newNumber = numberOfPathsClosed + (numberOfAlreadyClosedChildren == null ? 0 : numberOfAlreadyClosedChildren);
        this.closedPathsOfDecisionNodes.put(correspondingDecision, newNumber);
        ++this.decisionJoinCounter;
        this.storeNode(decisionJoin);
        return decisionJoin;
    }

    private static List<Node> getNodesFromRootsToLeaves(Workflow workflow) {
        ArrayList<Node> nodes = new ArrayList<Node>(workflow.getRoots());
        for (int i = 0; i < nodes.size(); ++i) {
            Node current = (Node)nodes.get(i);
            for (Node child : current.getAllChildren()) {
                List<Node> dependencies = child.getAllParents();
                if (!nodes.containsAll(dependencies) || nodes.contains(child)) continue;
                nodes.add(child);
            }
        }
        return nodes;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    private static class BranchingToClose {
        private final Fork fork;
        private final Decision decision;
        private final NodeBase redundantParent;
        private final ImmutableList<PathInformation> paths;
        private final boolean needToSplitJoin;

        static BranchingToClose withFork(Fork fork, List<PathInformation> paths, boolean needToSplitJoin) {
            return new BranchingToClose(fork, null, null, paths, needToSplitJoin);
        }

        static BranchingToClose withDecision(Decision decision, List<PathInformation> paths, boolean needToSplitJoin) {
            return new BranchingToClose(null, decision, null, paths, needToSplitJoin);
        }

        static BranchingToClose withRedundantParent(NodeBase redundantParent, List<PathInformation> paths, boolean needToSplitJoin) {
            return new BranchingToClose(null, null, redundantParent, paths, needToSplitJoin);
        }

        private BranchingToClose(Fork fork, Decision decision, NodeBase redundantParent, List<PathInformation> paths, boolean needToSplitJoin) {
            this.checkOnlyOneIsNotNull(fork, decision, redundantParent);
            this.fork = fork;
            this.decision = decision;
            this.redundantParent = redundantParent;
            this.paths = ImmutableList.copyOf(paths);
            this.needToSplitJoin = needToSplitJoin;
        }

        public Fork getFork() {
            return this.fork;
        }

        public Decision getDecision() {
            return this.decision;
        }

        NodeBase getRedundantParent() {
            return this.redundantParent;
        }

        List<PathInformation> getPaths() {
            return this.paths;
        }

        boolean isDecision() {
            return this.decision != null;
        }

        boolean isRedundantParent() {
            return this.redundantParent != null;
        }

        boolean isSplittingJoinNeeded() {
            return this.needToSplitJoin;
        }

        private void checkOnlyOneIsNotNull(Fork fork, Decision decision, NodeBase redundantParent) {
            int counter = 0;
            if (fork != null) {
                ++counter;
            }
            if (decision != null) {
                ++counter;
            }
            if (redundantParent != null) {
                ++counter;
            }
            Preconditions.checkArgument((counter == 1 ? 1 : 0) != 0, (Object)"Exactly one of 'fork' and 'redundantParent' must be non-null.");
        }
    }

    private static class PathInformation {
        private final ImmutableList<NodeBase> nodes;

        PathInformation(List<NodeBase> nodes) {
            this.nodes = new ImmutableList.Builder().addAll(nodes).build();
        }

        NodeBase getBottom() {
            return (NodeBase)this.nodes.get(0);
        }

        public List<NodeBase> getNodes() {
            return this.nodes;
        }
    }
}

