/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.fluentjob.api.dag;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import org.apache.oozie.fluentjob.api.Condition;
import org.apache.oozie.fluentjob.api.action.Node;
import org.apache.oozie.fluentjob.api.dag.Decision;
import org.apache.oozie.fluentjob.api.dag.NodeBase;

public class ExplicitNode
extends NodeBase {
    private NodeBase parent;
    private NodeBase child;
    private final Node realNode;

    public ExplicitNode(String name, Node realNode) {
        super(name);
        this.realNode = realNode;
    }

    public Node getRealNode() {
        return this.realNode;
    }

    public NodeBase getParent() {
        return this.parent;
    }

    public NodeBase getChild() {
        return this.child;
    }

    @Override
    public void addParent(NodeBase parent) {
        Preconditions.checkState((this.parent == null ? 1 : 0) != 0, (Object)"An explicit node cannot have multiple parents.");
        this.parent = parent;
        parent.addChild(this);
    }

    @Override
    public void addParentWithCondition(Decision parent, Condition condition) {
        Preconditions.checkState((this.parent == null ? 1 : 0) != 0, (Object)"An explicit node cannot have multiple parents.");
        this.parent = parent;
        parent.addChildWithCondition(this, condition);
    }

    @Override
    public void addParentDefaultConditional(Decision parent) {
        Preconditions.checkState((this.parent == null ? 1 : 0) != 0, (Object)"An explicit node cannot have multiple parents.");
        this.parent = parent;
        parent.addDefaultChild(this);
    }

    @Override
    public void removeParent(NodeBase parent) {
        Preconditions.checkArgument((this.parent == parent ? 1 : 0) != 0, (Object)"Trying to remove a nonexistent parent.");
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
        this.parent = null;
    }

    @Override
    public void clearParents() {
        this.removeParent(this.parent);
    }

    @Override
    public List<NodeBase> getChildren() {
        if (this.child == null) {
            return Arrays.asList(new NodeBase[0]);
        }
        return Arrays.asList(this.child);
    }

    @Override
    protected void addChild(NodeBase child) {
        Preconditions.checkState((this.child == null ? 1 : 0) != 0, (Object)"Normal nodes cannot have multiple children.");
        this.child = child;
    }

    @Override
    protected void removeChild(NodeBase child) {
        Preconditions.checkArgument((this.child == child ? 1 : 0) != 0, (Object)"Trying to remove a nonexistent child.");
        this.child = null;
    }
}

