/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.fluentjob.api.action;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.oozie.fluentjob.api.Condition;
import org.apache.oozie.fluentjob.api.ModifyOnce;
import org.apache.oozie.fluentjob.api.action.ErrorHandler;
import org.apache.oozie.fluentjob.api.action.Node;
import org.apache.oozie.fluentjob.api.workflow.Credential;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class NodeBuilderBaseImpl<B extends NodeBuilderBaseImpl<B>> {
    private final ModifyOnce<String> name;
    private final List<Credential> credentials;
    private final ModifyOnce<Integer> retryMax;
    private final ModifyOnce<Integer> retryInterval;
    private final ModifyOnce<String> retryPolicy;
    private final List<Node> parents;
    private final List<Node.NodeWithCondition> parentsWithConditions;
    private final ModifyOnce<ErrorHandler> errorHandler;

    NodeBuilderBaseImpl() {
        this(null);
    }

    NodeBuilderBaseImpl(Node node) {
        if (node == null) {
            this.name = new ModifyOnce();
            this.credentials = new ArrayList<Credential>();
            this.retryMax = new ModifyOnce();
            this.retryInterval = new ModifyOnce();
            this.retryPolicy = new ModifyOnce();
            this.parents = new ArrayList<Node>();
            this.parentsWithConditions = new ArrayList<Node.NodeWithCondition>();
            this.errorHandler = new ModifyOnce();
        } else {
            this.name = new ModifyOnce();
            this.credentials = new ArrayList<Credential>(node.getCredentials());
            this.retryMax = new ModifyOnce<Integer>(node.getRetryMax());
            this.retryInterval = new ModifyOnce<Integer>(node.getRetryInterval());
            this.retryPolicy = new ModifyOnce<String>(node.getRetryPolicy());
            this.parents = new ArrayList<Node>(node.getParentsWithoutConditions());
            this.parentsWithConditions = new ArrayList<Node.NodeWithCondition>(node.getParentsWithConditions());
            this.errorHandler = new ModifyOnce<ErrorHandler>(node.getErrorHandler());
        }
    }

    public B withErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler.set(errorHandler);
        return this.ensureRuntimeSelfReference();
    }

    public B withoutErrorHandler() {
        this.errorHandler.set(null);
        return this.ensureRuntimeSelfReference();
    }

    public B withName(String name) {
        this.name.set(name);
        return this.ensureRuntimeSelfReference();
    }

    public B withCredential(Credential credential) {
        this.credentials.add(credential);
        return this.ensureRuntimeSelfReference();
    }

    public B withoutCredential(Credential credential) {
        this.credentials.remove(credential);
        return this.ensureRuntimeSelfReference();
    }

    public B clearCredentials() {
        this.credentials.clear();
        return this.ensureRuntimeSelfReference();
    }

    public B withRetryMax(Integer retryMax) {
        this.retryMax.set(retryMax);
        return this.ensureRuntimeSelfReference();
    }

    public B withRetryInterval(Integer retryInterval) {
        this.retryInterval.set(retryInterval);
        return this.ensureRuntimeSelfReference();
    }

    public B withRetryPolicy(String retryPolicy) {
        this.retryPolicy.set(retryPolicy);
        return this.ensureRuntimeSelfReference();
    }

    public B withParent(Node parent) {
        this.checkNoDuplicateParent(parent);
        this.parents.add(parent);
        return this.ensureRuntimeSelfReference();
    }

    public B withParentWithCondition(Node parent, String condition) {
        this.checkNoDuplicateParent(parent);
        this.parentsWithConditions.add(new Node.NodeWithCondition(parent, Condition.actualCondition(condition)));
        return this.ensureRuntimeSelfReference();
    }

    public B withParentDefaultConditional(Node parent) {
        this.checkNoDuplicateParent(parent);
        this.parentsWithConditions.add(new Node.NodeWithCondition(parent, Condition.defaultCondition()));
        return this.ensureRuntimeSelfReference();
    }

    public B withoutParent(Node parent) {
        if (this.parents.contains(parent)) {
            this.parents.remove(parent);
        } else {
            int index = this.indexOfParentAmongParentsWithConditions(parent);
            if (index >= 0) {
                this.parentsWithConditions.remove(index);
            }
        }
        return this.ensureRuntimeSelfReference();
    }

    public B clearParents() {
        this.parents.clear();
        this.parentsWithConditions.clear();
        return this.ensureRuntimeSelfReference();
    }

    final B ensureRuntimeSelfReference() {
        B runtimeSelfReference = this.getRuntimeSelfReference();
        Preconditions.checkState((runtimeSelfReference == this ? 1 : 0) != 0, (Object)"The builder type B doesn't extend NodeBuilderBaseImpl<B>.");
        return runtimeSelfReference;
    }

    private void checkNoDuplicateParent(Node parent) {
        boolean parentsContains = this.parents.contains(parent);
        boolean parentsWithConditionsContains = this.indexOfParentAmongParentsWithConditions(parent) != -1;
        Preconditions.checkArgument((!parentsContains && !parentsWithConditionsContains ? 1 : 0) != 0, (Object)"Trying to add a parent that is already a parent of this node.");
    }

    private int indexOfParentAmongParentsWithConditions(Node parent) {
        for (int i = 0; i < this.parentsWithConditions.size(); ++i) {
            if (parent != this.parentsWithConditions.get(i).getNode()) continue;
            return i;
        }
        return -1;
    }

    protected void addAsChildToAllParents(Node child) {
        List<Node.NodeWithCondition> parentsWithConditionsList;
        List<Node> parentsList = child.getParentsWithoutConditions();
        if (parentsList != null) {
            for (Node parent : parentsList) {
                parent.addChild(child);
            }
        }
        if ((parentsWithConditionsList = child.getParentsWithConditions()) != null) {
            for (Node.NodeWithCondition parentWithCondition : parentsWithConditionsList) {
                Node parent = parentWithCondition.getNode();
                Condition condition = parentWithCondition.getCondition();
                if (condition.isDefault()) {
                    parent.addChildAsDefaultConditional(child);
                    continue;
                }
                parent.addChildWithCondition(child, condition.getCondition());
            }
        }
    }

    Node.ConstructionData getConstructionData() {
        String nameStr = this.ensureName();
        ImmutableList parentsList = new ImmutableList.Builder().addAll(this.parents).build();
        ImmutableList parentsWithConditionsList = new ImmutableList.Builder().addAll(this.parentsWithConditions).build();
        return new Node.ConstructionData(new Node.Attributes(nameStr, this.credentials, this.retryMax.get(), this.retryInterval.get(), this.retryPolicy.get()), (ImmutableList<Node>)parentsList, (ImmutableList<Node.NodeWithCondition>)parentsWithConditionsList, this.errorHandler.get());
    }

    private String ensureName() {
        if (Strings.isNullOrEmpty((String)this.name.get())) {
            String type = this.getRuntimeSelfReference().getClass().getSimpleName().toLowerCase(Locale.getDefault()).replaceAll("actionbuilder", "");
            int randomSuffix = new SecureRandom().nextInt(1000000000);
            this.name.set(String.format("%s-%d", type, randomSuffix));
        }
        return this.name.get();
    }

    protected abstract B getRuntimeSelfReference();
}

