/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.fluentjob.api.action;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.oozie.fluentjob.api.Condition;
import org.apache.oozie.fluentjob.api.action.ErrorHandler;
import org.apache.oozie.fluentjob.api.workflow.Credential;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class Node {
    private final Attributes attributes;
    private final ImmutableList<Node> parentsWithoutConditions;
    private final ImmutableList<NodeWithCondition> parentsWithConditions;
    private final ErrorHandler errorHandler;
    private final List<Node> childrenWithoutConditions;
    private final List<NodeWithCondition> childrenWithConditions;
    private Node defaultConditionalChild;

    Node(ConstructionData constructionData) {
        this(constructionData.attributes, (ImmutableList<Node>)constructionData.parents, (ImmutableList<NodeWithCondition>)constructionData.parentsWithConditions, constructionData.errorHandler);
    }

    Node(Attributes attributes, ImmutableList<Node> parentsWithoutConditions, ImmutableList<NodeWithCondition> parentsWithConditions, ErrorHandler errorHandler) {
        this.attributes = attributes;
        this.parentsWithoutConditions = parentsWithoutConditions;
        this.parentsWithConditions = parentsWithConditions;
        this.errorHandler = errorHandler;
        this.childrenWithoutConditions = new ArrayList<Node>();
        this.childrenWithConditions = new ArrayList<NodeWithCondition>();
        this.defaultConditionalChild = null;
    }

    public String getName() {
        return this.attributes.name;
    }

    public List<Credential> getCredentials() {
        return this.attributes.credentials;
    }

    public Integer getRetryMax() {
        return this.attributes.retryMax;
    }

    public Integer getRetryInterval() {
        return this.attributes.retryInterval;
    }

    public String getRetryPolicy() {
        return this.attributes.retryPolicy;
    }

    public List<Node> getAllParents() {
        ArrayList<Node> allParents = new ArrayList<Node>((Collection<Node>)this.parentsWithoutConditions);
        for (NodeWithCondition parentWithCondition : this.parentsWithConditions) {
            allParents.add(parentWithCondition.getNode());
        }
        return Collections.unmodifiableList(allParents);
    }

    public List<Node> getParentsWithoutConditions() {
        return this.parentsWithoutConditions;
    }

    public List<NodeWithCondition> getParentsWithConditions() {
        return this.parentsWithConditions;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    void addChild(Node child) {
        Preconditions.checkState((boolean)this.childrenWithConditions.isEmpty(), (Object)"Trying to add a child without condition to a node that already has at least one child with a condition.");
        this.childrenWithoutConditions.add(child);
    }

    void addChildWithCondition(Node child, String condition) {
        Preconditions.checkState((boolean)this.childrenWithoutConditions.isEmpty(), (Object)"Trying to add a child with condition to a node that already has at least one child without a condition.");
        this.childrenWithConditions.add(new NodeWithCondition(child, Condition.actualCondition(condition)));
    }

    void addChildAsDefaultConditional(Node child) {
        Preconditions.checkState((boolean)this.childrenWithoutConditions.isEmpty(), (Object)"Trying to add a default conditional child to a node that already has at least one child without a condition.");
        Preconditions.checkState((this.defaultConditionalChild == null ? 1 : 0) != 0, (Object)"Trying to add a default conditional child to a node that already has one.");
        this.defaultConditionalChild = child;
    }

    public List<Node> getAllChildren() {
        ArrayList<Node> allChildren = new ArrayList<Node>(this.childrenWithoutConditions);
        for (NodeWithCondition nodeWithCondition : this.getChildrenWithConditions()) {
            allChildren.add(nodeWithCondition.getNode());
        }
        return Collections.unmodifiableList(allChildren);
    }

    public List<Node> getChildrenWithoutConditions() {
        return Collections.unmodifiableList(this.childrenWithoutConditions);
    }

    public List<NodeWithCondition> getChildrenWithConditions() {
        if (this.defaultConditionalChild == null) {
            return Collections.unmodifiableList(this.childrenWithConditions);
        }
        ArrayList<NodeWithCondition> results = new ArrayList<NodeWithCondition>(this.childrenWithConditions);
        results.add(new NodeWithCondition(this.defaultConditionalChild, Condition.defaultCondition()));
        return Collections.unmodifiableList(results);
    }

    public Node getDefaultConditionalChild() {
        return this.defaultConditionalChild;
    }

    static class Attributes {
        private final String name;
        private final ImmutableList<Credential> credentials;
        private final Integer retryMax;
        private final Integer retryInterval;
        private final String retryPolicy;

        Attributes(String name) {
            this(name, (List<Credential>)ImmutableList.of(), null, null, null);
        }

        Attributes(String name, List<Credential> credentials, Integer retryMax, Integer retryInterval, String retryPolicy) {
            this.name = name;
            this.credentials = ImmutableList.copyOf(credentials);
            this.retryMax = retryMax;
            this.retryInterval = retryInterval;
            this.retryPolicy = retryPolicy;
        }
    }

    static class ConstructionData {
        private final Attributes attributes;
        private final ImmutableList<Node> parents;
        private final ImmutableList<NodeWithCondition> parentsWithConditions;
        private final ErrorHandler errorHandler;

        ConstructionData(Attributes attributes, ImmutableList<Node> parents, ImmutableList<NodeWithCondition> parentsWithConditions, ErrorHandler errorHandler) {
            this.attributes = attributes;
            this.parents = parents;
            this.parentsWithConditions = parentsWithConditions;
            this.errorHandler = errorHandler;
        }
    }

    public static class NodeWithCondition {
        private final Node node;
        private final Condition condition;

        public NodeWithCondition(Node node, Condition condition) {
            this.node = node;
            this.condition = condition;
        }

        public Node getNode() {
            return this.node;
        }

        public Condition getCondition() {
            return this.condition;
        }
    }
}

