/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.fluentjob.api.action;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.oozie.fluentjob.api.ModifyOnce;
import org.apache.oozie.fluentjob.api.action.ActionAttributesBuilder;
import org.apache.oozie.fluentjob.api.action.Builder;
import org.apache.oozie.fluentjob.api.action.HiveAction;
import org.apache.oozie.fluentjob.api.action.Launcher;
import org.apache.oozie.fluentjob.api.action.Node;
import org.apache.oozie.fluentjob.api.action.NodeBuilderBaseImpl;
import org.apache.oozie.fluentjob.api.action.PigActionBuilder;
import org.apache.oozie.fluentjob.api.action.Prepare;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class HiveActionBuilder
extends NodeBuilderBaseImpl<HiveActionBuilder>
implements Builder<HiveAction> {
    private final PigActionBuilder delegate;
    protected final ModifyOnce<String> query;

    public static HiveActionBuilder create() {
        ActionAttributesBuilder builder = ActionAttributesBuilder.create();
        ModifyOnce<String> script = new ModifyOnce<String>();
        ModifyOnce<String> query = new ModifyOnce<String>();
        ArrayList<String> params = new ArrayList<String>();
        return new HiveActionBuilder(null, builder, script, query, params);
    }

    public static HiveActionBuilder createFromExistingAction(HiveAction action) {
        ActionAttributesBuilder builder = ActionAttributesBuilder.createFromExisting(action.getAttributes());
        ModifyOnce<String> script = new ModifyOnce<String>(action.getScript());
        ModifyOnce<String> query = new ModifyOnce<String>(action.getQuery());
        ArrayList<String> params = new ArrayList<String>(action.getParams());
        return new HiveActionBuilder(action, builder, script, query, params);
    }

    public static HiveActionBuilder createFromExistingAction(Node action) {
        ActionAttributesBuilder builder = ActionAttributesBuilder.createFromAction(action);
        ModifyOnce<String> script = new ModifyOnce<String>();
        ModifyOnce<String> query = new ModifyOnce<String>();
        ArrayList<String> params = new ArrayList<String>();
        return new HiveActionBuilder(action, builder, script, query, params);
    }

    HiveActionBuilder(Node action, ActionAttributesBuilder attributesBuilder, ModifyOnce<String> script, ModifyOnce<String> query, List<String> params) {
        super(action);
        this.delegate = new PigActionBuilder(action, attributesBuilder, script, params);
        this.query = query;
    }

    public HiveActionBuilder withResourceManager(String resourceManager) {
        this.delegate.withResourceManager(resourceManager);
        return this;
    }

    public HiveActionBuilder withNameNode(String nameNode) {
        this.delegate.withNameNode(nameNode);
        return this;
    }

    public HiveActionBuilder withPrepare(Prepare prepare) {
        this.delegate.withPrepare(prepare);
        return this;
    }

    public HiveActionBuilder withLauncher(Launcher launcher) {
        this.delegate.withLauncher(launcher);
        return this;
    }

    public HiveActionBuilder withJobXml(String jobXml) {
        this.delegate.withJobXml(jobXml);
        return this;
    }

    public HiveActionBuilder withoutJobXml(String jobXml) {
        this.delegate.withoutJobXml(jobXml);
        return this;
    }

    public HiveActionBuilder clearJobXmls() {
        this.delegate.clearJobXmls();
        return this;
    }

    public HiveActionBuilder withConfigProperty(String key, String value) {
        this.delegate.withConfigProperty(key, value);
        return this;
    }

    public HiveActionBuilder withScript(String script) {
        this.delegate.withScript(script);
        return this;
    }

    public HiveActionBuilder withQuery(String query) {
        this.query.set(query);
        return this;
    }

    public HiveActionBuilder withParam(String param) {
        this.delegate.withParam(param);
        return this;
    }

    public HiveActionBuilder withoutParam(String param) {
        this.delegate.withoutParam(param);
        return this;
    }

    public HiveActionBuilder clearParams() {
        this.delegate.clearParams();
        return this;
    }

    public HiveActionBuilder withArg(String arg) {
        this.delegate.withArg(arg);
        return this;
    }

    public HiveActionBuilder withoutArg(String arg) {
        this.delegate.withoutArg(arg);
        return this;
    }

    public HiveActionBuilder clearArgs() {
        this.delegate.clearArgs();
        return this;
    }

    public HiveActionBuilder withFile(String file) {
        this.delegate.withFile(file);
        return this;
    }

    public HiveActionBuilder withoutFile(String file) {
        this.delegate.withoutFile(file);
        return this;
    }

    public HiveActionBuilder clearFiles() {
        this.delegate.clearFiles();
        return this;
    }

    public HiveActionBuilder withArchive(String archive) {
        this.delegate.withArchive(archive);
        return this;
    }

    public HiveActionBuilder withoutArchive(String archive) {
        this.delegate.withoutArchive(archive);
        return this;
    }

    public HiveActionBuilder clearArchives() {
        this.delegate.clearArchives();
        return this;
    }

    ActionAttributesBuilder getAttributesBuilder() {
        return this.delegate.attributesBuilder;
    }

    ModifyOnce<String> getScript() {
        return this.delegate.script;
    }

    List<String> getParams() {
        return this.delegate.params;
    }

    @Override
    public HiveAction build() {
        Node.ConstructionData constructionData = this.getConstructionData();
        HiveAction instance = new HiveAction(constructionData, this.getAttributesBuilder().build(), this.getScript().get(), this.query.get(), (ImmutableList<String>)ImmutableList.copyOf(this.getParams()));
        this.addAsChildToAllParents(instance);
        return instance;
    }

    @Override
    protected HiveActionBuilder getRuntimeSelfReference() {
        return this;
    }
}

