/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.fluentjob.api.action;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.oozie.fluentjob.api.ModifyOnce;
import org.apache.oozie.fluentjob.api.action.ActionAttributesBuilder;
import org.apache.oozie.fluentjob.api.action.Builder;
import org.apache.oozie.fluentjob.api.action.GitAction;
import org.apache.oozie.fluentjob.api.action.Node;
import org.apache.oozie.fluentjob.api.action.NodeBuilderBaseImpl;
import org.apache.oozie.fluentjob.api.action.Prepare;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class GitActionBuilder
extends NodeBuilderBaseImpl<GitActionBuilder>
implements Builder<GitAction> {
    private final ActionAttributesBuilder attributesBuilder;
    private final ModifyOnce<String> gitUri;
    private final ModifyOnce<String> branch;
    private final ModifyOnce<String> keyPath;
    private final ModifyOnce<String> destinationUri;

    public static GitActionBuilder create() {
        ActionAttributesBuilder builder = ActionAttributesBuilder.create();
        ModifyOnce<String> gitUri = new ModifyOnce<String>();
        ModifyOnce<String> branch = new ModifyOnce<String>();
        ModifyOnce<String> keyPath = new ModifyOnce<String>();
        ModifyOnce<String> destinationUri = new ModifyOnce<String>();
        return new GitActionBuilder(null, builder, gitUri, branch, keyPath, destinationUri);
    }

    public static GitActionBuilder createFromExistingAction(GitAction action) {
        ActionAttributesBuilder builder = ActionAttributesBuilder.createFromExisting(action.getAttributes());
        ModifyOnce<String> gitUri = new ModifyOnce<String>(action.getGitUri());
        ModifyOnce<String> branch = new ModifyOnce<String>(action.getBranch());
        ModifyOnce<String> keyPath = new ModifyOnce<String>(action.getKeyPath());
        ModifyOnce<String> destinationUri = new ModifyOnce<String>(action.getDestinationUri());
        return new GitActionBuilder(action, builder, gitUri, branch, keyPath, destinationUri);
    }

    public static GitActionBuilder createFromExistingAction(Node action) {
        ActionAttributesBuilder builder = ActionAttributesBuilder.createFromAction(action);
        ModifyOnce<String> gitUri = new ModifyOnce<String>();
        ModifyOnce<String> branch = new ModifyOnce<String>();
        ModifyOnce<String> keyPath = new ModifyOnce<String>();
        ModifyOnce<String> destinationUri = new ModifyOnce<String>();
        return new GitActionBuilder(action, builder, gitUri, branch, keyPath, destinationUri);
    }

    private GitActionBuilder(Node action, ActionAttributesBuilder attributesBuilder, ModifyOnce<String> gitUri, ModifyOnce<String> branch, ModifyOnce<String> keyPath, ModifyOnce<String> destinationUri) {
        super(action);
        this.attributesBuilder = attributesBuilder;
        this.gitUri = gitUri;
        this.branch = branch;
        this.keyPath = keyPath;
        this.destinationUri = destinationUri;
    }

    public GitActionBuilder withResourceManager(String resourceManager) {
        this.attributesBuilder.withResourceManager(resourceManager);
        return this;
    }

    public GitActionBuilder withNameNode(String nameNode) {
        this.attributesBuilder.withNameNode(nameNode);
        return this;
    }

    public GitActionBuilder withPrepare(Prepare prepare) {
        this.attributesBuilder.withPrepare(prepare);
        return this;
    }

    public GitActionBuilder withConfigProperty(String key, String value) {
        this.attributesBuilder.withConfigProperty(key, value);
        return this;
    }

    public GitActionBuilder withGitUri(String gitUri) {
        this.gitUri.set(gitUri);
        return this;
    }

    public GitActionBuilder withBranch(String branch) {
        this.branch.set(branch);
        return this;
    }

    public GitActionBuilder withKeyPath(String keyPath) {
        this.keyPath.set(keyPath);
        return this;
    }

    public GitActionBuilder withDestinationUri(String destinationUri) {
        this.destinationUri.set(destinationUri);
        return this;
    }

    @Override
    public GitAction build() {
        Node.ConstructionData constructionData = this.getConstructionData();
        GitAction instance = new GitAction(constructionData, this.attributesBuilder.build(), this.gitUri.get(), this.branch.get(), this.keyPath.get(), this.destinationUri.get());
        this.addAsChildToAllParents(instance);
        return instance;
    }

    @Override
    protected GitActionBuilder getRuntimeSelfReference() {
        return this;
    }
}

