#import "DashRootTableViewController.h"
#import "DashGummySpeechRecognizerViewController.h"
#import "DashGummySpeechTranscriberViewController.h"
#import "DashParaformerSpeechTranscriberViewController.h"
#import "DashParaformerFileTranscriberViewController.h"
#import "DashFunAsrSpeechTranscriberViewController.h"
#import "DashFunAsrFileTranscriberViewController.h"
#import "DashSambertTTSViewController.h"
#import "DashCosyVoiceStreamInputTTSViewController.h"
#import "HWOptionButton.h"
#import "NuiSdkUtils.h"

@interface DashRootTableViewController () {
    IBOutlet UIButton *ServerButtion;
}

@property(nonatomic,strong) HWOptionButton *urlOption;
@property(nonatomic,strong) UITextField *apikeyTextField;

@property(nonatomic,strong) NuiSdkUtils *utils;

@property(nonatomic,strong) NSString *url;
@property(nonatomic,strong) NSString *apikey;
@property(nonatomic,strong) NSString *accessFilePath;
@end

@implementation DashRootTableViewController
#define SCREEN_WIDTH_BASE 375
#define SCREEN_HEIGHT_BASE 667

- (void)setupTextField:(int)index {
    CGSize global_size = [UIScreen mainScreen].bounds.size;
    CGFloat label_width = global_size.width;
    CGFloat label_height = global_size.height/SCREEN_HEIGHT_BASE * 40;
    CGFloat label_x = 0;
    CGFloat label_y = global_size.height/SCREEN_HEIGHT_BASE * 40 * index;
    
    CGRect textfield_rect = CGRectMake(label_x, label_y, label_width, label_height);
    _apikeyTextField = [[UITextField alloc] initWithFrame:textfield_rect];
    _apikeyTextField.borderStyle = UITextBorderStyleRoundedRect;
    _apikeyTextField.font = [UIFont fontWithName:@"Arial" size:15];
    _apikeyTextField.textColor = [UIColor blackColor];
    _apikeyTextField.backgroundColor = [UIColor lightGrayColor];
    _apikeyTextField.userInteractionEnabled = YES;
    if (_apikey && _apikey.length > 0) {
        NSLog(@"Now apikey is %@", _apikey);
        _apikeyTextField.text = _apikey;
    }
    
    [self.view addSubview:_apikeyTextField];
}

- (void)setupOptionButton:(int)index
                optionBtn:(HWOptionButton *)optionBtn
                    array:(NSArray *)array{
    CGSize global_size = [UIScreen mainScreen].bounds.size;
    CGFloat label_width = global_size.width;
    CGFloat label_height = global_size.height/SCREEN_HEIGHT_BASE * 40;
    CGFloat label_x = 0;
    CGFloat label_y = global_size.height/SCREEN_HEIGHT_BASE * 40 * index;
    
    optionBtn = [[HWOptionButton alloc] initWithFrame:CGRectMake(label_x, label_y, label_width, label_height)];
    optionBtn.backgroundColor = [UIColor whiteColor];
    optionBtn.array = array;
    optionBtn.selectIndex = 0;
    optionBtn.showSearchBar = YES;
    [self.view addSubview:optionBtn];
}

- (void) setupLabel:(int)index
              title:(NSString*)title {
    CGSize global_size = [UIScreen mainScreen].bounds.size;
    CGFloat label_width = global_size.width;
    CGFloat label_height = global_size.height/SCREEN_HEIGHT_BASE * 40;
    CGFloat label_x = 0;
    CGFloat label_y = global_size.height/SCREEN_HEIGHT_BASE * 40 * index;
    
    CGRect label_rect = CGRectMake(label_x, label_y, label_width, label_height);
    UILabel* label = [[UILabel alloc] initWithFrame:label_rect];
    label.text = title;
    label.numberOfLines = 0;
    label.lineBreakMode = NSLineBreakByWordWrapping;
    label.textColor = [UIColor whiteColor];
//    label.backgroundColor = [UIColor whiteColor];
    label.font = [UIFont boldSystemFontOfSize:18];
    [self.view addSubview:label];
}

-(void) setupButton:(UIButton*)button
                    index:(int)index
                    title:(NSString*)title
                    action:(SEL)action {
    CGSize global_size = [UIScreen mainScreen].bounds.size;
    CGFloat button_width = global_size.width;
    CGFloat button_height = global_size.height/SCREEN_HEIGHT_BASE * 40;
    
    
    CGFloat button_x = 0;
    CGFloat button_y = global_size.height/SCREEN_HEIGHT_BASE * 40 * index;

    button = [UIButton buttonWithType:UIButtonTypeCustom];
    button.frame = CGRectMake(button_x, button_y, button_width, button_height);
    UIImage *button_image = [UIImage imageNamed:@"button_start"];
    [button setBackgroundImage:button_image forState:UIControlStateNormal];
    [button setTitle:title forState:UIControlStateNormal];
    [button setTitleColor:UIColor.blackColor forState:UIControlStateNormal];
    button.titleLabel.font = [UIFont systemFontOfSize:18];
    [button addTarget:self action:action forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:button];
}

-(void) parseAccessFromFile:(NSString*)debugpath
                   filename:(NSString*)filename {
    _accessFilePath = [NSString stringWithFormat:@"%@/%@", debugpath, filename];
    
    NSError *error = nil;
    NSArray *files = [[NSFileManager defaultManager] contentsOfDirectoryAtPath:debugpath error:&error];
    if (error) {
        NSLog(@"Error reading directory %@: %@", debugpath, error.localizedDescription);
        return;
    }
    if (files == nil || ![files containsObject:filename]) {
        NSLog(@"File %@ not found in directory %@", filename, debugpath);
        return;
    }
    
    NSString *filePath = [debugpath stringByAppendingPathComponent:filename];
    NSString *content = [NSString stringWithContentsOfFile:filePath encoding:NSUTF8StringEncoding error:&error];
    if (error) {
        NSLog(@"Error reading file %@: %@", filePath, error.localizedDescription);
        return;
    }
    
    NSData *jsonData = [content dataUsingEncoding:NSUTF8StringEncoding];
    NSError *jsonError = nil;
    NSDictionary *jsonDict = [NSJSONSerialization JSONObjectWithData:jsonData options:0 error:&jsonError];
    if (jsonError) {
        NSLog(@"Invalid JSON: %@", jsonError.localizedDescription);
        return;
    }
    
    NSString *urlValue = jsonDict[@"url"];
    if (urlValue && urlValue.length > 0) {
        _url = urlValue;
        NSLog(@"Get url: %@", _url);
    }
    
    if ((!_apikey || _apikey.length == 0) &&
        jsonDict[@"apikey"] && [jsonDict[@"apikey"] length] > 0) {
        _apikey = jsonDict[@"apikey"];
        NSLog(@"Get apikey: %@", _apikey);
    }
}

-(void)saveAccessFromFile:(NSString*)accessFile {
    NSMutableDictionary *jsonDict = [NSMutableDictionary dictionary];
    jsonDict[@"url"] = _url ?: @"";
    jsonDict[@"apikey"] = _apikey ?: @"";

    // 日志输出
    NSLog(@"Save info: %@", accessFile);

    NSError *error = nil;

    // 序列化为 JSON 数据
    NSData *jsonData = [NSJSONSerialization dataWithJSONObject:jsonDict options:NSJSONWritingPrettyPrinted error:&error];
    if (!jsonData) {
        NSLog(@"Error creating JSON: %@", error.localizedDescription);
        return;
    }

    // 转为字符串（UTF-8）
    NSString *jsonString = [[NSString alloc] initWithData:jsonData encoding:NSUTF8StringEncoding];
    if (!jsonString) {
        NSLog(@"Invalid JSON string encoding.");
        return;
    } else {
        NSLog(@"JSON: %@", jsonString);
    }

    // 获取完整文件路径（建议传入全路径，或拼接目录）
    // 如果 accessFile 是相对路径，可拼到 Documents 目录等
    NSString *filePath = accessFile;
    if (![[NSFileManager defaultManager] fileExistsAtPath:[accessFile stringByDeletingLastPathComponent]]) {
        // 如果路径不是绝对路径，保存到 Documents 目录
        NSArray *paths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
        NSString *docsDir = paths.firstObject;
        filePath = [docsDir stringByAppendingPathComponent:accessFile];
    }

    // 写入文件
    BOOL success = [jsonString writeToFile:filePath atomically:YES encoding:NSUTF8StringEncoding error:&error];
    if (success) {
        NSLog(@"Saved successfully to %@", filePath);
    } else {
        NSLog(@"Failed to save file: %@", error.localizedDescription);
    }
}

-(void) viewDidLoad {
    [super viewDidLoad];
    NSLog(@"tableView enter self.navigationController %@", self.navigationController);
    
    NuiSdkUtils *utils = [NuiSdkUtils alloc];
    NSString *debug_path = [utils createDir];
    
    [self parseAccessFromFile:debug_path filename:@".nui_access"];
    
    int idx = 0;

    // 当前服务地址仅为wss://dashscope.aliyuncs.com/api-ws/v1/inference
//    [self setupLabel:idx title:@"服务地址："];
//    [self setupOptionButton:++idx
//                  optionBtn:urlOption array:@[@"wss://dashscope.aliyuncs.com/api-ws/v1/inference"]];
    
    _url = @"wss://dashscope.aliyuncs.com/api-ws/v1/inference";
//    _apikey = @"";
    
    [self setupLabel:++idx title:@"账号方式 API Key："];
    [self setupTextField:++idx];
    
    idx++;
    
    [self setupButton:ServerButtion index:++idx title:@"Gummy一句话识别、翻译" action:@selector(startGummySpeechRecognizer:)];
    [self setupButton:ServerButtion index:++idx title:@"Gummy实时识别、翻译" action:@selector(startGummySpeechTranscriber:)];
    [self setupButton:ServerButtion index:++idx title:@"Paraformer实时语音识别" action:@selector(startParaformerSpeechTranscriber:)];
    [self setupButton:ServerButtion index:++idx title:@"Paraformer录音文件识别" action:@selector(startParaformerFileTranscriber:)];
    [self setupButton:ServerButtion index:++idx title:@"Fun-ASR实时语音识别" action:@selector(startFunAsrSpeechTranscriber:)];
    [self setupButton:ServerButtion index:++idx title:@"Fun-ASR录音文件识别" action:@selector(startFunAsrFileTranscriber:)];
    [self setupButton:ServerButtion index:++idx title:@"Sambert语音合成" action:@selector(startSambertTts:)];
    [self setupButton:ServerButtion index:++idx title:@"CosyVoice流式语音合成" action:@selector(startCosyvoiceStreamInputTts:)];
}

- (IBAction)startGummySpeechRecognizer:(UIButton *)sender {
    if (_apikeyTextField.text) {
        _apikey = [_apikeyTextField.text copy];
        NSLog(@"startGummySpeechRecognizer Get API Key: %@", _apikeyTextField.text);
    } else {
        _apikey = @"";
    }
    if (_url) {
        NSLog(@"startGummySpeechRecognizer Get URL: %@", _url);
    } else {
        _url = @"wss://dashscope.aliyuncs.com/api-ws/v1/inference";
    }
    
    DashGummySpeechRecognizerViewController * controller = [[DashGummySpeechRecognizerViewController alloc] init];
    controller.url = _url;
    controller.apikey = _apikey;
    [self.navigationController pushViewController:controller animated:YES];

    [self saveAccessFromFile:_accessFilePath];
}

- (IBAction)startGummySpeechTranscriber:(UIButton *)sender {
    if (_apikeyTextField.text) {
        _apikey = [_apikeyTextField.text copy];
        NSLog(@"startGummySpeechTranscriber Get API Key: %@", _apikeyTextField.text);
    } else {
        _apikey = @"";
    }
    if (_url) {
        NSLog(@"startGummySpeechTranscriber Get URL: %@", _url);
    } else {
        _url = @"wss://dashscope.aliyuncs.com/api-ws/v1/inference";
    }
    
    DashGummySpeechTranscriberViewController * controller = [[DashGummySpeechTranscriberViewController alloc] init];
    controller.url = _url;
    controller.apikey = _apikey;
    [self.navigationController pushViewController:controller animated:YES];
}

- (IBAction)startParaformerSpeechTranscriber:(UIButton *)sender {
    if (_apikeyTextField.text) {
        _apikey = [_apikeyTextField.text copy];
        NSLog(@"startParaformerSpeechTranscriber Get API Key: %@", _apikeyTextField.text);
    } else {
        _apikey = @"";
    }
    if (_url) {
        NSLog(@"startParaformerSpeechTranscriber Get URL: %@", _url);
    } else {
        _url = @"wss://dashscope.aliyuncs.com/api-ws/v1/inference";
    }
    
    DashParaformerSpeechTranscriberViewController * controller = [[DashParaformerSpeechTranscriberViewController alloc] init];
    controller.url = _url;
    controller.apikey = _apikey;
    [self.navigationController pushViewController:controller animated:YES];
}

- (IBAction)startParaformerFileTranscriber:(UIButton *)sender {
    if (_apikeyTextField.text) {
        _apikey = [_apikeyTextField.text copy];
        NSLog(@"startParaformerFileTranscriber Get API Key: %@", _apikeyTextField.text);
    } else {
        _apikey = @"";
    }
    if (_url) {
        NSLog(@"startParaformerFileTranscriber Get URL: %@", _url);
    } else {
        _url = @"wss://dashscope.aliyuncs.com/api-ws/v1/inference";
    }
    
    DashParaformerFileTranscriberViewController * controller = [[DashParaformerFileTranscriberViewController alloc] init];
    controller.url = _url;
    controller.apikey = _apikey;
    [self.navigationController pushViewController:controller animated:YES];
}

- (IBAction)startFunAsrSpeechTranscriber:(UIButton *)sender {
    if (_apikeyTextField.text) {
        _apikey = [_apikeyTextField.text copy];
        NSLog(@"startFunAsrSpeechTranscriber Get API Key: %@", _apikeyTextField.text);
    } else {
        _apikey = @"";
    }
    if (_url) {
        NSLog(@"startFunAsrSpeechTranscriber Get URL: %@", _url);
    } else {
        _url = @"wss://dashscope.aliyuncs.com/api-ws/v1/inference";
    }

    DashFunAsrSpeechTranscriberViewController * controller = [[DashFunAsrSpeechTranscriberViewController alloc] init];
    controller.url = _url;
    controller.apikey = _apikey;
    [self.navigationController pushViewController:controller animated:YES];
}


- (IBAction)startFunAsrFileTranscriber:(UIButton *)sender {
    if (_apikeyTextField.text) {
        _apikey = [_apikeyTextField.text copy];
        NSLog(@"startParaformerFileTranscriber Get API Key: %@", _apikeyTextField.text);
    } else {
        _apikey = @"";
    }
    if (_url) {
        NSLog(@"startFunAsrFileTranscriber Get URL: %@", _url);
    } else {
        _url = @"wss://dashscope.aliyuncs.com/api-ws/v1/inference";
    }
    
    DashFunAsrFileTranscriberViewController * controller = [[DashFunAsrFileTranscriberViewController alloc] init];
    controller.url = _url;
    controller.apikey = _apikey;
    [self.navigationController pushViewController:controller animated:YES];
}

- (IBAction)startSambertTts:(UIButton *)sender {
    if (_apikeyTextField.text) {
        _apikey = [_apikeyTextField.text copy];
        NSLog(@"startSambertTts Get API Key: %@", _apikeyTextField.text);
    } else {
        _apikey = @"";
    }
    if (_url) {
        NSLog(@"startSambertTts Get URL: %@", _url);
    } else {
        _url = @"wss://dashscope.aliyuncs.com/api-ws/v1/inference";
    }
    
    DashSambertTTSViewController * controller = [[DashSambertTTSViewController alloc] init];
    controller.url = _url;
    controller.apikey = _apikey;
    [self.navigationController pushViewController:controller animated:YES];
}
- (IBAction)startCosyvoiceStreamInputTts:(UIButton *)sender {
    if (_apikeyTextField.text) {
        _apikey = [_apikeyTextField.text copy];
        NSLog(@"startCosyvoiceStreamInputTts Get API Key: %@", _apikeyTextField.text);
    } else {
        _apikey = @"";
    }
    if (_url) {
        NSLog(@"startCosyvoiceStreamInputTts Get URL: %@", _url);
    } else {
        _url = @"wss://dashscope.aliyuncs.com/api-ws/v1/inference";
    }
    
    DashCosyVoiceStreamInputTTSViewController * controller = [[DashCosyVoiceStreamInputTTSViewController alloc] init];
    controller.url = _url;
    controller.apikey = _apikey;
    [self.navigationController pushViewController:controller animated:YES];
}

@end
