package com.aliyun;

import com.aliyun.entity.Test;
import com.aliyun.service.TestService;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;

import java.util.LinkedList;
import java.util.List;

@SpringBootApplication
@EnableScheduling
@MapperScan("com.aliyun.mapper")
public class Main {
    public static final int INSERT_BATCH_SIZE = 10000;
    public static final int INSERT_BATCH_NUM = 10;
    private final static boolean ENTERPRISE = true; // YOUR CONFIG HERE
    private final static Integer INSERT_OPTIMIZE_LEVEL = 3;
    @Autowired
    TestService testService;
    public static void main(String[] args) {
        SpringApplication.run(Main.class, args);
    }

    @Scheduled(fixedRate = 1000)
    public void task1() {
        crud();
    }

    @Scheduled(fixedRate = 1000)
    public void task2() {
        crud();
    }

    /**
     * crud test
     */
    public void crud() {
        try {
            // create table
            testService.createTable(ENTERPRISE);

            // insert
            long randBase = (long) (Math.random() * 1000000); // random number, prevent data duplicate and lost
            for (int i = 0; i < INSERT_BATCH_NUM; i++) {
                long insertStartTime = System.currentTimeMillis();
                List<Test> tests = new LinkedList<>();
                for (int j = 0; j < INSERT_BATCH_SIZE; j++) {
                    Long id = (long) i * INSERT_BATCH_SIZE + j + randBase;
                    tests.add(new Test(id, "test" + id));
                }
                testService.insertTestsByNative(tests, INSERT_OPTIMIZE_LEVEL);
                System.out.printf("[%d] insert batch [%d/%d] with %d tests success, cost %d ms\n",
                        Thread.currentThread().getId(), i + 1, INSERT_BATCH_NUM, tests.size(), System.currentTimeMillis() - insertStartTime);
            }

            // count
            Long totalCount = testService.count();
            System.out.printf("[%d] total count is %d\n", Thread.currentThread().getId(), totalCount);

            // select
            testService.selectById(randBase);
            System.out.printf("[%d] select success\n", Thread.currentThread().getId());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
