/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.agent.rt.internal_f3994fa.core.internal.instr;

import org.jacoco.agent.rt.internal_f3994fa.asm.ClassReader;
import org.jacoco.agent.rt.internal_f3994fa.core.internal.flow.ClassProbesAdapter;
import org.jacoco.agent.rt.internal_f3994fa.core.internal.instr.ClassFieldProbeArrayStrategy;
import org.jacoco.agent.rt.internal_f3994fa.core.internal.instr.CondyProbeArrayStrategy;
import org.jacoco.agent.rt.internal_f3994fa.core.internal.instr.IProbeArrayStrategy;
import org.jacoco.agent.rt.internal_f3994fa.core.internal.instr.InstrSupport;
import org.jacoco.agent.rt.internal_f3994fa.core.internal.instr.InterfaceFieldProbeArrayStrategy;
import org.jacoco.agent.rt.internal_f3994fa.core.internal.instr.LocalProbeArrayStrategy;
import org.jacoco.agent.rt.internal_f3994fa.core.internal.instr.NoneProbeArrayStrategy;
import org.jacoco.agent.rt.internal_f3994fa.core.internal.instr.ProbeCounter;
import org.jacoco.agent.rt.internal_f3994fa.core.runtime.IExecutionDataAccessorGenerator;

public final class ProbeArrayStrategyFactory {
    private ProbeArrayStrategyFactory() {
    }

    public static IProbeArrayStrategy createFor(long classId, ClassReader reader, IExecutionDataAccessorGenerator accessorGenerator) {
        String className = reader.getClassName();
        int version = InstrSupport.getMajorVersion(reader);
        if (ProbeArrayStrategyFactory.isInterfaceOrModule(reader)) {
            ProbeCounter counter2 = ProbeArrayStrategyFactory.getProbeCounter(reader);
            if (counter2.getCount() == 0) {
                return new NoneProbeArrayStrategy();
            }
            if (version >= 55 && counter2.hasMethods()) {
                return new CondyProbeArrayStrategy(className, true, classId, accessorGenerator);
            }
            if (version >= 52 && counter2.hasMethods()) {
                return new InterfaceFieldProbeArrayStrategy(className, classId, counter2.getCount(), accessorGenerator);
            }
            return new LocalProbeArrayStrategy(className, classId, counter2.getCount(), accessorGenerator);
        }
        if (version >= 55) {
            return new CondyProbeArrayStrategy(className, false, classId, accessorGenerator);
        }
        return new ClassFieldProbeArrayStrategy(className, classId, InstrSupport.needsFrames(version), accessorGenerator);
    }

    private static boolean isInterfaceOrModule(ClassReader reader) {
        return (reader.getAccess() & 0x8200) != 0;
    }

    private static ProbeCounter getProbeCounter(ClassReader reader) {
        ProbeCounter counter2 = new ProbeCounter();
        reader.accept(new ClassProbesAdapter(counter2, false), 0);
        return counter2;
    }
}

