/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.launcher;

import com.aliyun.emr_serverless_spark20230808.Client;
import com.aliyun.emr_serverless_spark20230808.models.CancelJobRunRequest;
import com.aliyun.emr_serverless_spark20230808.models.CancelJobRunResponse;
import com.aliyun.emr_serverless_spark20230808.models.GetJobRunRequest;
import com.aliyun.emr_serverless_spark20230808.models.GetJobRunResponse;
import com.aliyun.emr_serverless_spark20230808.models.GetTemplateRequest;
import com.aliyun.emr_serverless_spark20230808.models.GetTemplateResponse;
import com.aliyun.emr_serverless_spark20230808.models.JobDriver;
import com.aliyun.emr_serverless_spark20230808.models.ListJobRunsRequest;
import com.aliyun.emr_serverless_spark20230808.models.ListJobRunsResponse;
import com.aliyun.emr_serverless_spark20230808.models.ListLogContentsRequest;
import com.aliyun.emr_serverless_spark20230808.models.ListLogContentsResponse;
import com.aliyun.emr_serverless_spark20230808.models.ListTemplateRequest;
import com.aliyun.emr_serverless_spark20230808.models.ListTemplateResponse;
import com.aliyun.emr_serverless_spark20230808.models.ListWorkspaceQueuesRequest;
import com.aliyun.emr_serverless_spark20230808.models.ListWorkspaceQueuesResponse;
import com.aliyun.emr_serverless_spark20230808.models.ListWorkspacesRequest;
import com.aliyun.emr_serverless_spark20230808.models.ListWorkspacesResponseBody;
import com.aliyun.emr_serverless_spark20230808.models.StartJobRunRequest;
import com.aliyun.emr_serverless_spark20230808.models.StartJobRunResponse;
import com.aliyun.emr_serverless_spark20230808.models.Tag;
import com.aliyun.emr_serverless_spark20230808.models.Template;
import com.aliyun.oss.OSSClient;
import com.aliyun.teaopenapi.models.Config;
import com.google.gson.Gson;
import dev.failsafe.Failsafe;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import dev.failsafe.RetryPolicyBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.launcher.LauncherProtocol;
import org.apache.spark.launcher.SparkAppHandle;
import org.apache.spark.launcher.log.Logger;
import org.apache.spark.launcher.log.LoggerFactory;
import org.apache.spark.launcher.models.Conf;
import org.apache.spark.launcher.models.Connection;
import org.apache.spark.launcher.models.SparkSubmit;
import org.apache.spark.launcher.utils.NetworkUtil;
import org.apache.spark.launcher.utils.StringsUtil;

public class ServerlessSparkUtil {
    private static final Logger LOGGER = LoggerFactory.get(ServerlessSparkUtil.class);
    public static Connection serverlessSparkConnection;
    private static Client client;
    private static OSSClient ossClient;
    public static int returnCode;
    private static final String SPARK_SQL_MAIN_CLASS = "org.apache.spark.sql.hive.thriftserver.SparkSQLCLIDriver";
    public static Boolean fromSparkLauncher;
    public static Socket socket;
    public static ObjectOutputStream out;
    public static Boolean isDw;
    private static final Set<String> needTermStates;
    private static final Set<String> needPollStates;
    private static final RetryPolicy<Object> retryPolicy;
    private static final RetryPolicy<Object> startJobRunRetryPolicy;
    private static String jobRunId;
    private static boolean needTerm;
    private static List<String> userFiles;
    private static final Map<String, String> internalVariableMapping;

    public static void loadConnection() throws Exception {
        String dwConnection;
        if (Objects.nonNull(System.getenv("_SPARK_LAUNCHER_PORT")) && Objects.nonNull(System.getenv("_SPARK_LAUNCHER_SECRET"))) {
            LOGGER.info("launch from spark launcher port: " + System.getenv("_SPARK_LAUNCHER_PORT"));
            fromSparkLauncher = true;
            socket = new Socket("localhost", Integer.parseInt(System.getenv("_SPARK_LAUNCHER_PORT")));
            out = new ObjectOutputStream(socket.getOutputStream());
            ServerlessSparkUtil.sendLauncherMessage(new LauncherProtocol.Hello(System.getenv("_SPARK_LAUNCHER_SECRET"), "3.5.5"));
        }
        if ((dwConnection = System.getenv("EMR_CACL_CONNECTION")) != null) {
            isDw = true;
            serverlessSparkConnection = new Gson().fromJson(dwConnection, Connection.class);
        } else {
            Properties prop = new Properties();
            String sparkConfDir = System.getenv("SPARK_CONF_DIR");
            if (sparkConfDir == null) {
                prop.load(ServerlessSparkUtil.class.getResourceAsStream("/connection.properties"));
            } else {
                prop.load(new FileReader(sparkConfDir + "/connection.properties"));
            }
            String regionId = prop.getProperty("regionId");
            serverlessSparkConnection = new Connection();
            serverlessSparkConnection.setAccessKeyId(prop.getProperty("accessKeyId"));
            serverlessSparkConnection.setAccessKeySecret(prop.getProperty("accessKeySecret"));
            serverlessSparkConnection.setSecurityToken(prop.getProperty("securityToken"));
            serverlessSparkConnection.setWorkspaceId(prop.getProperty("workspaceId"));
            String vpcEndpoint = "emr-serverless-spark-vpc." + regionId + ".aliyuncs.com";
            String endpoint = "emr-serverless-spark." + regionId + ".aliyuncs.com";
            if (NetworkUtil.isReachable("https://" + vpcEndpoint)) {
                serverlessSparkConnection.setEndpoint(vpcEndpoint);
            } else {
                serverlessSparkConnection.setEndpoint(endpoint);
            }
            if (prop.getProperty("endpoint") != null) {
                serverlessSparkConnection.setEndpoint(prop.getProperty("endpoint"));
            }
            serverlessSparkConnection.setRegionId(regionId);
            serverlessSparkConnection.setResourceQueueId(prop.getProperty("resourceQueueId"));
            serverlessSparkConnection.setReleaseVersion(prop.getProperty("releaseVersion"));
            serverlessSparkConnection.setNetworkServiceId(prop.getProperty("networkServiceId"));
        }
        Config config = new Config();
        config.setAccessKeyId(serverlessSparkConnection.getAccessKeyId());
        config.setAccessKeySecret(serverlessSparkConnection.getAccessKeySecret());
        config.setSecurityToken(serverlessSparkConnection.getSecurityToken());
        config.setRegionId(serverlessSparkConnection.getRegionId());
        config.setEndpoint(serverlessSparkConnection.getEndpoint());
        try {
            String ossInternalEndpoint = "oss-" + serverlessSparkConnection.getRegionId() + "-internal.aliyuncs.com";
            String ossEndpoint = "oss-" + serverlessSparkConnection.getRegionId() + ".aliyuncs.com";
            if (NetworkUtil.isReachable("https://" + ossInternalEndpoint)) {
                serverlessSparkConnection.setOssEndpoint(ossInternalEndpoint);
            } else {
                serverlessSparkConnection.setOssEndpoint(ossEndpoint);
            }
            ossClient = serverlessSparkConnection.getSecurityToken() != null ? new OSSClient(serverlessSparkConnection.getOssEndpoint(), serverlessSparkConnection.getAccessKeyId(), serverlessSparkConnection.getAccessKeySecret(), serverlessSparkConnection.getSecurityToken()) : new OSSClient(serverlessSparkConnection.getOssEndpoint(), serverlessSparkConnection.getAccessKeyId(), serverlessSparkConnection.getAccessKeySecret());
        }
        catch (Exception e) {
            LOGGER.warning("initialize oss client error: " + e.getMessage());
        }
        client = new Client(config);
    }

    private static String rewriteResourceConf(String confValue, String clientToken) throws Exception {
        if (confValue == null) {
            return null;
        }
        ArrayList<String> finalResource = new ArrayList<String>();
        for (String resource : confValue.split(",")) {
            String alias = null;
            if (resource.contains("#")) {
                int idx = resource.lastIndexOf("#");
                if (idx != resource.length() - 1) {
                    alias = resource.substring(idx + 1);
                }
                resource = resource.substring(0, idx);
            }
            if (!resource.startsWith("oss://")) {
                resource = ServerlessSparkUtil.uploadLocalFile(resource, clientToken);
            }
            if (alias != null) {
                resource = resource + "#" + alias;
            }
            finalResource.add(resource);
        }
        LOGGER.info("rewrite resource conf: " + finalResource);
        return String.join((CharSequence)",", finalResource);
    }

    private static String generateClientToken() {
        return UUID.randomUUID().toString().replace("-", "").toLowerCase().substring(0, 16);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StartJobRunRequest buildStartJobRunRequest(SparkSubmit sparkSubmit) throws Exception {
        String clientToken = ServerlessSparkUtil.generateClientToken();
        if (sparkSubmit.getSparkJars() != null) {
            sparkSubmit.setSparkJars(ServerlessSparkUtil.rewriteResourceConf(sparkSubmit.getSparkJars(), clientToken));
        }
        if (sparkSubmit.getKeytab() != null) {
            if (sparkSubmit.getSparkFiles() == null) {
                sparkSubmit.setSparkFiles(sparkSubmit.getKeytab());
            } else {
                sparkSubmit.setSparkFiles(sparkSubmit.getKeytab() + "," + sparkSubmit.getSparkFiles());
            }
        }
        if (sparkSubmit.getSparkFiles() != null) {
            sparkSubmit.setSparkFiles(ServerlessSparkUtil.rewriteResourceConf(sparkSubmit.getSparkFiles(), clientToken));
        }
        if (sparkSubmit.getSparkPyFiles() != null) {
            sparkSubmit.setSparkPyFiles(ServerlessSparkUtil.rewriteResourceConf(sparkSubmit.getSparkPyFiles(), clientToken));
        }
        if (sparkSubmit.getSparkArchives() != null) {
            sparkSubmit.setSparkArchives(ServerlessSparkUtil.rewriteResourceConf(sparkSubmit.getSparkArchives(), clientToken));
        }
        StartJobRunRequest startJobRunRequest = new StartJobRunRequest();
        startJobRunRequest.setClientToken(clientToken);
        if (serverlessSparkConnection.getReleaseVersion() != null) {
            startJobRunRequest.setReleaseVersion(serverlessSparkConnection.getReleaseVersion());
        }
        if (sparkSubmit.getReleaseVersion() != null) {
            startJobRunRequest.setReleaseVersion(sparkSubmit.getReleaseVersion());
        }
        if (sparkSubmit.getDisplayVersion() != null) {
            startJobRunRequest.setDisplayReleaseVersion(sparkSubmit.getDisplayVersion());
        }
        if (sparkSubmit.getFusion() != null) {
            startJobRunRequest.setFusion(sparkSubmit.getFusion());
        }
        startJobRunRequest.setName("spark-submit-tool-job-" + clientToken);
        startJobRunRequest.setRegionId(serverlessSparkConnection.getRegionId());
        JobDriver jobDriver = new JobDriver();
        JobDriver.JobDriverSparkSubmit jobDriverSparkSubmit = new JobDriver.JobDriverSparkSubmit();
        jobDriver.setSparkSubmit(jobDriverSparkSubmit);
        startJobRunRequest.setJobDriver(jobDriver);
        String appResource = sparkSubmit.getAppResource();
        ArrayList<String> sparkSubmitParameters = new ArrayList<String>();
        for (String string : sparkSubmit.getSqlDefines()) {
            String[] items = string.split("=");
            if (items.length != 2) continue;
            internalVariableMapping.put(items[0], items[1]);
        }
        if (appResource == null) {
            startJobRunRequest.setCodeType("SQL");
            sparkSubmitParameters.add("--class");
            sparkSubmitParameters.add(SPARK_SQL_MAIN_CLASS);
            if (sparkSubmit.getSqlExpression() != null) {
                String content = ServerlessSparkUtil.replaceInternalVariable(sparkSubmit.getSqlExpression());
                sparkSubmit.setExtraArgs(Arrays.asList("-e", content));
            } else {
                if (sparkSubmit.getSqlFile() == null) throw new Exception("no sql file or expression");
                if (!sparkSubmit.getSqlFile().startsWith("oss://")) {
                    String ossSqlFile = ServerlessSparkUtil.uploadLocalFile(sparkSubmit.getSqlFile(), clientToken);
                    sparkSubmit.setSqlFile(ossSqlFile);
                }
                ArrayList<String> extraArgs = new ArrayList<String>(Arrays.asList("-f", sparkSubmit.getSqlFile()));
                if (!sparkSubmit.getSqlDefines().isEmpty()) {
                    for (String sqlDefine : sparkSubmit.getSqlDefines()) {
                        extraArgs.addAll(Arrays.asList("--hivevar", sqlDefine));
                    }
                }
                sparkSubmit.setExtraArgs(extraArgs);
            }
        } else {
            if (appResource.endsWith(".py")) {
                startJobRunRequest.setCodeType("PYTHON");
            } else if (appResource.endsWith(".jar")) {
                startJobRunRequest.setCodeType("JAR");
            } else {
                if (!appResource.endsWith(".ipynb") && !appResource.endsWith(".IPYNB")) throw new Exception("not supported main application file suffix: " + appResource);
                startJobRunRequest.setCodeType("NOTEBOOK");
            }
            if (!appResource.startsWith("oss://")) {
                appResource = ServerlessSparkUtil.uploadLocalFile(appResource, clientToken);
            }
        }
        String name = sparkSubmit.getName();
        if (sparkSubmit.getDwNodeName() != null) {
            startJobRunRequest.setName(sparkSubmit.getDwNodeName());
        } else if (name != null) {
            startJobRunRequest.setName(name);
        }
        String string = sparkSubmit.getQueue();
        String yarnQueueName = sparkSubmit.getYarnQueueName();
        if (yarnQueueName != null) {
            startJobRunRequest.setResourceQueueId(yarnQueueName);
        } else if (string != null) {
            startJobRunRequest.setResourceQueueId(string);
        } else if (serverlessSparkConnection.getResourceQueueId() != null) {
            startJobRunRequest.setResourceQueueId(serverlessSparkConnection.getResourceQueueId());
        } else {
            Object defaultQueue = ServerlessSparkUtil.getDefaultQueue();
            if (defaultQueue == null) {
                LOGGER.info("no dev queue found in workspace, trying dev_queue...");
                defaultQueue = "dev_queue";
            }
            startJobRunRequest.setResourceQueueId((String)defaultQueue);
        }
        jobDriverSparkSubmit.setEntryPoint(appResource);
        jobDriverSparkSubmit.setEntryPointArguments(sparkSubmit.getExtraArgs());
        for (Map.Entry entry : sparkSubmit.getParams().entrySet()) {
            sparkSubmitParameters.add((String)entry.getKey() + " " + (String)entry.getValue());
        }
        jobDriverSparkSubmit.setSparkSubmitParameters(StringsUtil.join(sparkSubmitParameters, " "));
        StartJobRunRequest.StartJobRunRequestConfigurationOverrides configurationOverrides = new StartJobRunRequest.StartJobRunRequestConfigurationOverrides();
        startJobRunRequest.setConfigurationOverrides(configurationOverrides);
        ArrayList<StartJobRunRequest.StartJobRunRequestConfigurationOverridesConfigurations> arrayList = new ArrayList<StartJobRunRequest.StartJobRunRequestConfigurationOverridesConfigurations>();
        configurationOverrides.setConfigurations(arrayList);
        int driverCores = sparkSubmit.getSparkDriverCores() != null ? sparkSubmit.getSparkDriverCores() : 1;
        int executorCores = sparkSubmit.getSparkExecutorCores() != null ? sparkSubmit.getSparkExecutorCores() : 1;
        String driverMemory = sparkSubmit.getSparkDriverMemory() != null ? sparkSubmit.getSparkDriverMemory() : "4g";
        String executorMemory = sparkSubmit.getSparkExecutorMemory() != null ? sparkSubmit.getSparkExecutorMemory() : "4g";
        arrayList.add(new StartJobRunRequest.StartJobRunRequestConfigurationOverridesConfigurations().setConfigFileName("spark-defaults.conf").setConfigItemKey("spark.driver.cores").setConfigItemValue(Integer.toString(driverCores)));
        arrayList.add(new StartJobRunRequest.StartJobRunRequestConfigurationOverridesConfigurations().setConfigFileName("spark-defaults.conf").setConfigItemKey("spark.driver.memory").setConfigItemValue(driverMemory));
        arrayList.add(new StartJobRunRequest.StartJobRunRequestConfigurationOverridesConfigurations().setConfigFileName("spark-defaults.conf").setConfigItemKey("spark.executor.cores").setConfigItemValue(Integer.toString(executorCores)));
        arrayList.add(new StartJobRunRequest.StartJobRunRequestConfigurationOverridesConfigurations().setConfigFileName("spark-defaults.conf").setConfigItemKey("spark.executor.memory").setConfigItemValue(executorMemory));
        if (sparkSubmit.getSparkNumExecutors() != null) {
            arrayList.add(new StartJobRunRequest.StartJobRunRequestConfigurationOverridesConfigurations().setConfigFileName("spark-defaults.conf").setConfigItemKey("spark.executor.instances").setConfigItemValue(sparkSubmit.getSparkNumExecutors().toString()));
        }
        if (sparkSubmit.getSparkArchives() != null) {
            arrayList.add(new StartJobRunRequest.StartJobRunRequestConfigurationOverridesConfigurations().setConfigFileName("spark-defaults.conf").setConfigItemKey("spark.archives").setConfigItemValue(sparkSubmit.getSparkArchives()));
        }
        if (sparkSubmit.getSparkPyFiles() != null) {
            arrayList.add(new StartJobRunRequest.StartJobRunRequestConfigurationOverridesConfigurations().setConfigFileName("spark-defaults.conf").setConfigItemKey("spark.submit.pyFiles").setConfigItemValue(sparkSubmit.getSparkPyFiles()));
        }
        if (sparkSubmit.getSparkFiles() != null) {
            arrayList.add(new StartJobRunRequest.StartJobRunRequestConfigurationOverridesConfigurations().setConfigFileName("spark-defaults.conf").setConfigItemKey("spark.files").setConfigItemValue(sparkSubmit.getSparkFiles()));
        }
        if (sparkSubmit.getSparkJars() != null) {
            arrayList.add(new StartJobRunRequest.StartJobRunRequestConfigurationOverridesConfigurations().setConfigFileName("spark-defaults.conf").setConfigItemKey("spark.jars").setConfigItemValue(sparkSubmit.getSparkJars()));
        }
        if (serverlessSparkConnection.getNetworkServiceId() != null) {
            arrayList.add(new StartJobRunRequest.StartJobRunRequestConfigurationOverridesConfigurations().setConfigFileName("spark-defaults.conf").setConfigItemKey("spark.emr.serverless.network.service.name").setConfigItemValue(serverlessSparkConnection.getNetworkServiceId()));
        }
        if (sparkSubmit.getKeytab() != null && sparkSubmit.getConf().stream().noneMatch(conf -> conf.getKey().equals("spark.kerberos.keytab"))) {
            String fileName = sparkSubmit.getKeytab().substring(sparkSubmit.getKeytab().lastIndexOf("/") + 1);
            sparkSubmit.getConf().add(Conf.builder().key("spark.kerberos.keytab").value(fileName).build());
        }
        if (sparkSubmit.getPrincipal() != null && sparkSubmit.getConf().stream().noneMatch(conf -> conf.getKey().equals("spark.kerberos.principal"))) {
            sparkSubmit.getConf().add(Conf.builder().key("spark.kerberos.principal").value(sparkSubmit.getPrincipal()).build());
        }
        ArrayList<Tag> tags = new ArrayList<Tag>(Arrays.asList(new Tag().setKey("workflow").setValue("false"), new Tag().setKey("toolVersion").setValue(sparkSubmit.getToolVersion())));
        if (sparkSubmit.getProxyUser() != null) {
            arrayList.add(new StartJobRunRequest.StartJobRunRequestConfigurationOverridesConfigurations().setConfigFileName("spark-defaults.conf").setConfigItemKey("spark.kubernetes.driverEnv.HADOOP_USER_NAME").setConfigItemValue(sparkSubmit.getProxyUser()));
            arrayList.add(new StartJobRunRequest.StartJobRunRequestConfigurationOverridesConfigurations().setConfigFileName("spark-defaults.conf").setConfigItemKey("spark.executorEnv.HADOOP_USER_NAME").setConfigItemValue(sparkSubmit.getProxyUser()));
        }
        for (Conf conf2 : sparkSubmit.getConf()) {
            arrayList.add(new StartJobRunRequest.StartJobRunRequestConfigurationOverridesConfigurations().setConfigFileName("spark-defaults.conf").setConfigItemKey(conf2.getKey()).setConfigItemValue(conf2.getValue()));
            if (!conf2.getKey().startsWith("spark.tags.")) continue;
            tags.add(new Tag().setKey(conf2.getKey().replace("spark.tags.", "")).setValue(conf2.getValue()));
        }
        startJobRunRequest.setTags(tags);
        if (sparkSubmit.getTimeout() == null) return startJobRunRequest;
        startJobRunRequest.setExecutionTimeoutSeconds(sparkSubmit.getTimeout());
        return startJobRunRequest;
    }

    public static void getJobRun(SparkSubmit sparkSubmit) {
        GetJobRunRequest getJobRunRequest = new GetJobRunRequest();
        Failsafe.with(retryPolicy, (Policy[])new RetryPolicy[0]).run(() -> {
            GetJobRunResponse getJobRunResponse = client.getJobRun(serverlessSparkConnection.getWorkspaceId(), sparkSubmit.getTargetJrId(), getJobRunRequest);
            List<String> items = Arrays.asList("Name: " + getJobRunResponse.getBody().getJobRun().getName(), "Type: " + getJobRunResponse.getBody().getJobRun().getCodeType(), "State: " + getJobRunResponse.getBody().getJobRun().getState(), "WebUI: " + getJobRunResponse.getBody().getJobRun().getWebUI());
            System.out.println(StringUtils.join(items, "\n"));
        });
    }

    public static void getJobRunState(SparkSubmit sparkSubmit) {
        LOGGER.info("start get job run: " + sparkSubmit.getTargetJrId());
        GetJobRunRequest getJobRunRequest = new GetJobRunRequest();
        Failsafe.with(retryPolicy, (Policy[])new RetryPolicy[0]).run(() -> {
            GetJobRunResponse getJobRunResponse = client.getJobRun(serverlessSparkConnection.getWorkspaceId(), sparkSubmit.getTargetJrId(), getJobRunRequest);
            System.out.println(getJobRunResponse.getBody().getJobRun().getState());
        });
    }

    public static void cancelJobRun(SparkSubmit sparkSubmit) {
        GetJobRunRequest getJobRunRequest = new GetJobRunRequest();
        try {
            long minRunTime;
            GetJobRunResponse getJobRunResponse = client.getJobRun(serverlessSparkConnection.getWorkspaceId(), sparkSubmit.getTargetJrId(), getJobRunRequest);
            if (needTermStates.contains(getJobRunResponse.getBody().getJobRun().getState())) {
                LOGGER.info("job run is already in term state: " + getJobRunResponse.getBody().getJobRun().getState());
                return;
            }
            long runTime = System.currentTimeMillis() - getJobRunResponse.getBody().getJobRun().getSubmitTime();
            if (runTime <= (minRunTime = 30000L)) {
                LOGGER.info("waiting for job run start up to\ufffd\ufffd\ufffd " + minRunTime + " ms");
                Thread.sleep(minRunTime - runTime);
            }
        }
        catch (Exception getJobRunResponse) {
            // empty catch block
        }
        CancelJobRunRequest cancelJobRunRequest = new CancelJobRunRequest();
        Failsafe.with(retryPolicy, (Policy[])new RetryPolicy[0]).run(() -> {
            LOGGER.info("start cancel job run: " + sparkSubmit.getTargetJrId());
            CancelJobRunResponse cancelJobRunResponse = client.cancelJobRun(serverlessSparkConnection.getWorkspaceId(), sparkSubmit.getTargetJrId(), cancelJobRunRequest);
            LOGGER.info("cancel job run success: " + new Gson().toJson(cancelJobRunResponse.getBody()));
        });
    }

    public static void logJobRun(SparkSubmit sparkSubmit) {
        GetJobRunRequest getJobRunRequest = new GetJobRunRequest();
        Failsafe.with(retryPolicy, (Policy[])new RetryPolicy[0]).run(() -> {
            GetJobRunResponse getJobRunResponse = client.getJobRun(serverlessSparkConnection.getWorkspaceId(), sparkSubmit.getTargetJrId(), getJobRunRequest);
            LOGGER.info("=======================stdout=======================\n");
            ServerlessSparkUtil.writeLogContent(getJobRunResponse.getBody().getJobRun().getLog().getDriverStdOut(), true);
            LOGGER.info("=======================stderr=======================\n");
            ServerlessSparkUtil.writeLogContent(getJobRunResponse.getBody().getJobRun().getLog().getDriverStdError(), false);
        });
    }

    public static void listJobRuns(SparkSubmit sparkSubmit) {
        ListJobRunsRequest listJobRunsRequest = new ListJobRunsRequest();
        if (sparkSubmit.getMaxResults() != null) {
            listJobRunsRequest.setMaxResults(sparkSubmit.getMaxResults());
        }
        if (sparkSubmit.getNextToken() != null) {
            listJobRunsRequest.setNextToken(sparkSubmit.getNextToken());
        }
        listJobRunsRequest.setStates(Arrays.asList("Running", "Submitted"));
        Failsafe.with(retryPolicy, (Policy[])new RetryPolicy[0]).run(() -> {
            List<String> headers = Arrays.asList("ApplicationId", "Name", "Type", "State");
            ListJobRunsResponse listJobRunsResponse = client.listJobRuns(serverlessSparkConnection.getWorkspaceId(), listJobRunsRequest);
            System.out.println(StringUtils.join(headers, "\t"));
            listJobRunsResponse.getBody().getJobRuns().forEach(jobRun -> {
                List<String> items = Arrays.asList(jobRun.getJobRunId(), jobRun.getName(), jobRun.getCodeType(), jobRun.getState());
                System.out.println(StringUtils.join(items, "\t"));
            });
        });
    }

    public static void submitAndPoll(SparkSubmit sparkSubmit) throws Exception {
        ServerlessSparkUtil.sendLauncherMessage(new LauncherProtocol.SetState(SparkAppHandle.State.CONNECTED));
        if (sparkSubmit.getEnableTemplate().booleanValue() || sparkSubmit.getTemplateBizId() != null) {
            ServerlessSparkUtil.applyTemplate(sparkSubmit);
        }
        StartJobRunRequest startJobRunRequest = ServerlessSparkUtil.buildStartJobRunRequest(sparkSubmit);
        Failsafe.with(startJobRunRetryPolicy, (Policy[])new RetryPolicy[0]).run(() -> {
            StartJobRunResponse startJobRunResponse;
            LOGGER.info("start run request is: " + new Gson().toJson(startJobRunRequest));
            try {
                startJobRunResponse = client.startJobRun(serverlessSparkConnection.getWorkspaceId(), startJobRunRequest);
            }
            catch (Exception e) {
                LOGGER.info("start job run failed: " + e.getMessage());
                throw new RuntimeException(e.getMessage());
            }
            jobRunId = startJobRunResponse.getBody().getJobRunId();
            sparkSubmit.setTargetJrId(jobRunId);
        });
        if (sparkSubmit.getDetach().booleanValue()) {
            System.out.println(jobRunId + " is running in detach mode");
            return;
        }
        ServerlessSparkUtil.sendLauncherMessage(new LauncherProtocol.SetAppId(jobRunId));
        ServerlessSparkUtil.sendLauncherMessage(new LauncherProtocol.SetState(SparkAppHandle.State.SUBMITTED));
        do {
            Failsafe.with(retryPolicy, (Policy[])new RetryPolicy[0]).run(() -> {
                GetJobRunRequest getJobRunRequest = new GetJobRunRequest().setRegionId(serverlessSparkConnection.getRegionId());
                GetJobRunResponse getJobRunResponse = client.getJobRun(serverlessSparkConnection.getWorkspaceId(), jobRunId, getJobRunRequest);
                String state = getJobRunResponse.getBody().getJobRun().getState();
                if (needPollStates.contains(state)) {
                    if (fromSparkLauncher.booleanValue() && state.equalsIgnoreCase("running")) {
                        ServerlessSparkUtil.sendLauncherMessage(new LauncherProtocol.SetState(SparkAppHandle.State.RUNNING));
                    }
                    LOGGER.info("job run id is : " + jobRunId + ", state is: " + state);
                    if (getJobRunResponse.getBody().getJobRun().getWebUI() != null) {
                        LOGGER.info("click this link to view spark runtime ui: " + getJobRunResponse.getBody().getJobRun().getWebUI());
                    }
                }
                if (needTermStates.contains(state)) {
                    needTerm = true;
                    if (!state.equalsIgnoreCase("success")) {
                        ServerlessSparkUtil.sendLauncherMessage(new LauncherProtocol.SetState(SparkAppHandle.State.FAILED));
                        returnCode = 127;
                    }
                    ServerlessSparkUtil.sendLauncherMessage(new LauncherProtocol.SetState(SparkAppHandle.State.FINISHED));
                    LOGGER.info("job run id is : " + jobRunId + ", final state is: " + state + ", stop polling");
                    if (getJobRunResponse.getBody().getJobRun().getWebUI() != null) {
                        LOGGER.info("click this link to view spark history ui: " + getJobRunResponse.getBody().getJobRun().getWebUI());
                    }
                    if (sparkSubmit.getSqlTmpFile() != null) {
                        String bucket = sparkSubmit.getSqlTmpFile().replace("oss://", "").split("/")[0];
                        String key = sparkSubmit.getSqlTmpFile().replace("oss://" + bucket + "/", "");
                        try {
                            ossClient.deleteObject(bucket, key);
                        }
                        catch (Exception e) {
                            LOGGER.info("error delete object: " + e.getMessage());
                        }
                    }
                    if (getJobRunResponse.getBody().getJobRun().getLog() != null) {
                        String stdoutUrl = getJobRunResponse.getBody().getJobRun().getLog().getDriverStdOut();
                        String stderrUrl = getJobRunResponse.getBody().getJobRun().getLog().getDriverStdError();
                        LOGGER.info("=======================stdout=======================\n");
                        ServerlessSparkUtil.writeLogContent(stdoutUrl, true);
                        LOGGER.info("=======================stderr=======================\n");
                        ServerlessSparkUtil.writeLogContent(stderrUrl, false);
                    }
                }
                Thread.sleep(5000L);
            });
        } while (!needTerm);
    }

    private static void applyTemplate(SparkSubmit sparkSubmit) {
        try {
            GetTemplateResponse getTemplateResponse;
            GetTemplateRequest getTemplateRequest = new GetTemplateRequest();
            if (sparkSubmit.getTemplateBizId() != null) {
                getTemplateRequest.setTemplateBizId(sparkSubmit.getTemplateBizId());
            }
            if ((getTemplateResponse = client.getTemplate(serverlessSparkConnection.getWorkspaceId(), getTemplateRequest)).getBody().getData().getBizId() == null) {
                LOGGER.info("no default template, apply nothing");
                return;
            }
            Boolean templateFusion = getTemplateResponse.getBody().getData().getFusion();
            String templateDisplayVersion = getTemplateResponse.getBody().getData().getDisplaySparkVersion();
            Integer templateDriverCores = getTemplateResponse.getBody().getData().getSparkDriverCores();
            Integer templateExecutorCores = getTemplateResponse.getBody().getData().getSparkExecutorCores();
            String templateDriverMemory = getTemplateResponse.getBody().getData().getSparkDriverMemory() / 1024L / 1024L / 1024L + "g";
            String templateExecutorMemory = getTemplateResponse.getBody().getData().getSparkExecutorMemory() / 1024L / 1024L / 1024L + "g";
            List<Conf> templateConf = getTemplateResponse.getBody().getData().getSparkConf().stream().map(item -> Conf.builder().key(item.getKey()).value(item.getValue()).build()).collect(Collectors.toList());
            if (sparkSubmit.getTemplateName() != null) {
                ListTemplateRequest listTemplateRequest = new ListTemplateRequest();
                listTemplateRequest.setRegionId(serverlessSparkConnection.getRegionId());
                ListTemplateResponse listTemplateResponse = client.listTemplate(serverlessSparkConnection.getWorkspaceId(), listTemplateRequest);
                Optional<Template> template = listTemplateResponse.getBody().getData().stream().filter(item -> item.getName().equals(sparkSubmit.getTemplateName())).findFirst();
                if (template.isPresent()) {
                    Template _template = template.get();
                    templateFusion = _template.getFusion();
                    templateDisplayVersion = _template.getDisplaySparkVersion();
                    templateDriverCores = _template.getSparkDriverCores();
                    templateExecutorCores = _template.getSparkExecutorCores();
                    templateDriverMemory = _template.getSparkDriverMemory() / 1024L / 1024L / 1024L + "g";
                    templateExecutorMemory = _template.getSparkExecutorMemory() / 1024L / 1024L / 1024L + "g";
                    templateConf = _template.getSparkConf().stream().map(item -> Conf.builder().key(item.getKey()).value(item.getValue()).build()).collect(Collectors.toList());
                }
            }
            if (sparkSubmit.getReleaseVersion() == null) {
                if (sparkSubmit.getFusion() == null) {
                    sparkSubmit.setFusion(templateFusion);
                }
                sparkSubmit.setDisplayVersion(templateDisplayVersion);
            }
            if (sparkSubmit.getSparkDriverCores() == null) {
                sparkSubmit.setSparkDriverCores(templateDriverCores);
            }
            if (sparkSubmit.getSparkExecutorCores() == null) {
                sparkSubmit.setSparkExecutorCores(templateExecutorCores);
            }
            if (sparkSubmit.getSparkDriverMemory() == null) {
                sparkSubmit.setSparkDriverMemory(templateDriverMemory);
            }
            if (sparkSubmit.getSparkExecutorMemory() == null) {
                sparkSubmit.setSparkExecutorMemory(templateExecutorMemory);
            }
            if (sparkSubmit.getConf() == null) {
                sparkSubmit.setConf(templateConf);
            } else {
                ArrayList<Conf> tmpConf = new ArrayList<Conf>();
                templateConf.forEach(conf -> {
                    switch (conf.getKey()) {
                        case "spark.files": {
                            if (sparkSubmit.getSparkFiles() != null) break;
                            tmpConf.add((Conf)conf);
                            break;
                        }
                        case "spark.jars": {
                            if (sparkSubmit.getSparkJars() != null) break;
                            tmpConf.add((Conf)conf);
                            break;
                        }
                        case "spark.archives": {
                            if (sparkSubmit.getSparkArchives() != null) break;
                            tmpConf.add((Conf)conf);
                            break;
                        }
                        case "spark.submit.pyFiles": {
                            if (sparkSubmit.getSparkPyFiles() != null) break;
                            tmpConf.add((Conf)conf);
                            break;
                        }
                        default: {
                            tmpConf.add((Conf)conf);
                        }
                    }
                });
                tmpConf.addAll(sparkSubmit.getConf());
                sparkSubmit.setConf(tmpConf);
            }
        }
        catch (Exception e) {
            LOGGER.info(e.getMessage());
        }
    }

    private static void writeLogContent(String fileName, boolean stdout) {
        ListLogContentsRequest listLogContentsRequest = new ListLogContentsRequest().setRegionId(serverlessSparkConnection.getRegionId()).setFileName(fileName).setLength(100000).setOffset(0);
        try {
            ListLogContentsResponse listLogContentsResponse = client.listLogContents(serverlessSparkConnection.getWorkspaceId(), listLogContentsRequest);
            if (listLogContentsResponse != null) {
                listLogContentsResponse.getBody().getListLogContent().getContents().forEach(content -> {
                    if (stdout) {
                        System.out.println(content.getLineContent());
                    } else {
                        LOGGER.info(content.getLineContent());
                    }
                });
            }
        }
        catch (Exception e) {
            LOGGER.warning("fetch log content error: " + e.getMessage());
        }
    }

    private static String uploadLocalFile(String appResource, String clientToken) {
        String bucket = ServerlessSparkUtil.getWorkspaceBucket();
        String[] appResourceFileName = appResource.split("/");
        if (bucket != null) {
            String key = serverlessSparkConnection.getWorkspaceId() + "/tmp/" + clientToken + "/" + appResourceFileName[appResourceFileName.length - 1];
            if (isDw.booleanValue()) {
                key = ".dataworks/" + key;
            }
            LOGGER.info("start putting object to : " + bucket + ", key: " + key);
            ossClient.putObject(bucket, key, new File(appResource));
            LOGGER.info("success putting object to : " + bucket + ", key: " + key);
            appResource = "oss://" + bucket + "/" + key;
            userFiles.add(appResource);
        }
        return appResource;
    }

    public static void removeUserFiles() {
        String bucket = ServerlessSparkUtil.getWorkspaceBucket();
        for (String fileName : userFiles) {
            String key = fileName.replace("oss://" + bucket + "/", "");
            LOGGER.info("remove object from : " + bucket + ", key: " + key);
            try {
                ossClient.deleteObject(bucket, key);
            }
            catch (Exception e) {
                LOGGER.info("delete object error: " + e.getMessage());
            }
        }
    }

    private static String getDefaultQueue() {
        ListWorkspaceQueuesRequest listWorkspaceQueuesRequest = new ListWorkspaceQueuesRequest();
        listWorkspaceQueuesRequest.setEnvironment("dev");
        try {
            ListWorkspaceQueuesResponse listWorkspaceQueuesResponse = client.listWorkspaceQueues(serverlessSparkConnection.getWorkspaceId(), listWorkspaceQueuesRequest);
            if (!listWorkspaceQueuesResponse.getBody().getQueues().isEmpty()) {
                return listWorkspaceQueuesResponse.getBody().getQueues().get(0).getQueueName();
            }
        }
        catch (Exception e) {
            LOGGER.info(e.getMessage());
        }
        return null;
    }

    private static String getWorkspaceBucket() {
        ListWorkspacesRequest listWorkspacesRequest = new ListWorkspacesRequest();
        listWorkspacesRequest.setState("RUNNING");
        listWorkspacesRequest.setMaxResults(1000);
        try {
            String storage;
            List storageList = client.listWorkspaces(listWorkspacesRequest).getBody().getWorkspaces().stream().filter(item -> item.getWorkspaceId().equals(serverlessSparkConnection.getWorkspaceId())).map(ListWorkspacesResponseBody.ListWorkspacesResponseBodyWorkspaces::getStorage).collect(Collectors.toList());
            if (!storageList.isEmpty() && (storage = (String)storageList.get(0)).startsWith("oss://")) {
                storage = storage.replace("oss://", "");
                String bucket = storage.split("/")[0];
                return bucket.split("\\.")[0];
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public static String replaceInternalVariable(String sql) {
        for (Map.Entry<String, String> entry : internalVariableMapping.entrySet()) {
            Pattern p = Pattern.compile("\\$\\{\\s*" + entry.getKey() + "\\s*}");
            sql = p.matcher(sql).replaceAll(entry.getValue());
        }
        return sql;
    }

    private static void sendLauncherMessage(LauncherProtocol.Message message) {
        if (fromSparkLauncher.booleanValue()) {
            LOGGER.info("writing message to launcher: " + new Gson().toJson(message));
            try {
                out.writeObject(message);
            }
            catch (IOException e) {
                LOGGER.info("error writing message to launcher: " + e.getMessage());
            }
        }
    }

    static {
        returnCode = 0;
        fromSparkLauncher = false;
        isDw = false;
        needTermStates = new HashSet<String>(Arrays.asList("Success", "Failed", "Cancelled"));
        needPollStates = new HashSet<String>(Arrays.asList("Running", "Submitted", "Cancelling"));
        retryPolicy = ((RetryPolicyBuilder)RetryPolicy.builder().handle((Class<? extends Throwable>)((Class<Throwable>)Exception.class))).withMaxRetries(20).withBackoff(1L, 600L, ChronoUnit.SECONDS).build();
        startJobRunRetryPolicy = ((RetryPolicyBuilder)RetryPolicy.builder().handle((Class<? extends Throwable>)((Class<Throwable>)Exception.class))).withMaxRetries(3).withBackoff(1L, 10L, ChronoUnit.SECONDS).build();
        needTerm = false;
        userFiles = new ArrayList<String>();
        internalVariableMapping = new HashMap<String, String>();
    }
}

