# bwm-client


## 查询现在有的插件名称

### Step1: 执行命令
```shell
usage: plugin -query <query>
插件查询，类型（reader/writer/converter）

-query <query>   查询类型（reader/writer/converter）

@几漫
```
### Step2: 使用样例

```shell
sh ./bin/run.sh plugin -query reader
```

## 读取调度信息

### Step1: 配置变量
[${APP_HOME}/conf/read.json](../src/main/resource/conf/read.json)配置了每个步骤的额外命令行参数。
（可选）根据不同读插件修改
```json
{
  "schedule_datasource": {
    "name": "name",
    "type": "DolphinScheduler",
    "properties": {
      "endpoint": "http://<your-ip>:12345",
      "project": "FullTestProject",
      "token": "**************",
      "version": "1.3.9",
      "resourceDownload": false
    },
    "operaterType": "AUTO"
  },
  "conf": {

  }
}
```
其中的重要参数：
```
endpoint：服务器地址
project: 项目名称
token: 令牌
version: 版本号（请填全且确认无误）
operaterType: AUTO 从API获取; MANUAL 从文件获取;
resourceDownload: 是否下载文件资源本身
```
Reader插件支持批量拉取多project，以英文逗号分隔输入json，请勿输入空格，如：
```
project: "project1,project2"
```

### Step2: 执行命令
```shell
usage: read -c <conf> [-f <file>] -o <out> -t <type>
通过指定配置完成调度的解析和读取

 -c <conf>   配置文件
 -f <file>   （可选）原始文件
 -o <out>    输出文件名称及路径
 -t <type>   读插件类型

@几漫
```
### Step3: 使用样例

```shell
sh ./bin/run.sh read -c ./conf/read.json -o ./temp/out.zip -t dolphinv1-reader
sh ./bin/run.sh read -c ./conf/read.json -f ./temp/test.zip -o ./temp/out.zip -t hue-reader
```
运行成功后，命令行将提示打包输出文件
```
[main] INFO  c.a.m.w.m.c.file.BwmPackageFileOperator    writeFile:155 - zipped file: ./temp/out.zip
```
批量拉取多project时，-f -o参数请指定文件夹目录，强烈建议指定-f参数将原始文件保存在特定的地方。示例如下：
```
sh ./bin/run.sh read -c ./conf/read.json -f ./temp -o ./projects -t dolphinv1-reader
```

### Step4: 输出文件
输出文件包含两部分：
#### 全部原始信息：\<out>/data/project/\<workflows>
包括WorkflowProject、Workflow、WorkflowNode、FileResource、Function的全部信息。
#### 统计报表：\<out>/统计报表/\<.csv>
包括总体统计、workflow对象统计、node对象统计、file对象统计、function对象统计，以csv报表给出。

## 转换调度信息

### Step1: 配置变量
[${APP_HOME}/conf/transform.json](../src/main/resource/conf/transform.json)目录下有migrationx.json配置了每个步骤的命令行参数。

```json
{
  "conf": {
    "format": "SPEC",
    "locale": "zh_CN",
    "settings": {
      "workflow.converter.shellNodeType": "DIDE_SHELL",
      "workflow.converter.commandSqlAs": "DIDE_SHELL",
      "workflow.converter.sparkSubmitAs": "ODPS_SPARK",
      "workflow.converter.target.unknownNodeTypeAs": "DIDE_SHELL",
      "workflow.converter.mrNodeType": "ODPS_MR",
      "workflow.converter.target.engine.type": "MaxCompute",
      "workflow.converter.dolphinscheduler.sqlNodeTypeMapping": {
        "POSTGRESQL": "ODPS_SQL",
        "MYSQL": "ODPS_SQL",
        "HIVE": "ODPS_SQL"
      },
      "workflow.black.list": "",
      "workflow.di.resource.group": "",
      "workflow.resource.group": ""
    }
  },
  "source_schedule": {
    "name": "",
    "type": "",
    "api_endpoint": "http://localhost:8080",
    "api_token": "xxxx",
    "project_name": "test_project",
    "version": "v1.3.0",
    "version_type": "SPEC",
    "zip_file_path": "/tmp/test_project.zip"
  },
  "target_schedule": {
    "name": "",
    "type": "",
    "api_endpoint": "http://localhost:8080",
    "api_token": "xxxx",
    "project_name": "test_project",
    "version": "v1.3.0",
    "version_type": "SPEC",
    "zip_file_path": "/tmp/test_project.zip"
  }
}
```

### Step2: 执行命令
```shell
usage: convert -c <conf> [-f <file>] -o <out> -t <type>
通过指定配置完成调度的解析和读取

 -c <conf>   配置文件
 -f <file>   原始文件
 -o <out>    输出文件名称及路径
 -t <type>   读插件类型

@几漫
```

### Step3: 使用样例

```shell
sh run.sh convert -c conf/read.json -f /temp/test.zip -o /temp/out.zip -t dw-write
```

## 写入调度

### Step1: 配置变量
[${APP_HOME}/conf/write.json](../src/main/resource/conf/write.json)目录下有migrationx.json配置了每个步骤的命令行参数
可选）根据不同写插件修改
```json
{}
```

### Step2: 执行命令
```shell
usage: write -c <conf> [-f <file>] -o <out> -t <type>
通过指定配置完成调度的解析和读取

 -c <conf>   配置文件
 -f <file>   原始文件
 -o <out>    输出文件名称及路径
 -t <type>   读插件类型

@几漫
```
### Step3: 使用样例

```shell
sh run.sh  write -c conf/write.json -f /temp/test.zip -o /temp/out.zip -t dw-write
```