#!/bin/sh
bin=`dirname $0`
source $bin/common.sh
WORK_DIR=`pwd`
APP_NAME="BwmClientApp"
RUN_CLASS="com.aliyun.migration.client.BwmClientApp"
JVM_OPTION="--add-opens java.base/java.time=ALL-UNNAMED -Dfile.encoding=UTF-8 -Duser.timezone=Asia/Shanghai -Xms512m -Xmx1024m  -XX:+HeapDumpOnOutOfMemoryError -XX:HeapDumpPath=%s/log -Dlogback.configurationFile=conf/logback.xml"
NOW_TIME_LOG=$(date +'%Y%m%d%H%M%S').log

LANG=zh_CN.UTF-8

start()
{
	bin=`dirname $0`
	cd $bin/..
	init
	APPPATH=`pwd`
	CLASSPATH=$CLASSPATH:$APPPATH/lib/common/*:$APPPATH/lib/plugin/*:$APPPATH/conf/*
	java $JVM_OPTION -cp "$CLASSPATH" $RUN_CLASS  "$@"
  pid=$!
  wait $pid
  ret=$?
  [ $ret -eq 0 ] && echo "task success" || echo "task failed, exitCode=$ret"
}
start "$@"

# start "$@" | tee $NOW_TIME_LOG

cd $WORK_DIR

exit 0
