/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.utils;

import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.CycleType;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.quartz.ExtendedQuartzCronExpression;
import com.google.common.base.Joiner;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CronExpressUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(CronExpressUtil.class);
    private static final String WILDCARD_STAR = "*";
    private static final String WILDCARD_QUESTION_MARK = "?";
    private static final String SLASH = "/";
    private static final String DASH = "-";
    private static final String COMMA = ",";
    public static final String LAST_DAY_OF_MONTH = "L";
    private static final int MIN_PARTS_COUNT = 7;
    private static final List<Integer> NO_NEED_NORMALIZE = Arrays.asList(5, 3, 4);

    public static String quartzCronExpressionToDwCronExpress(String cronExpress) throws ParseException {
        int i;
        if (StringUtils.isBlank((CharSequence)cronExpress)) {
            return cronExpress;
        }
        String[] parts = StringUtils.split((String)cronExpress, (String)" \t");
        if (parts == null || parts.length < 7) {
            LOGGER.warn("invalid quartz cron part count: {}, {}", (Object)cronExpress, Optional.ofNullable(parts).map(p -> ((String[])p).length).orElse(null));
            return cronExpress;
        }
        ExtendedQuartzCronExpression cronExpression = new ExtendedQuartzCronExpression(cronExpress);
        ArrayList<String> dwCron = new ArrayList<String>();
        List<String> quartz = Arrays.asList(parts);
        for (i = 0; i < parts.length; ++i) {
            dwCron.add("");
        }
        for (i = 0; i < parts.length; ++i) {
            CronExpressUtil.processParts(i, quartz, cronExpression, dwCron);
        }
        return StringUtils.trim((String)Joiner.on((String)" ").join(dwCron));
    }

    private static void processParts(int partIndex, List<String> quartz, ExtendedQuartzCronExpression cronExpression, List<String> dwCron) {
        switch (partIndex) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                CronExpressUtil.processCommonPart(partIndex, quartz, cronExpression, dwCron);
                break;
            }
            case 3: {
                CronExpressUtil.processDayOfMonth(partIndex, quartz, cronExpression, dwCron);
                break;
            }
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)WILDCARD_STAR, (CharSequence)dwCron.get(5))) {
            dwCron.set(5, WILDCARD_QUESTION_MARK);
        }
    }

    private static void processDayOfMonth(int partIndex, List<String> quartz, ExtendedQuartzCronExpression cronExpression, List<String> dwCron) {
        if (CronExpressUtil.isCommonExpr(partIndex, quartz)) {
            CronExpressUtil.processCommonPart(partIndex, quartz, cronExpression, dwCron);
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)WILDCARD_QUESTION_MARK, (CharSequence)quartz.get(partIndex))) {
            String dayOfWeek = quartz.get(5);
            LOGGER.info("dayOfWeek: {}", (Object)dayOfWeek);
            dwCron.set(partIndex, WILDCARD_QUESTION_MARK);
            CronExpressUtil.processTreeSetOfEnumeratedValues(5, dwCron, dwCron, cronExpression.getDaysOfWeek());
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)LAST_DAY_OF_MONTH, (CharSequence)quartz.get(partIndex))) {
            dwCron.set(partIndex, LAST_DAY_OF_MONTH);
        } else {
            LOGGER.warn("got dataworks unsupported cron expression part: {}, set as *", (Object)quartz.get(partIndex));
            dwCron.set(partIndex, WILDCARD_STAR);
        }
    }

    private static boolean isCommonExpr(int partIndex, List<String> quartz) {
        return StringUtils.equalsIgnoreCase((CharSequence)WILDCARD_STAR, (CharSequence)quartz.get(partIndex)) || StringUtils.indexOf((CharSequence)quartz.get(partIndex), (CharSequence)SLASH) >= 0 || StringUtils.indexOf((CharSequence)quartz.get(partIndex), (CharSequence)DASH) >= 0 || StringUtils.indexOf((CharSequence)quartz.get(partIndex), (CharSequence)COMMA) >= 0;
    }

    private static void processCommonPart(int partIndex, List<String> quartz, ExtendedQuartzCronExpression cronExpression, List<String> dwCron) {
        if (StringUtils.isNumeric((CharSequence)quartz.get(partIndex))) {
            dwCron.set(partIndex, CronExpressUtil.normalizePart(quartz.get(partIndex)));
            return;
        }
        TreeSet<Integer> set = new TreeSet();
        switch (partIndex) {
            case 0: {
                dwCron.set(partIndex, CronExpressUtil.normalizePart("0"));
                break;
            }
            case 1: {
                set = cronExpression.getMinutes();
                if (CronExpressUtil.isWildcard(quartz.get(partIndex))) {
                    dwCron.set(partIndex, "*/5");
                    break;
                }
                CronExpressUtil.processTreeSetOfEnumeratedValues(partIndex, quartz, dwCron, set, 5);
                break;
            }
            case 2: {
                if (!StringUtils.isNumeric((CharSequence)quartz.get(partIndex))) {
                    dwCron.set(1, CronExpressUtil.normalizePart("0"));
                }
                set = cronExpression.getHours();
                if (CronExpressUtil.isWildcard(quartz.get(partIndex))) {
                    dwCron.set(partIndex, "00-23/1");
                    break;
                }
                CronExpressUtil.processTreeSetOfEnumeratedValues(partIndex, quartz, dwCron, set);
                break;
            }
            case 4: {
                set = cronExpression.getMonths();
                if (CronExpressUtil.isWildcard(quartz.get(partIndex))) break;
                dwCron.set(2, CronExpressUtil.normalizePart("0"));
                CronExpressUtil.processTreeSetOfEnumeratedValues(3, quartz, dwCron, cronExpression.getDaysOfMonth());
                break;
            }
            case 5: {
                set = cronExpression.getDaysOfWeek();
                if (CronExpressUtil.isWildcard(quartz.get(partIndex))) break;
                dwCron.set(2, CronExpressUtil.normalizePart("0"));
                break;
            }
            case 3: {
                set = cronExpression.getDaysOfMonth();
                if (CronExpressUtil.isWildcard(quartz.get(partIndex))) break;
                dwCron.set(2, CronExpressUtil.normalizePart("0"));
                break;
            }
        }
        if (StringUtils.isBlank((CharSequence)dwCron.get(partIndex))) {
            if (CronExpressUtil.isWildcard(quartz.get(partIndex))) {
                dwCron.set(partIndex, WILDCARD_STAR);
            } else {
                CronExpressUtil.processTreeSetOfEnumeratedValues(partIndex, quartz, dwCron, set);
            }
        }
    }

    private static boolean isWildcard(String part) {
        return Stream.of(WILDCARD_STAR, WILDCARD_QUESTION_MARK).anyMatch(s -> StringUtils.equalsIgnoreCase((CharSequence)s, (CharSequence)part));
    }

    private static void processTreeSetOfEnumeratedValues(int partIndex, List<String> quartz, List<String> dwCron, TreeSet<Integer> set) {
        CronExpressUtil.processTreeSetOfEnumeratedValues(partIndex, quartz, dwCron, set, null);
    }

    private static void processTreeSetOfEnumeratedValues(int partIndex, List<String> quartz, List<String> dwCron, TreeSet<Integer> set, Integer minRate) {
        boolean fixRate = true;
        Iterator<Integer> itr = set.iterator();
        Integer last = null;
        Integer lastDelta = null;
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        do {
            int cur;
            if (min > (cur = itr.next().intValue())) {
                min = cur;
            }
            if (max < cur) {
                max = cur;
            }
            if (lastDelta != null && cur - last != lastDelta) {
                fixRate = false;
                break;
            }
            if (last != null) {
                lastDelta = cur - last;
            }
            last = cur;
        } while (itr.hasNext());
        if (!NO_NEED_NORMALIZE.contains(partIndex) && lastDelta != null && fixRate) {
            int finalLastDelta = lastDelta;
            dwCron.set(partIndex, CronExpressUtil.normalizePart(String.valueOf(min)) + DASH + CronExpressUtil.normalize(String.valueOf(max)) + SLASH + Optional.ofNullable(minRate).map(r -> Math.max(r, finalLastDelta)).orElse(lastDelta));
        } else {
            dwCron.set(partIndex, SetUtils.emptyIfNull(set).stream().filter(val -> (char)val.intValue() != 'c').filter(val -> (char)val.intValue() != 'b').map(val -> NO_NEED_NORMALIZE.contains(partIndex) ? Integer.toString(val) : CronExpressUtil.normalizePart(Integer.toString(val))).collect(Collectors.joining(COMMA)));
            if (StringUtils.isBlank((CharSequence)dwCron.get(partIndex))) {
                LOGGER.warn("got dataworks unsupported cron expression part: {}", (Object)quartz.get(partIndex));
                dwCron.set(partIndex, WILDCARD_QUESTION_MARK);
            }
        }
    }

    public static String normalize(String cronExpress) {
        if (StringUtils.isBlank((CharSequence)cronExpress)) {
            return cronExpress;
        }
        Object[] parts = StringUtils.split((String)cronExpress, (String)" ");
        if (parts == null || parts.length <= 0) {
            return cronExpress;
        }
        for (int i = 0; i < Math.min(3, parts.length); ++i) {
            String partStr = parts[i];
            try {
                parts[i] = CronExpressUtil.normalizePart(partStr);
                continue;
            }
            catch (Exception e) {
                LOGGER.warn("normalize part error: ", (Throwable)e);
            }
        }
        return Joiner.on((String)" ").join(parts);
    }

    private static String normalizePart(String part) {
        if (StringUtils.isNumeric((CharSequence)part)) {
            Integer value = Integer.valueOf(part);
            return String.format("%02d", value);
        }
        if (StringUtils.contains((CharSequence)part, (CharSequence)DASH)) {
            String[] parts = StringUtils.split((String)part, (String)DASH);
            if (parts == null || parts.length < 2) {
                return part;
            }
            Integer partFrom = Integer.valueOf(parts[0]);
            Integer partTo = null;
            Integer partInterval = null;
            if (StringUtils.contains((CharSequence)parts[1], (CharSequence)SLASH)) {
                String[] moreParts = StringUtils.split((String)parts[1], (String)SLASH);
                if (moreParts == null || moreParts.length < 2) {
                    return part;
                }
                partTo = Integer.valueOf(moreParts[0]);
                partInterval = Integer.valueOf(moreParts[1]);
                return String.format("%02d-%02d/%d", partFrom, partTo, partInterval);
            }
            partTo = Integer.valueOf(parts[1]);
            return String.format("%02d-%02d", partFrom, partTo);
        }
        return part;
    }

    public static Integer parseCronToCycleType(String cronExpression) {
        if (StringUtils.isBlank((CharSequence)cronExpression) || "day".equalsIgnoreCase(cronExpression)) {
            return CycleType.DAY.getCode();
        }
        try {
            String[] cronExp = cronExpression.split("\\s+");
            String pattern = "[-/,*]";
            Pattern regex = Pattern.compile(pattern);
            String minute = cronExp[1];
            String hour = cronExp[2];
            Matcher matchM = regex.matcher(minute);
            Matcher matchH = regex.matcher(hour);
            if (matchM.find() || matchH.find()) {
                return CycleType.NOT_DAY.getCode();
            }
            return CycleType.DAY.getCode();
        }
        catch (Exception e) {
            return CycleType.DAY.getCode();
        }
    }
}

