/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.service.spec;

import com.alibaba.fastjson.JSON;
import com.aliyun.dataworks.common.spec.domain.DataWorksWorkflowSpec;
import com.aliyun.dataworks.common.spec.domain.Spec;
import com.aliyun.dataworks.common.spec.domain.Specification;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.enums.SpecKind;
import com.aliyun.dataworks.common.spec.domain.enums.SpecStorageType;
import com.aliyun.dataworks.common.spec.domain.enums.SpecVersion;
import com.aliyun.dataworks.common.spec.domain.ref.SpecDatasource;
import com.aliyun.dataworks.common.spec.domain.ref.SpecFileResource;
import com.aliyun.dataworks.common.spec.domain.ref.SpecRuntimeResource;
import com.aliyun.dataworks.common.spec.domain.ref.SpecScript;
import com.aliyun.dataworks.common.spec.domain.ref.file.SpecObjectStorageFile;
import com.aliyun.dataworks.common.spec.domain.ref.runtime.SpecScriptRuntime;
import com.aliyun.dataworks.migrationx.domain.dataworks.service.spec.entity.DwNodeEntity;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.SpecFileResourceTypeUtils;
import com.aliyun.migrationx.common.utils.UuidUtils;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceSpecUpdateAdapter {
    private static final Logger log = LoggerFactory.getLogger(ResourceSpecUpdateAdapter.class);

    public void updateSpecification(DwNodeEntity dwNode, Specification<DataWorksWorkflowSpec> specification) {
        specification.setVersion(SpecVersion.V_1_1_0.getLabel());
        specification.setKind(SpecKind.RESOURCE.getLabel());
        Map metadata = (Map)ObjectUtils.defaultIfNull((Object)specification.getMetadata(), new LinkedHashMap());
        Optional.ofNullable(dwNode.getOwner()).ifPresent(owner -> metadata.put("owner", owner));
        Optional.ofNullable(dwNode.getUuid()).ifPresent(uuid -> metadata.put("uuid", uuid));
        Optional.ofNullable(dwNode.getParentId()).ifPresent(containerId -> metadata.put("containerId", String.valueOf(containerId)));
        specification.setMetadata(metadata);
        DataWorksWorkflowSpec spec = (DataWorksWorkflowSpec)ObjectUtils.defaultIfNull((Object)((DataWorksWorkflowSpec)specification.getSpec()), (Object)new DataWorksWorkflowSpec());
        Optional.ofNullable(dwNode.getBizId()).filter(id -> id > 0L).map(String::valueOf).ifPresent(arg_0 -> ((DataWorksWorkflowSpec)spec).setId(arg_0));
        Optional.ofNullable(dwNode.getBizName()).ifPresent(arg_0 -> ((DataWorksWorkflowSpec)spec).setName(arg_0));
        specification.setSpec((Spec)spec);
        SpecFileResource specFileResource = ListUtils.emptyIfNull((List)spec.getFileResources()).stream().findFirst().orElseGet(SpecFileResource::new);
        spec.setFileResources(Collections.singletonList(specFileResource));
        this.fillSpecFileResource(dwNode, specFileResource);
        log.info("specification: {}", (Object)JSON.toJSONString(specification));
    }

    private void fillSpecFileResource(DwNodeEntity dwNode, SpecFileResource specFileResource) {
        SpecScript script = (SpecScript)ObjectUtils.defaultIfNull((Object)specFileResource.getScript(), (Object)new SpecScript());
        specFileResource.setScript(script);
        this.fillSpecFileResourceBasicInfo(dwNode, specFileResource);
        this.fillSpecScript(dwNode, script, specFileResource);
        this.fillResourceGroup(dwNode, specFileResource);
        this.fillDatasource(dwNode, specFileResource);
        this.fillFile(dwNode, specFileResource);
    }

    private void fillSpecFileResourceBasicInfo(DwNodeEntity dwNode, SpecFileResource specFileResource) {
        String id = Optional.ofNullable(dwNode.getUuid()).orElseGet(UuidUtils::genUuidWithoutHorizontalLine);
        specFileResource.setId(id);
        Optional.ofNullable(dwNode.getName()).ifPresent(arg_0 -> ((SpecFileResource)specFileResource).setName(arg_0));
        specFileResource.setType(SpecFileResourceTypeUtils.getResourceTypeBySuffix(specFileResource.getName()));
    }

    private void fillSpecScript(DwNodeEntity dwNode, SpecScript script, SpecFileResource specFileResource) {
        Optional.ofNullable(dwNode.getFolder()).map(path -> FilenameUtils.concat((String)path, (String)specFileResource.getName())).ifPresent(arg_0 -> ((SpecScript)script).setPath(arg_0));
        if (script.getPath() == null || !StringUtils.equals((CharSequence)FilenameUtils.getName((String)script.getPath()), (CharSequence)specFileResource.getName())) {
            String parentPath = FilenameUtils.getFullPathNoEndSeparator((String)script.getPath());
            script.setPath(FilenameUtils.concat((String)parentPath, (String)specFileResource.getName()));
        }
        Optional.ofNullable(dwNode.getCode()).ifPresent(arg_0 -> ((SpecScript)script).setContent(arg_0));
        this.fillSpecScriptRuntime(dwNode, script);
    }

    private void fillSpecScriptRuntime(DwNodeEntity dwNode, SpecScript script) {
        SpecScriptRuntime runtime = (SpecScriptRuntime)ObjectUtils.defaultIfNull((Object)script.getRuntime(), (Object)new SpecScriptRuntime());
        script.setRuntime(runtime);
        Optional.ofNullable(dwNode.getType()).map(CodeProgramType::getNodeTypeByName).ifPresent(codeProgramType -> {
            runtime.setCommand(codeProgramType.name());
            runtime.setEngine(codeProgramType.getCalcEngineType().getLabel());
        });
        Optional.ofNullable(dwNode.getTypeId()).ifPresent(arg_0 -> ((SpecScriptRuntime)runtime).setCommandTypeId(arg_0));
        Optional.ofNullable(dwNode.getCu()).ifPresent(arg_0 -> ((SpecScriptRuntime)runtime).setCu(arg_0));
    }

    private void fillResourceGroup(DwNodeEntity dwNode, SpecFileResource specFileResource) {
        if (StringUtils.isNotBlank((CharSequence)dwNode.getResourceGroup())) {
            SpecRuntimeResource specRuntimeResource = new SpecRuntimeResource();
            specRuntimeResource.setResourceGroup(dwNode.getResourceGroup());
            specFileResource.setRuntimeResource(specRuntimeResource);
        }
    }

    private void fillDatasource(DwNodeEntity dwNode, SpecFileResource specFileResource) {
        if (StringUtils.isNotBlank((CharSequence)dwNode.getConnection())) {
            SpecDatasource specDatasource = new SpecDatasource();
            specDatasource.setName(dwNode.getConnection());
            specFileResource.setDatasource(specDatasource);
        }
    }

    private void fillFile(DwNodeEntity dwNode, SpecFileResource specFileResource) {
        specFileResource.setFile(SpecObjectStorageFile.newInstanceOf((SpecStorageType)SpecStorageType.LOCAL));
        Optional.ofNullable(dwNode.getStorageUri()).ifPresent(arg_0 -> ((SpecObjectStorageFile)specFileResource.getFile()).setPath(arg_0));
    }
}

