/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.service.spec;

import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.dataworks.common.spec.adapter.SpecAdapter;
import com.aliyun.dataworks.common.spec.adapter.SpecHandlerContext;
import com.aliyun.dataworks.common.spec.domain.DataWorksWorkflowSpec;
import com.aliyun.dataworks.common.spec.domain.Spec;
import com.aliyun.dataworks.common.spec.domain.Specification;
import com.aliyun.dataworks.common.spec.domain.enums.ArtifactType;
import com.aliyun.dataworks.common.spec.domain.enums.DependencyType;
import com.aliyun.dataworks.common.spec.domain.enums.SpecFileResourceType;
import com.aliyun.dataworks.common.spec.domain.enums.SpecKind;
import com.aliyun.dataworks.common.spec.domain.enums.SpecVersion;
import com.aliyun.dataworks.common.spec.domain.interfaces.LabelEnum;
import com.aliyun.dataworks.common.spec.domain.noref.SpecDepend;
import com.aliyun.dataworks.common.spec.domain.noref.SpecFlowDepend;
import com.aliyun.dataworks.common.spec.domain.ref.SpecFileResource;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNodeOutput;
import com.aliyun.dataworks.common.spec.domain.ref.SpecScript;
import com.aliyun.dataworks.common.spec.domain.ref.runtime.SpecScriptRuntime;
import com.aliyun.dataworks.common.spec.writer.SpecWriterContext;
import com.aliyun.dataworks.common.spec.writer.WriterFactory;
import com.aliyun.dataworks.common.spec.writer.impl.SpecificationWriter;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Resource;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.DependentType;
import com.aliyun.dataworks.migrationx.domain.dataworks.service.spec.entity.DwNodeEntity;
import com.aliyun.dataworks.migrationx.domain.dataworks.service.spec.handler.BasicNodeSpecHandler;
import com.aliyun.dataworks.migrationx.domain.dataworks.service.spec.handler.ComponentSpecHandler;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.lang3.StringUtils;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeSpecAdapter
extends SpecAdapter<DwNodeEntity, SpecNode> {
    private static final Logger log = LoggerFactory.getLogger(NodeSpecAdapter.class);

    public NodeSpecAdapter() {
        this.registerHandlers();
        this.setDefaultHandler(BasicNodeSpecHandler.class);
    }

    private void registerHandlers() {
        Reflections reflections = new Reflections(BasicNodeSpecHandler.class.getPackage().getName(), new Scanner[0]);
        Set handlerClasses = reflections.getSubTypesOf(BasicNodeSpecHandler.class);
        SetUtils.emptyIfNull((Set)handlerClasses).stream().filter(h -> !h.equals(BasicNodeSpecHandler.class)).forEach(arg_0 -> ((NodeSpecAdapter)this).registerHandler(arg_0));
    }

    public String getNodeSpec(DwNodeEntity dmNodeBO, SpecHandlerContext context) {
        context.setSpecAdapter((SpecAdapter)this);
        SpecWriterContext specWriterContext = new SpecWriterContext();
        SpecificationWriter writer = (SpecificationWriter)WriterFactory.getWriter(Specification.class, (SpecWriterContext)specWriterContext);
        return writer.write(this.getNodeSpecObject(dmNodeBO, context), specWriterContext).toJSONString(new JSONWriter.Feature[]{JSONWriter.Feature.PrettyFormat});
    }

    public Specification<DataWorksWorkflowSpec> getNodeSpecObject(DwNodeEntity dwNode, SpecHandlerContext context) {
        Preconditions.checkNotNull((Object)dwNode, (Object)"node is null");
        context.setSpecAdapter((SpecAdapter)this);
        Specification spec = new Specification();
        DataWorksWorkflowSpec dataWorksWorkflowSpec = new DataWorksWorkflowSpec();
        spec.setVersion(SpecVersion.V_1_1_0.getLabel());
        spec.setKind(Optional.ofNullable(dwNode.getNodeUseType()).map(useType -> {
            switch (useType) {
                case MANUAL: {
                    return SpecKind.MANUAL_NODE.getLabel();
                }
                case MANUAL_WORKFLOW: {
                    dataWorksWorkflowSpec.setId((String)Optional.ofNullable(dwNode.getBizId()).filter(id -> id > 0L).map(String::valueOf).orElse(null));
                    dataWorksWorkflowSpec.setName(dwNode.getBizName());
                    return StringUtils.isBlank((CharSequence)dataWorksWorkflowSpec.getId()) ? SpecKind.MANUAL_NODE.getLabel() : SpecKind.MANUAL_WORKFLOW.getLabel();
                }
                case COMPONENT: {
                    return SpecKind.COMPONENT.getLabel();
                }
            }
            return SpecKind.CYCLE_WORKFLOW.getLabel();
        }).orElse(SpecKind.CYCLE_WORKFLOW.getLabel()));
        LinkedHashMap<String, String> metadata = new LinkedHashMap<String, String>();
        metadata.put("owner", dwNode.getOwner());
        spec.setMetadata(metadata);
        spec.setSpec((Spec)dataWorksWorkflowSpec);
        Optional.ofNullable(spec.getKind()).map(kind -> (SpecKind)LabelEnum.getByLabel(SpecKind.class, (String)kind)).ifPresent(kind -> {
            if (kind == SpecKind.COMPONENT) {
                ComponentSpecHandler handler = new ComponentSpecHandler();
                ArrayList nodes = new ArrayList();
                Optional.ofNullable(handler.handle(dwNode)).ifPresent(nodes::add);
                dataWorksWorkflowSpec.setComponents(nodes);
            } else {
                BasicNodeSpecHandler nodeSpecHandler = (BasicNodeSpecHandler)this.getHandler(dwNode, context.getLocale());
                nodeSpecHandler.setContext(context);
                if (dwNode.getParentNode() == null) {
                    dataWorksWorkflowSpec.setFlow(this.toFlow(nodeSpecHandler, dwNode, context));
                    ArrayList nodes = new ArrayList();
                    Optional.ofNullable(nodeSpecHandler.handle(dwNode)).ifPresent(nodes::add);
                    dataWorksWorkflowSpec.setNodes(nodes);
                } else {
                    BasicNodeSpecHandler parentNodeHandler = (BasicNodeSpecHandler)this.getHandler(dwNode.getParentNode(), context.getLocale());
                    dataWorksWorkflowSpec.setFlow(this.toFlow(parentNodeHandler, dwNode.getParentNode(), context));
                    ArrayList nodes = new ArrayList();
                    Optional.ofNullable((SpecNode)parentNodeHandler.handle(dwNode.getParentNode(), Collections.singletonList(dwNode))).ifPresent(nodes::add);
                    dataWorksWorkflowSpec.setNodes(nodes);
                }
            }
        });
        return spec;
    }

    public Specification<DataWorksWorkflowSpec> getResourceSpecObject(Resource resource, SpecHandlerContext context) {
        Specification spec = new Specification();
        spec.setVersion(SpecVersion.V_1_1_0.getLabel());
        spec.setKind(SpecKind.CYCLE_WORKFLOW.getLabel());
        LinkedHashMap metadata = new LinkedHashMap();
        spec.setMetadata(metadata);
        DataWorksWorkflowSpec dataWorksWorkflowSpec = new DataWorksWorkflowSpec();
        spec.setSpec((Spec)dataWorksWorkflowSpec);
        ArrayList<SpecFileResource> fileResources = new ArrayList<SpecFileResource>();
        SpecFileResource fileResource = new SpecFileResource();
        fileResource.setName(resource.getName());
        SpecScript specScript = new SpecScript();
        if (resource.getFolder() != null) {
            String path = Joiner.on((String)File.separator).join((Object)resource.getFolder(), (Object)resource.getName(), new Object[0]);
            specScript.setPath(path);
        } else {
            specScript.setPath(resource.getName());
        }
        SpecScriptRuntime runtime = new SpecScriptRuntime();
        runtime.setCommand(resource.getType());
        specScript.setRuntime(runtime);
        fileResource.setScript(specScript);
        fileResource.setType(SpecFileResourceType.valueOf((String)resource.getExtend()));
        fileResources.add(fileResource);
        dataWorksWorkflowSpec.setFileResources(fileResources);
        return spec;
    }

    public List<SpecFlowDepend> toFlow(BasicNodeSpecHandler handler, DwNodeEntity dmNodeBo, SpecHandlerContext context) {
        if (dmNodeBo == null) {
            return ListUtils.emptyIfNull(null);
        }
        SpecFlowDepend flowDepend = new SpecFlowDepend();
        SpecNode nodeId = new SpecNode();
        nodeId.setId(dmNodeBo.getUuid());
        flowDepend.setNodeId(nodeId);
        List inputs = handler.getNodeInputs(dmNodeBo);
        flowDepend.setDepends(ListUtils.emptyIfNull(inputs).stream().map(in -> (SpecNodeOutput)in).map(dep -> {
            SpecDepend specDepend = new SpecDepend();
            specDepend.setType(DependencyType.NORMAL);
            SpecNodeOutput art = new SpecNodeOutput();
            art.setData(dep.getData());
            art.setArtifactType(ArtifactType.NODE_OUTPUT);
            art.setRefTableName(dep.getRefTableName());
            art.setSourceType(dep.getSourceType());
            specDepend.setOutput(art);
            specDepend.setSourceType(dep.getSourceType());
            return specDepend;
        }).collect(Collectors.toList()));
        if (Stream.of(DependentType.USER_DEFINE, DependentType.USER_DEFINE_AND_SELF).anyMatch(dt -> Objects.equals(dmNodeBo.getDependentType(), dt.getValue()) && StringUtils.isNotBlank((CharSequence)dmNodeBo.getDependentDataNode()))) {
            ((List)Optional.ofNullable(StringUtils.split((String)dmNodeBo.getDependentDataNode(), (String)",")).map(Arrays::asList).orElse(new ArrayList())).stream().map(out -> {
                SpecDepend specDepend = new SpecDepend();
                specDepend.setType(DependencyType.CROSS_CYCLE_OTHER_NODE);
                SpecNodeOutput art = new SpecNodeOutput();
                art.setData(out);
                art.setArtifactType(ArtifactType.NODE_OUTPUT);
                specDepend.setSourceType(art.getSourceType());
                specDepend.setOutput(art);
                return specDepend;
            }).forEach(sp -> flowDepend.getDepends().add(sp));
        }
        if (Stream.of(DependentType.SELF, DependentType.USER_DEFINE_AND_SELF, DependentType.CHILD_AND_SELF).anyMatch(dt -> Objects.equals(dt.getValue(), dmNodeBo.getDependentType()))) {
            SpecDepend specDepend = new SpecDepend();
            specDepend.setType(DependencyType.CROSS_CYCLE_SELF);
            specDepend.setNodeId(nodeId);
            flowDepend.getDepends().add(specDepend);
            if (Objects.equals(DependentType.CHILD_AND_SELF.getValue(), dmNodeBo.getDependentType())) {
                SpecDepend sp2 = new SpecDepend();
                sp2.setType(DependencyType.CROSS_CYCLE_CHILDREN);
                sp2.setNodeId(nodeId);
                flowDepend.getDepends().add(sp2);
            }
        }
        if (CollectionUtils.isEmpty((Collection)flowDepend.getDepends())) {
            return ListUtils.emptyIfNull(null);
        }
        return Collections.singletonList(flowDepend);
    }
}

