/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.service.openapi;

import com.aliyun.dataworks_public20240518.Client;
import com.aliyun.dataworks_public20240518.models.CreateNodeRequest;
import com.aliyun.dataworks_public20240518.models.CreateNodeResponse;
import com.aliyun.dataworks_public20240518.models.CreateNodeResponseBody;
import com.aliyun.dataworks_public20240518.models.CreateWorkflowDefinitionRequest;
import com.aliyun.dataworks_public20240518.models.CreateWorkflowDefinitionResponse;
import com.aliyun.dataworks_public20240518.models.CreateWorkflowDefinitionResponseBody;
import com.aliyun.dataworks_public20240518.models.GetJobStatusRequest;
import com.aliyun.dataworks_public20240518.models.GetJobStatusResponse;
import com.aliyun.dataworks_public20240518.models.GetJobStatusResponseBody;
import com.aliyun.dataworks_public20240518.models.GetNodeRequest;
import com.aliyun.dataworks_public20240518.models.GetNodeResponse;
import com.aliyun.dataworks_public20240518.models.GetNodeResponseBody;
import com.aliyun.dataworks_public20240518.models.GetWorkflowDefinitionRequest;
import com.aliyun.dataworks_public20240518.models.GetWorkflowDefinitionResponse;
import com.aliyun.dataworks_public20240518.models.GetWorkflowDefinitionResponseBody;
import com.aliyun.dataworks_public20240518.models.ImportWorkflowDefinitionRequest;
import com.aliyun.dataworks_public20240518.models.ImportWorkflowDefinitionResponse;
import com.aliyun.dataworks_public20240518.models.ImportWorkflowDefinitionResponseBody;
import com.aliyun.dataworks_public20240518.models.ListNodeDependenciesRequest;
import com.aliyun.dataworks_public20240518.models.ListNodeDependenciesResponse;
import com.aliyun.dataworks_public20240518.models.ListNodeDependenciesResponseBody;
import com.aliyun.dataworks_public20240518.models.ListWorkflowDefinitionsRequest;
import com.aliyun.dataworks_public20240518.models.ListWorkflowDefinitionsResponse;
import com.aliyun.dataworks_public20240518.models.ListWorkflowDefinitionsResponseBody;
import com.aliyun.dataworks_public20240518.models.UpdateNodeRequest;
import com.aliyun.dataworks_public20240518.models.UpdateNodeResponse;
import com.aliyun.dataworks_public20240518.models.UpdateNodeResponseBody;
import com.aliyun.dataworks_public20240518.models.UpdateWorkflowDefinitionRequest;
import com.aliyun.dataworks_public20240518.models.UpdateWorkflowDefinitionResponse;
import com.aliyun.dataworks_public20240518.models.UpdateWorkflowDefinitionResponseBody;
import com.aliyun.migrationx.common.utils.JSONUtils;
import com.aliyun.teaopenapi.models.Config;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataWorksOpenApiService {
    private static final Logger log = LoggerFactory.getLogger(DataWorksOpenApiService.class);
    private static final String SYSTEM_ENV_ACCESS_KEY_ID = "ALIBABA_CLOUD_ACCESS_KEY_ID";
    private static final String SYSTEM_ENV_ACCESS_KEY_SECRET = "ALIBABA_CLOUD_ACCESS_KEY_SECRET";
    private static final int SUCCESS_STATUS = 200;
    private static final String endpoint = "dataworks.%s.aliyuncs.com";
    private final String regionId;
    private final String projectId;
    private final String accessKeyId;
    private final String accessKeySecret;
    private Client client;
    private boolean initialized;

    public DataWorksOpenApiService(String region, String projectId, String accessKeyId, String accessKeySecret) {
        if (StringUtils.isBlank((CharSequence)region) || StringUtils.isBlank((CharSequence)projectId)) {
            throw new RuntimeException("region or projectId is blank");
        }
        this.projectId = projectId;
        this.regionId = region;
        this.accessKeyId = Optional.ofNullable(accessKeyId).orElseGet(() -> System.getenv(SYSTEM_ENV_ACCESS_KEY_ID));
        this.accessKeySecret = Optional.ofNullable(accessKeySecret).orElseGet(() -> System.getenv(SYSTEM_ENV_ACCESS_KEY_SECRET));
        this.initClient();
    }

    public boolean initClient() {
        if (this.initialized) {
            return true;
        }
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{this.projectId, this.accessKeyId, this.accessKeySecret})) {
            throw new RuntimeException("endpoint or projectId or accessKeyId or accessKeySecret is blank");
        }
        Config config = new Config().setAccessKeyId(this.accessKeyId).setAccessKeySecret(this.accessKeySecret).setEndpoint(String.format(endpoint, this.regionId)).setRegionId(this.regionId);
        try {
            this.client = new Client(config);
            this.initialized = true;
        }
        catch (Exception e) {
            log.error("init dataworks client failed", (Throwable)e);
            return false;
        }
        return true;
    }

    private void checkInit() {
        if (!this.initialized && !this.initClient()) {
            throw new RuntimeException("dataworks client is not initialized");
        }
    }

    public String saveNode(String projectId, String scene, String uuid, String containerId, String spec) {
        if (this.nodeExist(projectId, uuid)) {
            UpdateNodeRequest updateNodeRequest = new UpdateNodeRequest().setProjectId(projectId).setId(uuid).setSpec(spec);
            return this.updateNode(updateNodeRequest) ? uuid : null;
        }
        CreateNodeRequest createNodeRequest = new CreateNodeRequest().setProjectId(projectId).setScene(scene).setContainerId(containerId).setSpec(spec);
        return this.createNode(createNodeRequest);
    }

    public String saveWorkflow(String projectId, String uuid, String spec) {
        if (this.workflowExist(projectId, uuid)) {
            UpdateWorkflowDefinitionRequest request = new UpdateWorkflowDefinitionRequest().setProjectId(projectId).setId(uuid).setSpec(spec);
            return this.updateWorkflow(request) ? uuid : null;
        }
        CreateWorkflowDefinitionRequest request = new CreateWorkflowDefinitionRequest().setProjectId(projectId).setSpec(spec);
        return this.createWorkflow(request);
    }

    public String importWorkflow(String projectId, String spec) {
        ImportWorkflowDefinitionResponse response;
        this.checkInit();
        ImportWorkflowDefinitionRequest importWorkflowDefinitionRequest = new ImportWorkflowDefinitionRequest().setProjectId(projectId).setSpec(spec);
        log.info("import flow request: {}", (Object)importWorkflowDefinitionRequest);
        try {
            response = this.client.importWorkflowDefinition(importWorkflowDefinitionRequest);
        }
        catch (Exception e) {
            log.error("import flow failed", (Throwable)e);
            throw new RuntimeException(e);
        }
        if (response == null) {
            throw new RuntimeException("response is null");
        }
        if (response.getStatusCode() != null && 200 != response.getStatusCode()) {
            log.error("import flow failed, requestId: {}", (Object)response.getBody().getRequestId());
            throw new RuntimeException("import flow failed");
        }
        log.info("import flow async job submit success, response: {}", (Object)JSONUtils.toJsonString((Object)response));
        return Optional.of(response).map(ImportWorkflowDefinitionResponse::getBody).map(ImportWorkflowDefinitionResponseBody::getAsyncJob).map(ImportWorkflowDefinitionResponseBody.ImportWorkflowDefinitionResponseBodyAsyncJob::getId).orElse(null);
    }

    public GetJobStatusResponseBody.GetJobStatusResponseBodyJobStatus getAsyncJob(String jobId) {
        GetJobStatusResponse response;
        this.checkInit();
        GetJobStatusRequest getJobStatusRequest = new GetJobStatusRequest().setJobId(jobId);
        log.info("get async job request: {}", (Object)getJobStatusRequest);
        try {
            response = this.client.getJobStatus(getJobStatusRequest);
        }
        catch (Exception e) {
            log.error("get async job failed", (Throwable)e);
            throw new RuntimeException(e);
        }
        if (response == null) {
            throw new RuntimeException("response is null");
        }
        if (response.getStatusCode() != null && 200 != response.getStatusCode()) {
            log.error("get async job failed, requestId: {}", (Object)response.getBody().getRequestId());
            throw new RuntimeException("get async job failed");
        }
        log.info("get async job success, response: {}", (Object)JSONUtils.toJsonString((Object)response));
        return Optional.of(response).map(GetJobStatusResponse::getBody).map(GetJobStatusResponseBody::getJobStatus).orElse(null);
    }

    public String createNode(CreateNodeRequest createNodeRequest) {
        CreateNodeResponse response;
        this.checkInit();
        log.info("create node request: {}", (Object)createNodeRequest);
        try {
            response = this.client.createNode(createNodeRequest);
        }
        catch (Exception e) {
            log.error("create node failed", (Throwable)e);
            throw new RuntimeException(e);
        }
        if (response == null) {
            throw new RuntimeException("response is null");
        }
        if (response.getStatusCode() != null && 200 != response.getStatusCode()) {
            log.error("create node failed, requestId: {}", (Object)response.getBody().getRequestId());
            throw new RuntimeException("create node failed");
        }
        log.info("create node success, response: {}", (Object)JSONUtils.toJsonString((Object)response));
        return Optional.of(response).map(CreateNodeResponse::getBody).map(CreateNodeResponseBody::getId).orElse(null);
    }

    public boolean updateNode(UpdateNodeRequest updateNodeRequest) {
        UpdateNodeResponse response;
        this.checkInit();
        log.info("update node request: {}", (Object)updateNodeRequest);
        try {
            response = this.client.updateNode(updateNodeRequest);
        }
        catch (Exception e) {
            log.error("update node failed", (Throwable)e);
            throw new RuntimeException(e);
        }
        if (response == null) {
            throw new RuntimeException("response is null");
        }
        if (response.getStatusCode() != null && 200 != response.getStatusCode()) {
            log.error("update node failed, requestId: {}", (Object)response.getBody().getRequestId());
            return false;
        }
        log.info("update node success, response: {}", (Object)JSONUtils.toJsonString((Object)response));
        return Optional.of(response).map(UpdateNodeResponse::getBody).map(UpdateNodeResponseBody::getSuccess).orElse(false);
    }

    public String createWorkflow(CreateWorkflowDefinitionRequest request) {
        CreateWorkflowDefinitionResponse response;
        this.checkInit();
        log.info("create workflow request: {}", (Object)request);
        try {
            response = this.client.createWorkflowDefinition(request);
        }
        catch (Exception e) {
            log.error("create workflow failed", (Throwable)e);
            throw new RuntimeException(e);
        }
        if (response == null) {
            throw new RuntimeException("response is null");
        }
        if (response.getStatusCode() != null && 200 != response.getStatusCode()) {
            log.error("create workflow failed, requestId: {}", (Object)response.getBody().getRequestId());
            throw new RuntimeException("create workflow failed");
        }
        log.info("create workflow response: {}", (Object)JSONUtils.toJsonString((Object)response));
        return Optional.of(response).map(CreateWorkflowDefinitionResponse::getBody).map(CreateWorkflowDefinitionResponseBody::getId).orElse(null);
    }

    public boolean updateWorkflow(UpdateWorkflowDefinitionRequest request) {
        UpdateWorkflowDefinitionResponse response;
        this.checkInit();
        log.info("update workflow request: {}", (Object)request);
        try {
            response = this.client.updateWorkflowDefinition(request);
        }
        catch (Exception e) {
            log.error("update workflow failed", (Throwable)e);
            throw new RuntimeException(e);
        }
        if (response == null) {
            throw new RuntimeException("response is null");
        }
        if (response.getStatusCode() != null && 200 != response.getStatusCode()) {
            log.error("update workflow failed, requestId: {}", (Object)response.getBody().getRequestId());
            return false;
        }
        log.info("update workflow response: {}", (Object)JSONUtils.toJsonString((Object)response));
        return Optional.of(response).map(UpdateWorkflowDefinitionResponse::getBody).map(UpdateWorkflowDefinitionResponseBody::getSuccess).orElse(false);
    }

    private boolean nodeExist(String projectId, String uuid) {
        return this.getNode(projectId, uuid) != null;
    }

    private boolean workflowExist(String projectId, String uuid) {
        return this.getWorkflow(projectId, uuid) != null;
    }

    public GetNodeResponseBody.GetNodeResponseBodyNode getNode(String projectId, String uuid) {
        GetNodeResponse response;
        if (StringUtils.isBlank((CharSequence)uuid)) {
            return null;
        }
        this.checkInit();
        GetNodeRequest request = new GetNodeRequest().setProjectId(projectId).setId(uuid);
        log.info("GetNodeRequest: {}", (Object)request);
        try {
            response = this.client.getNode(request);
        }
        catch (Exception e) {
            log.warn("get node failed", (Throwable)e);
            return null;
        }
        log.info("GetNodeResponse: {}", (Object)JSONUtils.toJsonString((Object)response));
        return Optional.ofNullable(response).map(GetNodeResponse::getBody).map(GetNodeResponseBody::getNode).orElse(null);
    }

    public GetWorkflowDefinitionResponseBody.GetWorkflowDefinitionResponseBodyWorkflowDefinition getWorkflow(String projectId, String uuid) {
        GetWorkflowDefinitionResponse response;
        if (StringUtils.isBlank((CharSequence)uuid)) {
            return null;
        }
        this.checkInit();
        GetWorkflowDefinitionRequest request = new GetWorkflowDefinitionRequest().setProjectId(projectId).setId(uuid);
        log.info("GetWorkflowDefinitionRequest: {}", (Object)request);
        try {
            response = this.client.getWorkflowDefinition(request);
        }
        catch (Exception e) {
            log.warn("get workflow failed", (Throwable)e);
            return null;
        }
        log.info("GetWorkflowDefinitionResponse: {}", (Object)JSONUtils.toJsonString((Object)response));
        return Optional.ofNullable(response).map(GetWorkflowDefinitionResponse::getBody).map(GetWorkflowDefinitionResponseBody::getWorkflowDefinition).orElse(null);
    }

    public ListWorkflowDefinitionsResponseBody.ListWorkflowDefinitionsResponseBodyPagingInfo listWorkflows(String projectId, Integer pageNumber, Integer pageSize) {
        ListWorkflowDefinitionsResponse response;
        this.checkInit();
        ListWorkflowDefinitionsRequest request = new ListWorkflowDefinitionsRequest().setProjectId(projectId).setPageNumber(pageNumber).setPageSize(pageSize);
        log.info("ListWorkflowDefinitionsRequest: {}", (Object)request);
        try {
            response = this.client.listWorkflowDefinitions(request);
        }
        catch (Exception e) {
            log.error("list workflow failed", (Throwable)e);
            return null;
        }
        log.info("ListWorkflowDefinitionsResponse: {}", (Object)JSONUtils.toJsonString((Object)response));
        return Optional.ofNullable(response).map(ListWorkflowDefinitionsResponse::getBody).map(ListWorkflowDefinitionsResponseBody::getPagingInfo).orElse(null);
    }

    public ListNodeDependenciesResponseBody.ListNodeDependenciesResponseBodyPagingInfo listNodeDependencies(String projectId, String uuid) {
        ListNodeDependenciesResponse response;
        if (StringUtils.isBlank((CharSequence)uuid)) {
            return null;
        }
        this.checkInit();
        ListNodeDependenciesRequest request = new ListNodeDependenciesRequest().setProjectId(projectId).setId(uuid);
        log.info("ListNodeDependenciesRequest: {}", (Object)request);
        try {
            response = this.client.listNodeDependencies(request);
        }
        catch (Exception e) {
            log.error("list node dependencies failed", (Throwable)e);
            return null;
        }
        log.info("ListNodeDependenciesResponse: {}", (Object)JSONUtils.toJsonString((Object)response));
        return Optional.ofNullable(response).map(ListNodeDependenciesResponse::getBody).map(ListNodeDependenciesResponseBody::getPagingInfo).orElse(null);
    }
}

