/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.api.constant.report;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.migration.api.constant.report.AbstractSheetProperties;
import com.aliyun.migration.api.constant.report.StatisticsReportConstant;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowTrigger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowSheetProperties
extends AbstractSheetProperties {
    private static final Logger log = LoggerFactory.getLogger(WorkflowSheetProperties.class);
    private Map<WorkflowSheetColumn, Integer> propertyIndexMap = new HashMap<WorkflowSheetColumn, Integer>();
    private Map<WorkflowSheetColumn, Object> propertyValueMap = new HashMap<WorkflowSheetColumn, Object>();

    public WorkflowSheetProperties() {
        for (WorkflowSheetColumn column : WorkflowSheetColumn.values()) {
            this.propertyIndexMap.put(column, column.ordinal());
            this.propertyValueMap.put(column, null);
        }
    }

    public WorkflowSheetProperties(List<String> propertyList) {
        for (int i = 0; i < propertyList.size(); ++i) {
            WorkflowSheetColumn column = WorkflowSheetColumn.of(propertyList.get(i));
            if (column == null) {
                log.warn("pass column: {}", (Object)propertyList.get(i));
                continue;
            }
            this.propertyIndexMap.put(column, i);
            this.propertyValueMap.put(column, null);
        }
    }

    public WorkflowSheetProperties(Map<String, Integer> propertyMap) {
        for (String columnName : propertyMap.keySet()) {
            WorkflowSheetColumn column = WorkflowSheetColumn.of(columnName);
            if (column == null) {
                log.warn("pass column: {}", (Object)columnName);
                continue;
            }
            this.propertyIndexMap.put(column, propertyMap.get(columnName));
            this.propertyValueMap.put(column, null);
        }
    }

    @Override
    public List<String> getHeadersForExcel() {
        return this.propertyIndexMap.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).filter(WorkflowSheetColumn::getIsForExcel).map(WorkflowSheetColumn::getDescription).collect(Collectors.toList());
    }

    @Override
    public List<Boolean> getColumnsCanModifyForExcel() {
        return this.propertyIndexMap.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).filter(WorkflowSheetColumn::getIsForExcel).map(WorkflowSheetColumn::getCanModify).collect(Collectors.toList());
    }

    @Override
    public List<String> getValuesForExcel() {
        ArrayList<String> values = new ArrayList<String>();
        this.propertyIndexMap.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).filter(WorkflowSheetColumn::getIsForExcel).forEach(property -> {
            if (ObjectUtils.isEmpty((Object)this.propertyValueMap.get(property))) {
                values.add("");
            } else {
                values.add(String.valueOf(this.propertyValueMap.get(property)));
            }
        });
        return values;
    }

    @Override
    protected JSONObject getValuesToJSON() {
        JSONObject jsonObject = new JSONObject();
        this.propertyValueMap.forEach((k, v) -> {
            if (k.getIsForSR().booleanValue()) {
                jsonObject.put((Object)k.name().toLowerCase(), v);
            }
        });
        return jsonObject;
    }

    public Object getPropertyValue(WorkflowSheetColumn column) {
        if (this.propertyValueMap.containsKey((Object)column) && !ObjectUtils.isEmpty((Object)this.propertyValueMap.get((Object)column))) {
            return this.propertyValueMap.get((Object)column);
        }
        return null;
    }

    public Boolean isPropertyValueValid(WorkflowSheetColumn column) {
        if (this.propertyValueMap.containsKey((Object)column) && !ObjectUtils.equals((Object)this.propertyValueMap.get((Object)column), (Object)StatisticsReportConstant.DO_NOT_MODIFY)) {
            return true;
        }
        return false;
    }

    public Boolean isPropertyValueValidNotNull(WorkflowSheetColumn column) {
        if (this.propertyValueMap.containsKey((Object)column) && !ObjectUtils.isEmpty((Object)this.propertyValueMap.get((Object)column)) && !ObjectUtils.equals((Object)this.propertyValueMap.get((Object)column), (Object)StatisticsReportConstant.DO_NOT_MODIFY)) {
            return true;
        }
        return false;
    }

    public void setPropertyValue(Map<WorkflowSheetColumn, Object> propertyValueMap) {
        this.propertyValueMap = propertyValueMap;
    }

    public void setPropertyValue(WorkflowSheetColumn column, Object value) {
        this.propertyValueMap.put(column, value);
    }

    public void setPropertyValue(Workflow wf) {
        StringBuilder crons = new StringBuilder();
        if (wf.getTriggers() != null) {
            for (WorkflowTrigger tg : wf.getTriggers()) {
                if (StringUtils.isEmpty((CharSequence)tg.getCron())) continue;
                crons.append(tg.getCron()).append(";");
            }
        }
        if (!StringUtils.isEmpty((CharSequence)crons)) {
            crons.deleteCharAt(crons.length() - 1);
        }
        String params = "{}";
        if (wf.getParamMap() != null) {
            params = JSONObject.toJSONString((Object)wf.getParamMap(), (JSONWriter.Feature[])new JSONWriter.Feature[0]);
        }
        this.setPropertyValue(WorkflowSheetColumn.PROJECT_ID, wf.getProjectId());
        this.setPropertyValue(WorkflowSheetColumn.WORKFLOW_ID, wf.getWorkflowId());
        this.setPropertyValue(WorkflowSheetColumn.IS_BUSSINESS, wf.getIsBusiness() == null ? false : wf.getIsBusiness());
        this.setPropertyValue(WorkflowSheetColumn.WORKFLOW_NAME, wf.getWorkflowName());
        this.setPropertyValue(WorkflowSheetColumn.TGT_WORKFLOW_ID, wf.getTWorkflowId());
        this.setPropertyValue(WorkflowSheetColumn.TGT_WORKFLOW_NAME, null);
        this.setPropertyValue(WorkflowSheetColumn.CATEGORY_VALUE, wf.getCategoryValue());
        this.setPropertyValue(WorkflowSheetColumn.OWNER, wf.getOwner());
        this.setPropertyValue(WorkflowSheetColumn.OWNER_TYPE, wf.getOwnerType());
        this.setPropertyValue(WorkflowSheetColumn.DESCRIPTION, wf.getDescription());
        this.setPropertyValue(WorkflowSheetColumn.PARAM, params);
        this.setPropertyValue(WorkflowSheetColumn.CRON, crons.toString());
        this.setPropertyValue(WorkflowSheetColumn.INSTANCE_MODE, wf.getCustomProperties() != null && wf.getCustomProperties().containsKey("instance.mode") ? wf.getCustomProperties().get("instance.mode") : null);
        this.setPropertyValue(WorkflowSheetColumn.NODE_COUNT, wf.getWorkflowNodes() != null ? wf.getWorkflowNodes().size() : 0);
        this.setPropertyValue(WorkflowSheetColumn.OFFLINE_STATE, wf.getCustomProperties() != null && wf.getCustomProperties().containsKey("online.pipeline.state") ? wf.getCustomProperties().get("online.pipeline.state") : null);
        this.setPropertyValue(WorkflowSheetColumn.SOURCE_ID, wf.getCustomProperties() != null && wf.getCustomProperties().containsKey("MigrationOriginalId") ? wf.getCustomProperties().get("MigrationOriginalId") : null);
    }

    public void setPropertyValue(List<String> propertyValueList) {
        for (WorkflowSheetColumn column : this.propertyIndexMap.keySet()) {
            Integer sheetIndex = this.propertyIndexMap.get((Object)column);
            if (sheetIndex >= propertyValueList.size()) {
                this.propertyValueMap.put(column, null);
                continue;
            }
            this.propertyValueMap.put(column, propertyValueList.get(sheetIndex));
        }
    }

    public void createWorkflowFromExcel(Workflow workflow) {
        workflow.setWorkflowId((String)this.getPropertyValue(WorkflowSheetColumn.WORKFLOW_ID));
        workflow.setWorkflowName((String)this.getPropertyValue(WorkflowSheetColumn.WORKFLOW_NAME));
        workflow.setCategoryValue((String)this.getPropertyValue(WorkflowSheetColumn.CATEGORY_VALUE));
        workflow.setTWorkflowId((String)this.getPropertyValue(WorkflowSheetColumn.TGT_WORKFLOW_ID));
        this.setWorkflowPropertyValueFromExcel(workflow);
    }

    public void setWorkflowPropertyValueFromExcel(Workflow workflow) {
        if (this.isPropertyValueValid(WorkflowSheetColumn.OWNER).booleanValue()) {
            workflow.setOwner((String)this.getPropertyValue(WorkflowSheetColumn.OWNER));
        }
        if (this.isPropertyValueValid(WorkflowSheetColumn.DESCRIPTION).booleanValue()) {
            workflow.setDescription((String)this.getPropertyValue(WorkflowSheetColumn.DESCRIPTION));
        }
        if (this.isPropertyValueValidNotNull(WorkflowSheetColumn.IS_BUSSINESS).booleanValue()) {
            workflow.setIsBusiness(Boolean.valueOf(StringUtils.equals((CharSequence)((String)this.getPropertyValue(WorkflowSheetColumn.IS_BUSSINESS)), (CharSequence)"true")));
        } else {
            workflow.setIsBusiness(Boolean.valueOf(false));
        }
        if (this.isPropertyValueValidNotNull(WorkflowSheetColumn.PARAM).booleanValue()) {
            workflow.setParamMap((Map)JSONObject.parseObject((String)((String)this.getPropertyValue(WorkflowSheetColumn.PARAM)), Map.class));
            try {
                JSONObject paramJsonObj = JSONObject.parseObject((String)((String)this.getPropertyValue(WorkflowSheetColumn.PARAM)));
                workflow.setParamMap(new HashMap());
                for (String k : paramJsonObj.keySet()) {
                    workflow.getParamMap().put(k, paramJsonObj.get(k));
                }
            }
            catch (Exception e) {
                log.warn("\u5de5\u4f5c\u6d41{}\u6b32\u66f4\u65b0Param\uff0c\u4f46\u83b7\u53d6\u5230\u975e\u6cd5\u503c:{}", (Object)(workflow.getWorkflowId() + workflow.getWorkflowName()), this.getPropertyValue(WorkflowSheetColumn.PARAM));
                workflow.setParamMap(null);
            }
        } else if (this.isPropertyValueValid(WorkflowSheetColumn.PARAM).booleanValue()) {
            workflow.setParamMap(null);
        }
        if (this.isPropertyValueValidNotNull(WorkflowSheetColumn.CRON).booleanValue()) {
            if (workflow.getTriggers() == null || workflow.getTriggers().size() == 0) {
                workflow.setTriggers(new ArrayList());
                workflow.getTriggers().add(new WorkflowTrigger());
            }
            ((WorkflowTrigger)workflow.getTriggers().get(0)).setCron((String)this.getPropertyValue(WorkflowSheetColumn.CRON));
        } else if (this.isPropertyValueValid(WorkflowSheetColumn.CRON).booleanValue() && workflow.getTriggers() != null && workflow.getTriggers().size() > 0) {
            ((WorkflowTrigger)workflow.getTriggers().get(0)).setCron(null);
        }
        if (this.isPropertyValueValidNotNull(WorkflowSheetColumn.INSTANCE_MODE).booleanValue()) {
            if (workflow.getCustomProperties() == null) {
                workflow.setCustomProperties(new HashMap());
            }
            workflow.getCustomProperties().put("instance.mode", this.getPropertyValue(WorkflowSheetColumn.INSTANCE_MODE));
        } else if (this.isPropertyValueValid(WorkflowSheetColumn.INSTANCE_MODE).booleanValue() && workflow.getCustomProperties() != null) {
            workflow.getCustomProperties().remove("instance.mode");
        }
    }

    public static enum WorkflowSheetColumn {
        PROJECT_ID("\u9879\u76ee\u7a7a\u95f4ID", false, false, true),
        WORKFLOW_ID("\u5de5\u4f5c\u6d41ID", false, true, true),
        WORKFLOW_NAME("\u5de5\u4f5c\u6d41\u540d\u79f0", false, true, true),
        TGT_WORKFLOW_ID("\u76ee\u6807\u7aef\u5de5\u4f5c\u6d41ID\uff08Writer\u5199\u5165\u540e\uff09", false, false, true),
        TGT_WORKFLOW_NAME("\u76ee\u6807\u7aef\u5de5\u4f5c\u6d41\u540d\u79f0\uff08Writer\u5199\u5165\u540e\uff09", false, false, true),
        CATEGORY_VALUE("\u8def\u5f84", false, true, false),
        IS_BUSSINESS("\u662f\u5426\u4e3a\u72ec\u7acb\u8282\u70b9\u96c6", true, true, false),
        OWNER("\u8d23\u4efb\u4eba", true, true, true),
        OWNER_TYPE("\u8d23\u4efb\u4eba\u7c7b\u578b", false, false, true),
        DESCRIPTION("\u5907\u6ce8", true, true, true),
        PARAM("\u8c03\u5ea6\u53c2\u6570\uff08JSON\u683c\u5f0f\uff09", true, true, true),
        CRON("\u8c03\u5ea6\u4fe1\u606f\uff08Cron\u8868\u8fbe\u5f0f\uff09", true, true, false),
        INSTANCE_MODE("\u5b9e\u4f8b\u751f\u6210\u65b9\u5f0f\uff08IMMEDIATELY/T_PLUS_1\uff09", true, true, true),
        NODE_COUNT("\u5305\u542b\u8282\u70b9\u7684\u4e2a\u6570", false, true, false),
        OFFLINE_STATE("\u4e0a\u7ebf\u72b6\u6001", false, true, true),
        SOURCE_ID("\u6e90\u7aefID\uff08\u82e5\u4efb\u52a1\u6d41\u7531\u8fc1\u79fb\u800c\u6765\uff09", false, true, false),
        EXTRA("\u6269\u5c55\u5b57\u6bb5", false, false, true);

        private String description;
        private Boolean canModify;
        private Boolean isForExcel;
        private Boolean isForSR;

        private WorkflowSheetColumn(String description, Boolean canModify, Boolean isForExcel, Boolean isForSR) {
            this.description = description;
            this.canModify = canModify;
            this.isForExcel = isForExcel;
            this.isForSR = isForSR;
        }

        public String getDescription() {
            return this.description;
        }

        public Boolean getCanModify() {
            return this.canModify;
        }

        public Boolean getIsForExcel() {
            return this.isForExcel;
        }

        public Boolean getIsForSR() {
            return this.isForSR;
        }

        public static WorkflowSheetColumn of(String colName) {
            for (WorkflowSheetColumn column : WorkflowSheetColumn.values()) {
                if (column.getDescription().equals(colName)) {
                    return column;
                }
                if (!column.name().equals(colName)) continue;
                return column;
            }
            return null;
        }
    }
}

