/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.oozie.convert;

import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.AbstractConvert;
import com.aliyun.migration.workflow.migration.common.convert.AbstractConvertFactory;
import com.aliyun.migration.workflow.migration.common.convert.DefaultNodeConvert;
import com.aliyun.migration.workflow.migration.common.type.OozieNodeType;
import com.workflow.migration.transform.dw.oozie.convert.DecisionNodeConvert;
import com.workflow.migration.transform.dw.oozie.convert.EndNodeConvert;
import com.workflow.migration.transform.dw.oozie.convert.ForkNodeConvert;
import com.workflow.migration.transform.dw.oozie.convert.HDFSNodeConvert;
import com.workflow.migration.transform.dw.oozie.convert.JavaNodeConvert;
import com.workflow.migration.transform.dw.oozie.convert.JoinNodeConvert;
import com.workflow.migration.transform.dw.oozie.convert.KillNodeConvert;
import com.workflow.migration.transform.dw.oozie.convert.MapReduceNodeConvert;
import com.workflow.migration.transform.dw.oozie.convert.PigNodeConvert;
import com.workflow.migration.transform.dw.oozie.convert.StartNodeConvert;
import com.workflow.migration.transform.dw.oozie.convert.SubworkflowNodeConvert;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OozieConvertFactory
extends AbstractConvertFactory {
    private static final Logger log = LoggerFactory.getLogger(OozieConvertFactory.class);

    public AbstractConvert<List<WorkflowNode>> getNodeListConvert(String taskTypeStr, TaskContext taskContext, Workflow workflow) {
        OozieNodeType taskType = OozieNodeType.of((String)taskTypeStr);
        if (taskType == null) {
            log.warn("not supported thie tasktype {}, use default convert", (Object)taskTypeStr);
            return new DefaultNodeConvert(taskContext, workflow);
        }
        switch (taskType) {
            case START: {
                return new StartNodeConvert(taskContext, workflow);
            }
            case END: {
                return new EndNodeConvert(taskContext, workflow);
            }
            case KILL: {
                return new KillNodeConvert(taskContext, workflow);
            }
            case DECISION: {
                return new DecisionNodeConvert(taskContext, workflow);
            }
            case FORK: {
                return new ForkNodeConvert(taskContext, workflow);
            }
            case JOIN: {
                return new JoinNodeConvert(taskContext, workflow);
            }
            case MAPREDUCE: {
                return new MapReduceNodeConvert(taskContext, workflow);
            }
            case PIG: {
                return new PigNodeConvert(taskContext, workflow);
            }
            case FS: {
                return new HDFSNodeConvert(taskContext, workflow);
            }
            case SUBWORKFLOW: {
                return new SubworkflowNodeConvert(taskContext, workflow);
            }
            case JAVA: {
                return new JavaNodeConvert(taskContext, workflow);
            }
        }
        return new DefaultNodeConvert(taskContext, workflow);
    }
}

