/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.dsv2.convert;

import com.aliyun.dataworks.common.spec.domain.dw.codemodel.EmrAllocationSpec;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.EmrCode;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.EmrLauncher;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.utils.ArgsUtils;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.model.ProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.model.ResourceInfo;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.mr.MapReduceParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.DataStudioCodeUtils;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.AbstractNodeConvert;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.common.base.Joiner;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MrNodeConvert
extends AbstractNodeConvert {
    private static final Logger log = LoggerFactory.getLogger(MrNodeConvert.class);
    public static final String MR_YARN_QUEUE = "mapreduce.job.queuename";

    public MrNodeConvert(TaskContext taskContext, Workflow workflow) {
        super(taskContext);
        this.workflow = workflow;
    }

    public List<WorkflowNode> convert(List<WorkflowNode> workflowNodes) {
        if (CollectionUtils.isEmpty(workflowNodes)) {
            log.warn("node convert workflowNodes is null");
            return new ArrayList<WorkflowNode>();
        }
        WorkflowNode workflowNode = workflowNodes.get(0);
        ArrayList<WorkflowNode> tgtNodes = new ArrayList<WorkflowNode>();
        WorkflowNode tgtworkflowNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)workflowNode, WorkflowNode.class);
        if (Objects.isNull(tgtworkflowNode)) {
            log.error("workflownode deepCopy error,{}", (Object)workflowNode.getNodeName());
            return null;
        }
        MapReduceParameters parameter = (MapReduceParameters)GsonUtils.fromJsonString((String)workflowNode.getScript(), (Type)TypeToken.get(MapReduceParameters.class).getType());
        String nodeType = this.getNodeType(workflowNode);
        tgtworkflowNode.setNodeType(nodeType);
        if (nodeType.equalsIgnoreCase(CodeProgramType.EMR_MR.name())) {
            this.convertEmrMr(parameter, tgtworkflowNode);
        } else if (nodeType.equalsIgnoreCase(CodeProgramType.ODPS_MR.name())) {
            this.convertOdpsMr(parameter, tgtworkflowNode);
        }
        this.supplyBaseMsg(tgtworkflowNode);
        tgtNodes.add(tgtworkflowNode);
        Map ownerMap = this.getOwnerMapping(this.bwmConfiguration);
        tgtNodes.forEach(node -> {
            if (ownerMap.containsKey(node.getOwner())) {
                node.setOwner((String)ownerMap.get(node.getOwner()));
            }
        });
        return tgtNodes;
    }

    private void convertEmrMr(MapReduceParameters parameter, WorkflowNode tgtworkflowNode) {
        String cmd = this.buildCommand(parameter);
        tgtworkflowNode.setScript(cmd);
        tgtworkflowNode.setScript(MrNodeConvert.wfToEmrCode((WorkflowNode)tgtworkflowNode));
    }

    private String buildCommand(MapReduceParameters mapreduceParameters) {
        List<String> args = MrNodeConvert.buildArgs(mapreduceParameters);
        String command = String.join((CharSequence)" ", args);
        log.info("mapreduce task command: {}", (Object)command);
        return command;
    }

    private static List<String> buildArgs(MapReduceParameters param) {
        String mainArgs;
        String yarnQueue;
        String others;
        String appName;
        String resourceName;
        ArrayList<String> args = new ArrayList<String>();
        ResourceInfo mainJar = param.getMainJar();
        if (mainJar != null && StringUtils.isNotEmpty((CharSequence)(resourceName = mainJar.getResourceName()))) {
            String[] resourceNames = resourceName.split("/");
            if (resourceNames.length > 0) {
                resourceName = resourceNames[resourceNames.length - 1];
            }
            String resource = DataStudioCodeUtils.addResourceReference((CodeProgramType)CodeProgramType.EMR_MR, (String)"", Arrays.asList(resourceName));
            args.add(resource + resourceName);
        }
        ProgramType programType = param.getProgramType();
        String mainClass = param.getMainClass();
        if (programType != null && programType != ProgramType.PYTHON && StringUtils.isNotEmpty((CharSequence)mainClass)) {
            args.add(mainClass);
        }
        if (StringUtils.isNotEmpty((CharSequence)(appName = param.getAppName()))) {
            args.add(String.format("%s%s=%s", "-D", "mapreduce.job.name", ArgsUtils.escape((String)appName)));
        }
        if ((StringUtils.isEmpty((CharSequence)(others = param.getOthers())) || !others.contains(MR_YARN_QUEUE)) && StringUtils.isNotEmpty((CharSequence)(yarnQueue = param.getYarnQueue()))) {
            args.add(String.format("%s%s=%s", "-D", MR_YARN_QUEUE, yarnQueue));
        }
        if (StringUtils.isNotEmpty((CharSequence)others)) {
            args.add(others);
        }
        if (StringUtils.isNotEmpty((CharSequence)(mainArgs = param.getMainArgs()))) {
            args.add(mainArgs);
        }
        return args;
    }

    private void convertOdpsMr(MapReduceParameters parameter, WorkflowNode tgtworkflowNode) {
        List resources = ListUtils.emptyIfNull((List)parameter.getResourceFilesList()).stream().filter(Objects::nonNull).map(ResourceInfo::getResourceName).filter(name -> StringUtils.isNotEmpty((CharSequence)name)).distinct().collect(Collectors.toList());
        ArrayList<String> codeLines = new ArrayList<String>();
        codeLines.add(DataStudioCodeUtils.addResourceReference((CodeProgramType)CodeProgramType.valueOf((String)tgtworkflowNode.getNodeType()), (String)"", resources));
        String command = Joiner.on((String)" ").join((Object)"jar", (Object)"-resources", new Object[]{Optional.ofNullable(parameter.getMainJar().getResourceName()).orElse(""), "-classpath", Joiner.on((String)",").join(resources), Optional.ofNullable(parameter.getMainClass()).orElse(""), Optional.ofNullable(parameter.getMainArgs()).orElse(""), Optional.ofNullable(parameter.getOthers()).orElse("")});
        codeLines.add(command);
        tgtworkflowNode.setScript(Joiner.on((String)"\n").join(codeLines));
        tgtworkflowNode.setScript(MrNodeConvert.wfToEmrCode((WorkflowNode)tgtworkflowNode));
        EmrCode emrCode = MrNodeConvert.wfNodeAsEmrCode((WorkflowNode)tgtworkflowNode);
        Optional.ofNullable(emrCode).map(EmrCode::getLauncher).map(EmrLauncher::getAllocationSpec).map(EmrAllocationSpec::of).ifPresent(spec -> {
            spec.setQueue(parameter.getYarnQueue());
            emrCode.getLauncher().setAllocationSpec(spec.toMap());
        });
    }

    protected String getNodeType(WorkflowNode workflowNode) {
        return this.getNodeConfMap(workflowNode).getOrDefault("workflow.converter.mrNodeType", CodeProgramType.EMR_MR.name());
    }
}

