/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.utils.cloud;

import com.aliyun.migration.teleport.cloud.entity.SinkProperties;
import com.aliyun.migration.teleport.cloud.enums.CloudAccessType;
import com.aliyun.migration.teleport.common.utils.PasswordUtil;
import org.springframework.util.StringUtils;

public class CallbackProperties {
    private CloudAccessType loginType;
    private String accessKeyId;
    private String accessKeySecret;
    private String securityToken;
    private String encryptIv;
    private String endpoint;
    private String regionId;
    private String topicName;

    public SinkProperties toSinkProperties() {
        return SinkProperties.builder().loginType(this.loginType).accessKeyId(this.accessKeyId).accessKeySecret(this.accessKeySecret).securityToken(this.securityToken).encryptIv(this.encryptIv).endpoint(this.endpoint).regionId(this.regionId).bucket(this.topicName).build();
    }

    public CallbackProperties encrypt() {
        try {
            this.encryptIv = PasswordUtil.getSecretKeyBase64();
            PasswordUtil.EncryptEntity encryptEntity = PasswordUtil.encryptWithAes256((String)this.accessKeySecret, (String)this.encryptIv);
            this.accessKeySecret = encryptEntity.getEncryptContent();
        }
        catch (Exception e) {
            this.encryptIv = null;
        }
        return this;
    }

    public void decrypt() {
        if (StringUtils.hasText((String)this.encryptIv)) {
            this.accessKeySecret = PasswordUtil.decryptWithAes256((String)this.accessKeySecret, (String)this.encryptIv);
            this.encryptIv = null;
        }
    }

    public static CallbackPropertiesBuilder builder() {
        return new CallbackPropertiesBuilder();
    }

    public CloudAccessType getLoginType() {
        return this.loginType;
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public String getAccessKeySecret() {
        return this.accessKeySecret;
    }

    public String getSecurityToken() {
        return this.securityToken;
    }

    public String getEncryptIv() {
        return this.encryptIv;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public void setLoginType(CloudAccessType loginType) {
        this.loginType = loginType;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public void setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
    }

    public void setSecurityToken(String securityToken) {
        this.securityToken = securityToken;
    }

    public void setEncryptIv(String encryptIv) {
        this.encryptIv = encryptIv;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setRegionId(String regionId) {
        this.regionId = regionId;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CallbackProperties)) {
            return false;
        }
        CallbackProperties other = (CallbackProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CloudAccessType this$loginType = this.getLoginType();
        CloudAccessType other$loginType = other.getLoginType();
        if (this$loginType == null ? other$loginType != null : !this$loginType.equals(other$loginType)) {
            return false;
        }
        String this$accessKeyId = this.getAccessKeyId();
        String other$accessKeyId = other.getAccessKeyId();
        if (this$accessKeyId == null ? other$accessKeyId != null : !this$accessKeyId.equals(other$accessKeyId)) {
            return false;
        }
        String this$accessKeySecret = this.getAccessKeySecret();
        String other$accessKeySecret = other.getAccessKeySecret();
        if (this$accessKeySecret == null ? other$accessKeySecret != null : !this$accessKeySecret.equals(other$accessKeySecret)) {
            return false;
        }
        String this$securityToken = this.getSecurityToken();
        String other$securityToken = other.getSecurityToken();
        if (this$securityToken == null ? other$securityToken != null : !this$securityToken.equals(other$securityToken)) {
            return false;
        }
        String this$encryptIv = this.getEncryptIv();
        String other$encryptIv = other.getEncryptIv();
        if (this$encryptIv == null ? other$encryptIv != null : !this$encryptIv.equals(other$encryptIv)) {
            return false;
        }
        String this$endpoint = this.getEndpoint();
        String other$endpoint = other.getEndpoint();
        if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
            return false;
        }
        String this$regionId = this.getRegionId();
        String other$regionId = other.getRegionId();
        if (this$regionId == null ? other$regionId != null : !this$regionId.equals(other$regionId)) {
            return false;
        }
        String this$topicName = this.getTopicName();
        String other$topicName = other.getTopicName();
        return !(this$topicName == null ? other$topicName != null : !this$topicName.equals(other$topicName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CallbackProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CloudAccessType $loginType = this.getLoginType();
        result = result * 59 + ($loginType == null ? 43 : $loginType.hashCode());
        String $accessKeyId = this.getAccessKeyId();
        result = result * 59 + ($accessKeyId == null ? 43 : $accessKeyId.hashCode());
        String $accessKeySecret = this.getAccessKeySecret();
        result = result * 59 + ($accessKeySecret == null ? 43 : $accessKeySecret.hashCode());
        String $securityToken = this.getSecurityToken();
        result = result * 59 + ($securityToken == null ? 43 : $securityToken.hashCode());
        String $encryptIv = this.getEncryptIv();
        result = result * 59 + ($encryptIv == null ? 43 : $encryptIv.hashCode());
        String $endpoint = this.getEndpoint();
        result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
        String $regionId = this.getRegionId();
        result = result * 59 + ($regionId == null ? 43 : $regionId.hashCode());
        String $topicName = this.getTopicName();
        result = result * 59 + ($topicName == null ? 43 : $topicName.hashCode());
        return result;
    }

    public String toString() {
        return "CallbackProperties(loginType=" + this.getLoginType() + ", accessKeyId=" + this.getAccessKeyId() + ", accessKeySecret=" + this.getAccessKeySecret() + ", securityToken=" + this.getSecurityToken() + ", encryptIv=" + this.getEncryptIv() + ", endpoint=" + this.getEndpoint() + ", regionId=" + this.getRegionId() + ", topicName=" + this.getTopicName() + ")";
    }

    public CallbackProperties() {
    }

    public CallbackProperties(CloudAccessType loginType, String accessKeyId, String accessKeySecret, String securityToken, String encryptIv, String endpoint, String regionId, String topicName) {
        this.loginType = loginType;
        this.accessKeyId = accessKeyId;
        this.accessKeySecret = accessKeySecret;
        this.securityToken = securityToken;
        this.encryptIv = encryptIv;
        this.endpoint = endpoint;
        this.regionId = regionId;
        this.topicName = topicName;
    }

    public static class CallbackPropertiesBuilder {
        private CloudAccessType loginType;
        private String accessKeyId;
        private String accessKeySecret;
        private String securityToken;
        private String encryptIv;
        private String endpoint;
        private String regionId;
        private String topicName;

        CallbackPropertiesBuilder() {
        }

        public CallbackPropertiesBuilder loginType(CloudAccessType loginType) {
            this.loginType = loginType;
            return this;
        }

        public CallbackPropertiesBuilder accessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        public CallbackPropertiesBuilder accessKeySecret(String accessKeySecret) {
            this.accessKeySecret = accessKeySecret;
            return this;
        }

        public CallbackPropertiesBuilder securityToken(String securityToken) {
            this.securityToken = securityToken;
            return this;
        }

        public CallbackPropertiesBuilder encryptIv(String encryptIv) {
            this.encryptIv = encryptIv;
            return this;
        }

        public CallbackPropertiesBuilder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public CallbackPropertiesBuilder regionId(String regionId) {
            this.regionId = regionId;
            return this;
        }

        public CallbackPropertiesBuilder topicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public CallbackProperties build() {
            return new CallbackProperties(this.loginType, this.accessKeyId, this.accessKeySecret, this.securityToken, this.encryptIv, this.endpoint, this.regionId, this.topicName);
        }

        public String toString() {
            return "CallbackProperties.CallbackPropertiesBuilder(loginType=" + this.loginType + ", accessKeyId=" + this.accessKeyId + ", accessKeySecret=" + this.accessKeySecret + ", securityToken=" + this.securityToken + ", encryptIv=" + this.encryptIv + ", endpoint=" + this.endpoint + ", regionId=" + this.regionId + ", topicName=" + this.topicName + ")";
        }
    }
}

