/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.utils;

import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.bean.BwmNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopoSortUtil {
    private static final Logger log = LoggerFactory.getLogger(TopoSortUtil.class);

    public static <T extends BwmNode> int[][] buildGraphFromChildren(List<T> nodes) {
        int size = nodes.size();
        HashMap<String, Integer> nodeIndexMap = new HashMap<String, Integer>();
        for (int i = 0; i < size; ++i) {
            nodeIndexMap.put(((BwmNode)nodes.get(i)).getId(), i);
        }
        int[][] graph = new int[size][size];
        for (int i = 0; i < size; ++i) {
            BwmNode node = (BwmNode)nodes.get(i);
            List<BwmNode> children = node.getChildren();
            if (org.springframework.util.CollectionUtils.isEmpty(children)) continue;
            for (BwmNode child : children) {
                Integer index = (Integer)nodeIndexMap.get(child.getId());
                graph[i][index.intValue()] = 1;
            }
        }
        return graph;
    }

    public static <T extends BwmNode> int[][] buildGraphFromParents(List<T> nodes) {
        int size = nodes.size();
        HashMap<String, Integer> nodeIndexMap = new HashMap<String, Integer>();
        for (int i = 0; i < size; ++i) {
            nodeIndexMap.put(((BwmNode)nodes.get(i)).getId(), i);
        }
        int[][] graph = new int[size][size];
        for (int i = 0; i < size; ++i) {
            BwmNode node = (BwmNode)nodes.get(i);
            List<BwmNode> parents = node.getParents();
            if (org.springframework.util.CollectionUtils.isEmpty(parents)) continue;
            for (BwmNode parent : parents) {
                Integer index = (Integer)nodeIndexMap.get(parent.getId());
                graph[index.intValue()][i] = 1;
            }
        }
        return graph;
    }

    public static <T extends BwmNode> List<List<T>> topologicalSort(List<T> nodes, boolean isFromChildren) {
        int size = nodes.size();
        if (size == 1) {
            return new ArrayList<List<T>>(Arrays.asList(nodes));
        }
        int[][] graph = TopoSortUtil.buildGraphFromChildren(nodes);
        if (!isFromChildren) {
            graph = TopoSortUtil.buildGraphFromParents(nodes);
        }
        int[] num = new int[size];
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < graph[i].length; ++j) {
                int n = j;
                num[n] = num[n] + graph[i][j];
            }
        }
        LinkedList<Integer> queue = new LinkedList<Integer>();
        for (int i = 0; i < size; ++i) {
            if (num[i] != 0) continue;
            queue.add(i);
        }
        int used = 0;
        ArrayList<List<T>> ans = new ArrayList<List<T>>(size);
        while (!queue.isEmpty()) {
            int curSize = queue.size();
            ArrayList<BwmNode> floors = new ArrayList<BwmNode>(curSize);
            for (int index = 0; index < curSize; ++index) {
                ++used;
                Integer i = (Integer)queue.poll();
                floors.add((BwmNode)nodes.get(i));
                for (int j = 0; j < graph[i].length; ++j) {
                    if (graph[i][j] != 1) continue;
                    int n = j;
                    num[n] = num[n] - 1;
                    if (num[n] != 0) continue;
                    queue.offer(j);
                }
            }
            ans.add(floors);
        }
        if (used != size) {
            log.warn("\u5b58\u5728\u5b64\u7acb\u8282\u70b9");
        }
        return ans;
    }

    public static <T extends BwmNode> List<List<T>> topologicalSort(List<Pair<String, String>> edges, List<T> nodes) {
        ArrayList<List<T>> sortResList = new ArrayList<List<T>>();
        HashMap<String, Integer> indegress = new HashMap<String, Integer>();
        HashMap adjacency = new HashMap();
        HashMap outAdjacency = new HashMap();
        Map<String, BwmNode> nodeMap = nodes.stream().collect(Collectors.toMap(BwmNode::getId, it -> it));
        for (Pair<String, String> pair : edges) {
            String outNodeId = (String)pair.getValue();
            String inNodeId = (String)pair.getKey();
            if (null == nodeMap.get(inNodeId) || null == nodeMap.get(outNodeId)) continue;
            Integer indegressValue = indegress.getOrDefault(outNodeId, 0);
            indegressValue = indegressValue + 1;
            indegress.put(outNodeId, indegressValue);
            adjacency.putIfAbsent(outNodeId, new ArrayList());
            ((List)adjacency.get(outNodeId)).add(inNodeId);
            outAdjacency.putIfAbsent(inNodeId, new ArrayList());
            ((List)outAdjacency.get(inNodeId)).add(outNodeId);
        }
        LinkedList<String> queue = new LinkedList<String>();
        for (String nodeId : nodeMap.keySet()) {
            Integer value = (Integer)indegress.get(nodeId);
            if (null != value && value != 0) continue;
            queue.offer(nodeId);
        }
        while (!queue.isEmpty()) {
            int n = queue.size();
            ArrayList<BwmNode> curfloors = new ArrayList<BwmNode>();
            for (int i = 0; i < n; ++i) {
                String curNodeId = (String)queue.poll();
                BwmNode t = nodeMap.get(curNodeId);
                if (Objects.nonNull(t)) {
                    curfloors.add(t);
                } else {
                    log.warn("relation not match node id {}", (Object)curNodeId);
                }
                List outAdjacencyList = (List)outAdjacency.get(curNodeId);
                if (org.springframework.util.CollectionUtils.isEmpty((Collection)outAdjacencyList)) continue;
                outAdjacencyList.forEach(x -> {
                    ((List)adjacency.get(x)).remove(curNodeId);
                    indegress.put((String)x, (Integer)indegress.get(x) - 1);
                    if (null == indegress.get(x) || (Integer)indegress.get(x) == 0) {
                        queue.offer((String)x);
                    }
                });
            }
            sortResList.add(curfloors);
        }
        return sortResList;
    }

    public static List<BwmNode> getSimpleNodes(List<WorkflowNode> workflowNodes) {
        ArrayList<BwmNode> res = new ArrayList<BwmNode>();
        if (CollectionUtils.isEmpty(workflowNodes)) {
            return res;
        }
        for (WorkflowNode workflowNode : workflowNodes) {
            if (Objects.isNull(workflowNode)) continue;
            BwmNode bwmNode = new BwmNode();
            bwmNode.setId(workflowNode.getNodeId());
            bwmNode.setName(workflowNode.getNodeName());
            bwmNode.setDisplayName(workflowNode.getNodeName());
            List children = workflowNode.getChildren();
            List<BwmNode> sortedNodes = TopoSortUtil.getSimpleNodes(children);
            bwmNode.setChildren(sortedNodes);
            res.add(bwmNode);
        }
        return res;
    }
}

